/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.build.gradle.tasks.annotations.Extractor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class TypedefCollector
extends ASTVisitor {
    private Map<String, List<Annotation>> mMap = Maps.newHashMap();
    private final boolean mRequireHide;
    private final boolean mRequireSourceRetention;
    private CompilationUnitDeclaration mCurrentUnit;
    private List<String> mPrivateTypedefs = Lists.newArrayList();

    public TypedefCollector(Collection<CompilationUnitDeclaration> units, boolean requireHide, boolean requireSourceRetention) {
        this.mRequireHide = requireHide;
        this.mRequireSourceRetention = requireSourceRetention;
        Iterator<CompilationUnitDeclaration> iterator = units.iterator();
        while (iterator.hasNext()) {
            CompilationUnitDeclaration unit;
            this.mCurrentUnit = unit = iterator.next();
            unit.traverse((ASTVisitor)this, unit.scope);
            this.mCurrentUnit = null;
        }
    }

    public List<String> getPrivateTypedefClasses() {
        return this.mPrivateTypedefs;
    }

    public Map<String, List<Annotation>> getTypedefs() {
        return this.mMap;
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        return this.recordTypedefs(memberTypeDeclaration);
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        return this.recordTypedefs(typeDeclaration);
    }

    private boolean recordTypedefs(TypeDeclaration declaration) {
        SourceTypeBinding binding = declaration.binding;
        if (binding == null) {
            return false;
        }
        Annotation[] annotations = declaration.annotations;
        if (annotations != null && declaration.binding.isAnnotationType()) {
            for (Annotation annotation : annotations) {
                String typeName = Extractor.getFqn(annotation);
                if (typeName == null || !Extractor.isNestedAnnotation(typeName)) continue;
                String fqn = new String(binding.readableName());
                List<Annotation> list = this.mMap.get(fqn);
                if (list == null) {
                    list = new ArrayList<Annotation>(2);
                    this.mMap.put(fqn, list);
                }
                list.add(annotation);
                if (this.mRequireHide && !TypedefCollector.javadocContainsHide(declaration.javadoc)) {
                    Extractor.warning(this.getFileName() + ": The typedef annotation " + fqn + " should specify @hide in a doc comment");
                }
                if (this.mRequireSourceRetention && !Extractor.hasSourceRetention(annotations)) {
                    Extractor.warning(this.getFileName() + ": The typedef annotation " + fqn + " should have @Retention(RetentionPolicy.SOURCE)");
                }
                if (declaration.binding == null || !TypedefCollector.isHiddenTypeDef(declaration)) continue;
                StringBuilder sb = new StringBuilder(100);
                for (char c : declaration.binding.qualifiedPackageName()) {
                    if (c == '.') {
                        sb.append('/');
                        continue;
                    }
                    sb.append(c);
                }
                sb.append('/');
                for (char c : declaration.binding.qualifiedSourceName()) {
                    if (c == '.') {
                        sb.append('$');
                        continue;
                    }
                    sb.append(c);
                }
                String cls = sb.toString();
                if (this.mPrivateTypedefs.contains(cls)) continue;
                this.mPrivateTypedefs.add(cls);
            }
        }
        return true;
    }

    public static boolean isHiddenTypeDef(TypeDeclaration declaration) {
        return (declaration.modifiers & 1) == 0;
    }

    private static boolean javadocContainsHide(Javadoc javadoc) {
        if (javadoc != null) {
            StringBuffer stringBuffer = new StringBuffer(200);
            javadoc.print(0, stringBuffer);
            String documentation = stringBuffer.toString();
            if (documentation.contains("@hide")) {
                return true;
            }
        }
        return false;
    }

    private String getFileName() {
        return new String(this.mCurrentUnit.getFileName());
    }
}

