/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.CompileOptions;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import org.gradle.api.JavaVersion;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.compile.AbstractCompile;

public class AbstractCompilesUtil {
    public static void configureLanguageLevel(AbstractCompile compileTask, CompileOptions compileOptions, String compileSdkVersion, boolean jackEnabled) {
        AbstractCompilesUtil.setDefaultJavaVersion(compileOptions, compileSdkVersion, jackEnabled);
        compileTask.setSourceCompatibility(compileOptions.getSourceCompatibility().toString());
        compileTask.setTargetCompatibility(compileOptions.getTargetCompatibility().toString());
    }

    public static void setDefaultJavaVersion(CompileOptions compileOptions, String compileSdkVersion, boolean jackEnabled) {
        Integer compileSdkLevel;
        AndroidVersion hash = AndroidTargetHash.getVersionFromHash((String)compileSdkVersion);
        Integer n = compileSdkLevel = hash == null ? null : Integer.valueOf(hash.getFeatureLevel());
        JavaVersion javaVersionToUse = compileSdkLevel == null ? JavaVersion.VERSION_1_6 : (0 < compileSdkLevel && compileSdkLevel <= 20 ? JavaVersion.VERSION_1_6 : (21 <= compileSdkLevel && compileSdkLevel < 24 ? JavaVersion.VERSION_1_7 : (jackEnabled ? JavaVersion.VERSION_1_8 : JavaVersion.VERSION_1_7)));
        JavaVersion jdkVersion = JavaVersion.toVersion((Object)System.getProperty("java.specification.version"));
        if (jdkVersion.compareTo((Enum)javaVersionToUse) < 0) {
            Logging.getLogger(AbstractCompilesUtil.class).warn("Default language level for compileSdkVersion '{}' is {}, but the JDK used is {}, so the JDK language level will be used.", new Object[]{compileSdkVersion, javaVersionToUse, jdkVersion});
            javaVersionToUse = jdkVersion;
        }
        compileOptions.setDefaultJavaVersion(javaVersionToUse);
    }
}

