/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dsl.CoreAnnotationProcessorOptions;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.builder.core.VariantType;
import com.android.builder.model.AndroidLibrary;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.compile.AbstractCompile;

public class JavaCompileConfigAction
implements TaskConfigAction<AndroidJavaCompile> {
    private static final ILogger LOG = LoggerWrapper.getLogger(JavaCompileConfigAction.class);
    private VariantScope scope;

    public JavaCompileConfigAction(VariantScope scope) {
        this.scope = scope;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("compile", "JavaWithJavac");
    }

    @Override
    public Class<AndroidJavaCompile> getType() {
        return AndroidJavaCompile.class;
    }

    @Override
    public void execute(AndroidJavaCompile javacTask) {
        boolean incremental;
        boolean keepDefaultBootstrap;
        final BaseVariantData testedVariantData = this.scope.getTestedVariantData();
        this.scope.getVariantData().javacTask = javacTask;
        javacTask.compileSdkVersion = this.scope.getGlobalScope().getExtension().getCompileSdkVersion();
        javacTask.mBuildContext = this.scope.getInstantRunBuildContext();
        for (ConfigurableFileTree fileTree : this.scope.getVariantData().getJavaSources()) {
            javacTask.source(new Object[]{fileTree});
        }
        boolean bl = keepDefaultBootstrap = this.scope.getVariantConfiguration().getJackOptions().isEnabled() != false && JavaVersion.current().isJava8Compatible();
        if (!keepDefaultBootstrap) {
            javacTask.getOptions().setBootClasspath(Joiner.on((String)File.pathSeparator).join((Iterable)this.scope.getGlobalScope().getAndroidBuilder().getBootClasspathAsStrings(false)));
        }
        ConventionMappingHelper.map((Task)javacTask, "classpath", new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                FileCollection classpath = JavaCompileConfigAction.this.scope.getJavaClasspath();
                Project project = JavaCompileConfigAction.this.scope.getGlobalScope().getProject();
                if (keepDefaultBootstrap) {
                    classpath = classpath.plus((FileCollection)project.files(new Object[]{JavaCompileConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getBootClasspath(false)}));
                }
                if (testedVariantData != null) {
                    AndroidLibrary testedLibrary;
                    if (!testedVariantData.getType().equals((Object)VariantType.LIBRARY) || JavaCompileConfigAction.this.scope.getVariantData().getType().equals((Object)VariantType.UNIT_TEST)) {
                        classpath = classpath.plus((FileCollection)project.files(new Object[]{testedVariantData.getScope().getJavaClasspath(), testedVariantData.getScope().getJavaOutputDir(), testedVariantData.getScope().getJavaDependencyCache()}));
                    }
                    if (JavaCompileConfigAction.this.scope.getVariantData().getType().equals((Object)VariantType.UNIT_TEST) && testedVariantData.getType().equals((Object)VariantType.LIBRARY) && (testedLibrary = testedVariantData.getVariantConfiguration().getOutput()) != null) {
                        File jarFile = testedLibrary.getJarFile();
                        classpath = classpath.minus((FileCollection)project.files(new Object[]{jarFile}));
                    }
                }
                return classpath;
            }
        });
        javacTask.setDestinationDir(this.scope.getJavaOutputDir());
        javacTask.setDependencyCacheDir(this.scope.getJavaDependencyCache());
        CompileOptions compileOptions = this.scope.getGlobalScope().getExtension().getCompileOptions();
        AbstractCompilesUtil.configureLanguageLevel((AbstractCompile)javacTask, compileOptions, this.scope.getGlobalScope().getExtension().getCompileSdkVersion(), this.scope.getVariantConfiguration().getJackOptions().isEnabled());
        javacTask.getOptions().setEncoding(compileOptions.getEncoding());
        GlobalScope globalScope = this.scope.getGlobalScope();
        Project project = this.scope.getGlobalScope().getProject();
        CoreAnnotationProcessorOptions annotationProcessorOptions = this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions();
        Preconditions.checkNotNull((Object)annotationProcessorOptions.getIncludeCompileClasspath());
        ArrayList processorPath = Lists.newArrayList(this.scope.getVariantData().getVariantDependency().resolveAndGetAnnotationProcessorClassPath(annotationProcessorOptions.getIncludeCompileClasspath(), this.scope.getGlobalScope().getAndroidBuilder().getErrorReporter()));
        if (compileOptions.getIncremental() != null) {
            incremental = compileOptions.getIncremental();
            LOG.info("Incremental flag set to %1$b in DSL", new Object[]{incremental});
        } else if (globalScope.getExtension().getDataBinding().isEnabled() || !processorPath.isEmpty() || project.getPlugins().hasPlugin("com.neenbedankt.android-apt") || project.getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            incremental = false;
            LOG.info("Incremental Java compilation disabled in variant %1$s as you are using an incompatible plugin", new Object[]{this.scope.getVariantConfiguration().getFullName()});
        } else if (this.scope.getTestedVariantData() != null) {
            incremental = false;
        } else {
            ArrayList<File> sourceFolders = new ArrayList<File>();
            for (ConfigurableFileTree sourceFolder : this.scope.getVariantData().getUserJavaSources()) {
                if (!sourceFolder.getDir().exists()) continue;
                sourceFolders.add(sourceFolder.getDir());
            }
            boolean bl2 = incremental = sourceFolders.size() == 1;
            if (sourceFolders.size() > 1) {
                LOG.info("Incremental Java compilation disabled in variant %1$s as you are using %2$d source folders : %3$s", new Object[]{this.scope.getVariantConfiguration().getFullName(), sourceFolders.size(), Joiner.on((char)',').join(sourceFolders)});
            }
        }
        if (AndroidGradleOptions.isJavaCompileIncrementalPropertySet(project)) {
            this.scope.getGlobalScope().getAndroidBuilder().getErrorReporter().handleSyncError(null, 0, String.format("The %s property has been replaced by a DSL property. Please add the following to your build.gradle instead:\nandroid {\n  compileOptions.incremental = false\n}", "android.incrementalJavaCompile"));
        }
        if (incremental) {
            LOG.info("Using incremental javac compilation.", new Object[0]);
            javacTask.getOptions().setIncremental(true);
        } else {
            LOG.info("Not using incremental javac compilation.", new Object[0]);
        }
        if (!processorPath.isEmpty()) {
            if (Boolean.TRUE.equals(annotationProcessorOptions.getIncludeCompileClasspath())) {
                processorPath.addAll(javacTask.getClasspath().getFiles());
            }
            javacTask.getOptions().getCompilerArgs().add("-processorpath");
            javacTask.getOptions().getCompilerArgs().add(FileUtils.joinFilePaths((Iterable)processorPath));
        }
        if (!annotationProcessorOptions.getClassNames().isEmpty()) {
            javacTask.getOptions().getCompilerArgs().add("-processor");
            javacTask.getOptions().getCompilerArgs().add(Joiner.on((char)',').join(annotationProcessorOptions.getClassNames()));
        }
        if (!annotationProcessorOptions.getArguments().isEmpty()) {
            for (Map.Entry<String, String> arg : annotationProcessorOptions.getArguments().entrySet()) {
                javacTask.getOptions().getCompilerArgs().add("-A" + arg.getKey() + "=" + arg.getValue());
            }
        }
        javacTask.doFirst(task -> FileUtils.mkdirs((File)this.scope.getAnnotationProcessorOutputDir()));
        javacTask.getOptions().getCompilerArgs().add("-s");
        javacTask.getOptions().getCompilerArgs().add(this.scope.getAnnotationProcessorOutputDir().getAbsolutePath());
    }
}

