/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.backwardRefs.OccurrenceCounter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.Queue;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerBackwardReferenceIndex;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompilerIndices;

class CompilerReferenceReader {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceReader.class);
    private final CompilerBackwardReferenceIndex myIndex;
    private final File myBuildDir;

    private CompilerReferenceReader(File buildDir) {
        this.myIndex = new CompilerBackwardReferenceIndex(buildDir, true);
        this.myBuildDir = buildDir;
    }

    @Nullable
    TIntHashSet findReferentFileIds(@NotNull LightRef ref, boolean checkBaseClassAmbiguity) throws StorageException {
        LightRef.NamedLightRef[] hierarchy;
        if (ref == null) {
            CompilerReferenceReader.$$$reportNull$$$0(0);
        }
        if (ref instanceof LightRef.LightClassHierarchyElementDef) {
            hierarchy = new LightRef.NamedLightRef[]{(LightRef.NamedLightRef)ref};
        } else {
            LightRef.LightClassHierarchyElementDef hierarchyElement = ((LightRef.LightMember)ref).getOwner();
            hierarchy = this.getHierarchy(hierarchyElement, checkBaseClassAmbiguity, false, -1);
        }
        if (hierarchy == null) {
            return null;
        }
        TIntHashSet set = new TIntHashSet();
        for (LightRef.NamedLightRef aClass : hierarchy) {
            LightRef overriderUsage = ref.override(aClass.getName());
            this.addUsages(overriderUsage, set);
        }
        return set;
    }

    @NotNull
    Map<VirtualFile, SearchId[]> getDirectInheritors(@NotNull LightRef searchElement, @NotNull GlobalSearchScope searchScope, @NotNull GlobalSearchScope dirtyScope, @NotNull FileType fileType, @NotNull CompilerHierarchySearchType searchType) throws StorageException {
        if (searchElement == null) {
            CompilerReferenceReader.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            CompilerReferenceReader.$$$reportNull$$$0(2);
        }
        if (dirtyScope == null) {
            CompilerReferenceReader.$$$reportNull$$$0(3);
        }
        if (fileType == null) {
            CompilerReferenceReader.$$$reportNull$$$0(4);
        }
        if (searchType == null) {
            CompilerReferenceReader.$$$reportNull$$$0(5);
        }
        GlobalSearchScope effectiveSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)dirtyScope).intersectWith(searchScope);
        LanguageLightRefAdapter adapter = LanguageLightRefAdapter.findAdapter(fileType);
        LOG.assertTrue(adapter != null, (Object)("adapter is null for file type: " + fileType));
        Class<? extends LightRef> requiredLightRefClass = searchType.getRequiredClass(adapter);
        HashMap candidatesPerFile = new HashMap();
        this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)searchElement).forEach((fileId, defs) -> {
            if (searchType == null) {
                CompilerReferenceReader.$$$reportNull$$$0(18);
            }
            List<LightRef> requiredCandidates = defs.stream().filter(requiredLightRefClass::isInstance).collect(Collectors.toList());
            if (requiredCandidates.isEmpty()) {
                return true;
            }
            VirtualFile file = this.findFile(fileId);
            if (file != null && effectiveSearchScope.contains(file)) {
                candidatesPerFile.put(file, searchType.convertToIds(requiredCandidates, this.myIndex.getByteSeqEum()));
            }
            return true;
        });
        Map<Object, Object> map2 = candidatesPerFile.isEmpty() ? Collections.emptyMap() : candidatesPerFile;
        if (map2 == null) {
            CompilerReferenceReader.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @Nullable
    Integer getAnonymousCount(@NotNull LightRef.LightClassHierarchyElementDef classDef, boolean checkDefinitions) {
        if (classDef == null) {
            CompilerReferenceReader.$$$reportNull$$$0(7);
        }
        try {
            if (checkDefinitions && this.getDefinitionCount((LightRef.NamedLightRef)classDef) != DefCount.ONE) {
                return null;
            }
            final int[] count = new int[]{0};
            this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)classDef).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Collection<LightRef>>(){

                public boolean perform(int id, Collection<LightRef> value) {
                    count[0] = count[0] + value.size();
                    return true;
                }
            });
            return count[0];
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    int getOccurrenceCount(@NotNull LightRef element) {
        if (element == null) {
            CompilerReferenceReader.$$$reportNull$$$0(8);
        }
        try {
            final int[] result = new int[]{0};
            this.myIndex.get(CompilerIndices.BACK_USAGES).getData((Object)element).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Integer>(){

                public boolean perform(int id, Integer value) {
                    result[0] = result[0] + value;
                    return true;
                }
            });
            return result[0];
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    List<LightRef> getMembersFor(@NotNull SignatureData data) {
        ArrayList<LightRef> arrayList;
        if (data == null) {
            CompilerReferenceReader.$$$reportNull$$$0(9);
        }
        try {
            ArrayList<LightRef> result = new ArrayList<LightRef>();
            this.myIndex.get(CompilerIndices.BACK_MEMBER_SIGN).getData((Object)data).forEach((id, refs) -> {
                result.addAll((Collection<LightRef>)refs);
                return true;
            });
            arrayList = result;
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        if (arrayList == null) {
            CompilerReferenceReader.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    TIntHashSet getAllContainingFileIds(@NotNull LightRef ref) throws StorageException {
        if (ref == null) {
            CompilerReferenceReader.$$$reportNull$$$0(11);
        }
        TIntHashSet tIntHashSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.myIndex.get(CompilerIndices.BACK_USAGES), Collections.singletonList(ref), null, null, null);
        if (tIntHashSet == null) {
            CompilerReferenceReader.$$$reportNull$$$0(12);
        }
        return tIntHashSet;
    }

    @NotNull
    NameEnumerator getNameEnumerator() {
        NameEnumerator nameEnumerator = this.myIndex.getByteSeqEum();
        if (nameEnumerator == null) {
            CompilerReferenceReader.$$$reportNull$$$0(13);
        }
        return nameEnumerator;
    }

    void close(boolean removeIndex) {
        this.myIndex.close();
        if (removeIndex) {
            CompilerBackwardReferenceIndex.removeIndexFiles((File)this.myBuildDir);
        }
    }

    public CompilerBackwardReferenceIndex getIndex() {
        return this.myIndex;
    }

    @NotNull
    OccurrenceCounter<LightRef> getTypeCastOperands(@NotNull LightRef.LightClassHierarchyElementDef castType, final @Nullable TIntHashSet fileIds) throws StorageException {
        if (castType == null) {
            CompilerReferenceReader.$$$reportNull$$$0(14);
        }
        final OccurrenceCounter<LightRef> result = new OccurrenceCounter<LightRef>();
        this.myIndex.get(CompilerIndices.BACK_CAST).getData((Object)castType).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Collection<LightRef>>(){

            public boolean perform(int id, Collection<LightRef> values) {
                if (fileIds != null && !fileIds.contains(id)) {
                    return true;
                }
                for (LightRef ref : values) {
                    result.add(ref);
                }
                return true;
            }
        });
        OccurrenceCounter<LightRef> occurrenceCounter = result;
        if (occurrenceCounter == null) {
            CompilerReferenceReader.$$$reportNull$$$0(15);
        }
        return occurrenceCounter;
    }

    static boolean exists(Project project2) {
        File buildDir = BuildManager.getInstance().getProjectSystemDirectory(project2);
        if (buildDir == null || CompilerBackwardReferenceIndex.versionDiffers((File)buildDir)) {
            return false;
        }
        return CompilerBackwardReferenceIndex.exist((File)buildDir);
    }

    static CompilerReferenceReader create(Project project2) {
        if (!CompilerReferenceReader.exists(project2)) {
            return null;
        }
        try {
            return new CompilerReferenceReader(BuildManager.getInstance().getProjectSystemDirectory(project2));
        }
        catch (RuntimeException e) {
            LOG.error("An exception while initialization of compiler reference index.", (Throwable)e);
            return null;
        }
    }

    private void addUsages(LightRef usage, final TIntHashSet sink) throws StorageException {
        this.myIndex.get(CompilerIndices.BACK_USAGES).getData((Object)usage).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Integer>(){

            public boolean perform(int id, Integer value) {
                VirtualFile file = CompilerReferenceReader.this.findFile(id);
                if (file != null) {
                    sink.add(((VirtualFileWithId)file).getId());
                }
                return true;
            }
        });
    }

    private VirtualFile findFile(int id) {
        try {
            String path = this.myIndex.getFilePathEnumerator().valueOf(id);
            assert (path != null);
            return VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable(value="return null if the class hierarchy contains ambiguous qualified names")
    LightRef.LightClassHierarchyElementDef[] getHierarchy(LightRef.LightClassHierarchyElementDef hierarchyElement, boolean checkBaseClassAmbiguity, boolean includeAnonymous, int interruptNumber) {
        try {
            THashSet result = new THashSet();
            Queue q = new Queue(10);
            q.addLast((Object)hierarchyElement);
            while (!q.isEmpty()) {
                LightRef.LightClassHierarchyElementDef curClass = (LightRef.LightClassHierarchyElementDef)q.pullFirst();
                if (interruptNumber != -1 && result.size() > interruptNumber) break;
                if (!result.add(curClass)) continue;
                if (result.size() % 100 == 0) {
                    ProgressManager.checkCanceled();
                }
                if (!(curClass instanceof LightRef.LightAnonymousClassDef) && (checkBaseClassAmbiguity || curClass != hierarchyElement) && this.hasMultipleDefinitions((LightRef.NamedLightRef)curClass)) {
                    return null;
                }
                this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)curClass).forEach((id, children) -> {
                    for (LightRef child : children) {
                        if (!(child instanceof LightRef.LightClassHierarchyElementDef) || !includeAnonymous && child instanceof LightRef.LightAnonymousClassDef) continue;
                        q.addLast((Object)((LightRef.LightClassHierarchyElementDef)child));
                    }
                    return true;
                });
            }
            return result.toArray(LightRef.LightClassHierarchyElementDef.EMPTY_ARRAY);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    LightRef.LightClassHierarchyElementDef[] getDirectInheritors(LightRef.LightClassHierarchyElementDef hierarchyElement) throws StorageException {
        THashSet result = new THashSet();
        this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)hierarchyElement).forEach((arg_0, arg_1) -> CompilerReferenceReader.lambda$getDirectInheritors$3((Set)result, arg_0, arg_1));
        LightRef.LightClassHierarchyElementDef[] lightClassHierarchyElementDefArray = result.toArray(LightRef.LightClassHierarchyElementDef.EMPTY_ARRAY);
        if (lightClassHierarchyElementDefArray == null) {
            CompilerReferenceReader.$$$reportNull$$$0(16);
        }
        return lightClassHierarchyElementDefArray;
    }

    private boolean hasMultipleDefinitions(LightRef.NamedLightRef def) throws StorageException {
        DefCount count = this.getDefinitionCount(def);
        if (count == DefCount.NONE) {
            String name2 = def instanceof LightRef.LightAnonymousClassDef ? String.valueOf(def.getName()) : this.getNameEnumerator().getName(def.getName());
            LOG.error("Can't get definition files for: " + name2 + ", class: " + def.getClass());
        }
        return count == DefCount.MANY;
    }

    @NotNull
    private DefCount getDefinitionCount(LightRef.NamedLightRef def) throws StorageException {
        final DefCount[] result = new DefCount[]{DefCount.NONE};
        this.myIndex.get(CompilerIndices.BACK_CLASS_DEF).getData((Object)def).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Void>(){

            public boolean perform(int id, Void value) {
                if (result[0] == DefCount.NONE) {
                    result[0] = DefCount.ONE;
                    return true;
                }
                if (result[0] == DefCount.ONE) {
                    result[0] = DefCount.MANY;
                    return true;
                }
                return false;
            }
        });
        DefCount defCount = result[0];
        if (defCount == null) {
            CompilerReferenceReader.$$$reportNull$$$0(17);
        }
        return defCount;
    }

    private static /* synthetic */ boolean lambda$getDirectInheritors$3(Set result, int id, Collection children) {
        for (LightRef child : children) {
            if (!(child instanceof LightRef.LightClassHierarchyElementDef) || child instanceof LightRef.LightAnonymousClassDef) continue;
            result.add((LightRef.LightClassHierarchyElementDef)child);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/CompilerReferenceReader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDef";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceReader";
                break;
            }
            case 6: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectInheritors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersFor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContainingFileIds";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameEnumerator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCastOperands";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findReferentFileIds";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirectInheritors";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousCount";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMembersFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllContainingFileIds";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCastOperands";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDirectInheritors$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum DefCount {
        NONE,
        ONE,
        MANY;

    }
}

