/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslatingCompilerFilesMonitor {
    public TranslatingCompilerFilesMonitor(VirtualFileManager vfsManager, Application application) {
        vfsManager.addVirtualFileListener((VirtualFileListener)new MyVfsListener(), (Disposable)application);
    }

    public static TranslatingCompilerFilesMonitor getInstance() {
        return (TranslatingCompilerFilesMonitor)ApplicationManager.getApplication().getComponent(TranslatingCompilerFilesMonitor.class);
    }

    private static void processRecursively(final VirtualFile fromFile, final boolean dbOnly, final FileProcessor processor2) {
        if (!(fromFile.getFileSystem() instanceof LocalFileSystem)) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)fromFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (!file.isDirectory()) {
                    processor2.execute(file);
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                return result;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (dbOnly) {
                    return file.isDirectory() ? ((NewVirtualFile)file).iterInDbChildren() : null;
                }
                if (file.equals(fromFile) || !file.isDirectory()) {
                    return null;
                }
                return TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file) ? null : ((NewVirtualFile)file).iterInDbChildren();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildrenIterable";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean isInContentOfOpenedProject(@NotNull VirtualFile file) {
        if (file == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(0);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (!project2.isInitialized() || !BuildManager.getInstance().isProjectWatched(project2) || !ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file)) continue;
            return true;
        }
        return false;
    }

    private static void collectPathsAndNotify(VirtualFile file, Consumer<Collection<File>> notification) {
        if (!TranslatingCompilerFilesMonitor.isIgnoredOrUnderIgnoredDirectory(file)) {
            THashSet pathsToMark = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            TranslatingCompilerFilesMonitor.processRecursively(file, !TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file), arg_0 -> TranslatingCompilerFilesMonitor.lambda$collectPathsAndNotify$0((Set)pathsToMark, arg_0));
            notification.consume((Object)pathsToMark);
        }
    }

    private static boolean isIgnoredOrUnderIgnoredDirectory(VirtualFile file) {
        if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file)) {
            return true;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (VirtualFile current = file.getParent(); current != null; current = current.getParent()) {
            if (!fileTypeManager.isFileIgnored(current)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoredByBuild(VirtualFile file) {
        return FileTypeManager.getInstance().isFileIgnored(file) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file) || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)file.getPath(), (boolean)false);
    }

    private static void notifyFilesChanged(Collection<File> paths) {
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesChanged(paths);
        }
    }

    private static void notifyFilesDeleted(Collection<File> paths) {
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesDeleted(paths);
        }
    }

    private static /* synthetic */ void lambda$collectPathsAndNotify$0(Set pathsToMark, VirtualFile f) {
        pathsToMark.add(new File(f.getPath()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor", "isInContentOfOpenedProject"));
    }

    private static class MyVfsListener
    implements VirtualFileListener {
        private MyVfsListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile eventFile;
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(0);
            }
            if ("name".equals(event.getPropertyName()) && TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(eventFile = event.getFile())) {
                VirtualFile parent = event.getParent();
                if (parent != null) {
                    String oldName = (String)event.getOldValue();
                    final String root = parent.getPath() + "/" + oldName;
                    THashSet toMark = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    if (eventFile.isDirectory()) {
                        VfsUtilCore.visitChildrenRecursively((VirtualFile)eventFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Set)toMark){
                            private final StringBuilder filePath;
                            final /* synthetic */ Set val$toMark;
                            {
                                this.val$toMark = set;
                                super(arg0);
                                this.filePath = new StringBuilder(root);
                            }

                            public boolean visitFile(@NotNull VirtualFile child) {
                                if (child == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (child.isDirectory()) {
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        this.filePath.append("/").append(child.getName());
                                    }
                                } else {
                                    String childPath = this.filePath.toString();
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        childPath = childPath + "/" + child.getName();
                                    }
                                    this.val$toMark.add(new File(childPath));
                                }
                                return true;
                            }

                            public void afterChildrenVisited(@NotNull VirtualFile file) {
                                if (file == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (file.isDirectory() && !Comparing.equal((Object)file, (Object)eventFile)) {
                                    this.filePath.delete(this.filePath.length() - file.getName().length() - 1, this.filePath.length());
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "child";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "file";
                                        break;
                                    }
                                }
                                objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener$1";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "visitFile";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "afterChildrenVisited";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                    } else {
                        toMark.add(new File(root));
                    }
                    TranslatingCompilerFilesMonitor.notifyFilesDeleted((Collection)toMark);
                }
                TranslatingCompilerFilesMonitor.collectPathsAndNotify(eventFile, (Consumer<Collection<File>>)x$0 -> TranslatingCompilerFilesMonitor.notifyFilesChanged(x$0));
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(1);
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Consumer<Collection<File>>)x$0 -> TranslatingCompilerFilesMonitor.notifyFilesChanged(x$0));
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(2);
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Consumer<Collection<File>>)x$0 -> TranslatingCompilerFilesMonitor.notifyFilesChanged(x$0));
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(3);
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Consumer<Collection<File>>)x$0 -> TranslatingCompilerFilesMonitor.notifyFilesChanged(x$0));
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(4);
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Consumer<Collection<File>>)x$0 -> TranslatingCompilerFilesMonitor.notifyFilesChanged(x$0));
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(5);
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Consumer<Collection<File>>)x$0 -> TranslatingCompilerFilesMonitor.notifyFilesDeleted(x$0));
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(6);
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Consumer<Collection<File>>)x$0 -> TranslatingCompilerFilesMonitor.notifyFilesDeleted(x$0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface FileProcessor {
        public void execute(VirtualFile var1);
    }
}

