/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.generic;

import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class GenericCompilerCache<Key, SourceState, OutputState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.generic.GenericCompilerCache");
    private PersistentHashMap<KeyAndTargetData<Key>, PersistentStateData<SourceState, OutputState>> myPersistentMap;
    private final File myCacheFile;
    private final GenericCompiler<Key, SourceState, OutputState> myCompiler;

    public GenericCompilerCache(GenericCompiler<Key, SourceState, OutputState> compiler, File compilerCacheDir) throws IOException {
        this.myCompiler = compiler;
        this.myCacheFile = new File(compilerCacheDir, "timestamps");
        this.createMap();
    }

    private void createMap() throws IOException {
        try {
            this.myPersistentMap = new PersistentHashMap(this.myCacheFile, (KeyDescriptor)new SourceItemDataDescriptor(this.myCompiler.getItemKeyDescriptor()), (DataExternalizer)new PersistentStateDataExternalizer(this.myCompiler));
        }
        catch (PersistentEnumeratorBase.CorruptedException e) {
            FileUtil.delete((File)this.myCacheFile);
            throw e;
        }
    }

    private KeyAndTargetData<Key> getKeyAndTargetData(Key key, int target) {
        return new KeyAndTargetData(target, key);
    }

    public void wipe() throws IOException {
        try {
            this.myPersistentMap.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith((File)this.myCacheFile);
        this.createMap();
    }

    public void close() {
        try {
            this.myPersistentMap.close();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public void remove(int targetId, Key key) throws IOException {
        this.myPersistentMap.remove(this.getKeyAndTargetData(key, targetId));
    }

    public PersistentStateData<SourceState, OutputState> getState(int targetId, Key key) throws IOException {
        return (PersistentStateData)this.myPersistentMap.get(this.getKeyAndTargetData(key, targetId));
    }

    public void processSources(int targetId, Processor<Key> processor2) throws IOException {
        this.myPersistentMap.processKeysWithExistingMapping(data -> targetId == data.myTarget ? processor2.process(data.myKey) : true);
    }

    public void putState(int targetId, @NotNull Key key, @NotNull SourceState sourceState, @NotNull OutputState outputState) throws IOException {
        if (key == null) {
            GenericCompilerCache.$$$reportNull$$$0(0);
        }
        if (sourceState == null) {
            GenericCompilerCache.$$$reportNull$$$0(1);
        }
        if (outputState == null) {
            GenericCompilerCache.$$$reportNull$$$0(2);
        }
        this.myPersistentMap.put(this.getKeyAndTargetData(key, targetId), new PersistentStateData(sourceState, outputState));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "outputState";
                break;
            }
        }
        objectArray[1] = "com/intellij/compiler/impl/generic/GenericCompilerCache";
        objectArray[2] = "putState";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class PersistentStateDataExternalizer
    implements DataExternalizer<PersistentStateData<SourceState, OutputState>> {
        private final DataExternalizer<SourceState> mySourceStateExternalizer;
        private final DataExternalizer<OutputState> myOutputStateExternalizer;

        public PersistentStateDataExternalizer(GenericCompiler<Key, SourceState, OutputState> compiler) {
            this.mySourceStateExternalizer = compiler.getSourceStateExternalizer();
            this.myOutputStateExternalizer = compiler.getOutputStateExternalizer();
        }

        public void save(@NotNull DataOutput out, PersistentStateData<SourceState, OutputState> value) throws IOException {
            if (out == null) {
                PersistentStateDataExternalizer.$$$reportNull$$$0(0);
            }
            this.mySourceStateExternalizer.save(out, value.mySourceState);
            this.myOutputStateExternalizer.save(out, value.myOutputState);
        }

        public PersistentStateData<SourceState, OutputState> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                PersistentStateDataExternalizer.$$$reportNull$$$0(1);
            }
            Object sourceState = this.mySourceStateExternalizer.read(in);
            Object outputState = this.myOutputStateExternalizer.read(in);
            return new PersistentStateData(sourceState, outputState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/impl/generic/GenericCompilerCache$PersistentStateDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SourceItemDataDescriptor
    implements KeyDescriptor<KeyAndTargetData<Key>> {
        private final KeyDescriptor<Key> myKeyDescriptor;

        public SourceItemDataDescriptor(KeyDescriptor<Key> keyDescriptor) {
            this.myKeyDescriptor = keyDescriptor;
        }

        public boolean isEqual(KeyAndTargetData<Key> val1, KeyAndTargetData<Key> val2) {
            return val1.myTarget == val2.myTarget;
        }

        public int getHashCode(KeyAndTargetData<Key> value) {
            return value.myTarget + 239 * this.myKeyDescriptor.getHashCode(value.myKey);
        }

        public void save(@NotNull DataOutput out, KeyAndTargetData<Key> value) throws IOException {
            if (out == null) {
                SourceItemDataDescriptor.$$$reportNull$$$0(0);
            }
            out.writeInt(value.myTarget);
            this.myKeyDescriptor.save(out, value.myKey);
        }

        public KeyAndTargetData<Key> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                SourceItemDataDescriptor.$$$reportNull$$$0(1);
            }
            int target = in.readInt();
            Object item = this.myKeyDescriptor.read(in);
            return GenericCompilerCache.this.getKeyAndTargetData(item, target);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/impl/generic/GenericCompilerCache$SourceItemDataDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PersistentStateData<SourceState, OutputState> {
        @NotNull
        public final SourceState mySourceState;
        @NotNull
        public final OutputState myOutputState;

        private PersistentStateData(@NotNull SourceState sourceState, @NotNull OutputState outputState) {
            if (sourceState == null) {
                PersistentStateData.$$$reportNull$$$0(0);
            }
            if (outputState == null) {
                PersistentStateData.$$$reportNull$$$0(1);
            }
            this.mySourceState = sourceState;
            this.myOutputState = outputState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputState";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/impl/generic/GenericCompilerCache$PersistentStateData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KeyAndTargetData<Key> {
        public final int myTarget;
        public final Key myKey;

        private KeyAndTargetData(int target, Key key) {
            this.myTarget = target;
            this.myKey = key;
        }
    }
}

