/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.options.ModuleTableCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class CompilerModuleOptionsComponent
extends JPanel {
    private final JBTable myTable;
    private final Project myProject;

    public CompilerModuleOptionsComponent(Project project2) {
        super(new GridBagLayout());
        this.myProject = project2;
        this.myTable = new JBTable((TableModel)new MyTableModel());
        this.myTable.setRowHeight(22);
        this.myTable.getEmptyText().setText("Additional compilation options will be the same for all modules");
        TableColumn moduleColumn = this.myTable.getColumnModel().getColumn(0);
        moduleColumn.setHeaderValue("Module");
        moduleColumn.setCellRenderer(new ModuleTableCellRenderer());
        TableColumn optionsColumn = this.myTable.getColumnModel().getColumn(1);
        String columnTitle = "Compilation options";
        optionsColumn.setHeaderValue("Compilation options");
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth("Compilation options") + 10;
        optionsColumn.setPreferredWidth(width);
        optionsColumn.setMinWidth(width);
        ExpandableTextField editor = new ExpandableTextField();
        InsertPathAction.addTo((JTextComponent)editor, null, (boolean)false);
        optionsColumn.setCellEditor(new DefaultCellEditor((JTextField)editor));
        new TableSpeedSearch((JTable)this.myTable);
        JPanel table = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpAction().disableDownAction().setAddAction((AnActionButtonRunnable)new ChooseModuleAction()).setRemoveAction((AnActionButtonRunnable)new RemoveSelectedRowsAction()).createPanel();
        table.setPreferredSize(new Dimension(this.myTable.getWidth(), 150));
        JLabel header = new JLabel("Override compiler parameters per-module:");
        this.add((Component)header, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)table, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
    }

    @NotNull
    public Map<String, String> getModuleOptionsMap() {
        MyTableModel model2 = (MyTableModel)this.myTable.getModel();
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (MyTableModel.Item item : model2.getItems()) {
            map2.put(item.module.getName(), item.options);
        }
        HashMap<String, String> hashMap = map2;
        if (hashMap == null) {
            CompilerModuleOptionsComponent.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    public void setModuleOptionsMap(@NotNull Map<String, String> moduleOptions) {
        Map<Module, String> map2;
        if (moduleOptions == null) {
            CompilerModuleOptionsComponent.$$$reportNull$$$0(1);
        }
        if (!moduleOptions.isEmpty()) {
            map2 = new HashMap();
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                String options = moduleOptions.get(module2.getName());
                if (options == null) continue;
                map2.put(module2, options);
            }
        } else {
            map2 = Collections.emptyMap();
        }
        ((MyTableModel)this.myTable.getModel()).setItems(map2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/javaCompiler/CompilerModuleOptionsComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleOptionsMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/javaCompiler/CompilerModuleOptionsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModuleOptionsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RemoveSelectedRowsAction
    implements AnActionButtonRunnable {
        private RemoveSelectedRowsAction() {
        }

        public void run(AnActionButton anActionButton) {
            int[] rows = CompilerModuleOptionsComponent.this.myTable.getSelectedRows();
            if (rows.length > 0) {
                TableUtil.removeSelectedItems((JTable)CompilerModuleOptionsComponent.this.myTable);
            }
        }
    }

    private class ChooseModuleAction
    implements AnActionButtonRunnable {
        private ChooseModuleAction() {
        }

        public void run(AnActionButton anActionButton) {
            MyTableModel model2 = (MyTableModel)CompilerModuleOptionsComponent.this.myTable.getModel();
            HashSet<Module> added = new HashSet<Module>();
            for (MyTableModel.Item item : model2.getItems()) {
                added.add(item.module);
            }
            ArrayList<Module> modulesToChoose = new ArrayList<Module>();
            for (Module module2 : ModuleManager.getInstance((Project)CompilerModuleOptionsComponent.this.myProject).getModules()) {
                if (added.contains(module2)) continue;
                modulesToChoose.add(module2);
            }
            Collections.sort(modulesToChoose, Comparator.comparing(Module::getName));
            ChooseModulesDialog chooseModulesDialog = new ChooseModulesDialog((Component)CompilerModuleOptionsComponent.this, modulesToChoose, "Choose module");
            chooseModulesDialog.show();
            List chosen = chooseModulesDialog.getChosenElements();
            if (!chosen.isEmpty()) {
                model2.addItems(chosen);
                int i = model2.getModuleRow((Module)chosen.get(0));
                if (i >= 0) {
                    TableUtil.selectRows((JTable)CompilerModuleOptionsComponent.this.myTable, (int[])new int[]{i});
                    TableUtil.scrollSelectionToVisible((JTable)CompilerModuleOptionsComponent.this.myTable);
                }
            }
        }
    }

    private static final class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final List<Item> myItems = new ArrayList<Item>();

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.myItems.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Item item = this.myItems.get(rowIndex);
            return columnIndex == 0 ? item.module : item.options;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Item item = this.myItems.get(rowIndex);
            item.options = ((String)aValue).trim();
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void addItems(Collection<Module> modules) {
            for (Module module2 : modules) {
                this.myItems.add(new Item(module2));
            }
            this.sortItems();
            this.fireTableDataChanged();
        }

        private void sortItems() {
            Collections.sort(this.myItems, Comparator.comparing(item -> item.module.getName()));
        }

        public List<Item> getItems() {
            return this.myItems;
        }

        public void removeRow(int idx) {
            this.myItems.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public void setItems(Map<Module, String> items) {
            this.myItems.clear();
            for (Map.Entry<Module, String> entry : items.entrySet()) {
                this.myItems.add(new Item(entry.getKey(), entry.getValue()));
            }
            this.sortItems();
            this.fireTableDataChanged();
        }

        public int getModuleRow(Module module2) {
            for (int i = 0; i < this.myItems.size(); ++i) {
                if (!this.myItems.get((int)i).module.equals(module2)) continue;
                return i;
            }
            return -1;
        }

        private static final class Item {
            final Module module;
            String options = "";

            Item(Module module2) {
                this.module = module2;
            }

            Item(Module module2, String options) {
                this.module = module2;
                this.options = options;
            }
        }
    }
}

