/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.MessagesContainer;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AutomakeCompileContext
extends UserDataHolderBase
implements CompileContext {
    private final Project myProject;
    private final ProjectCompileScope myScope;
    private final MessagesContainer myMessages;
    private final EmptyProgressIndicator myIndicator;
    private final boolean myAnnotationProcessingEnabled;

    AutomakeCompileContext(Project project2) {
        this.myProject = project2;
        this.myScope = new ProjectCompileScope(project2);
        this.myMessages = new MessagesContainer(project2);
        this.myIndicator = new EmptyProgressIndicator();
        this.myAnnotationProcessingEnabled = CompilerConfiguration.getInstance((Project)project2).isAnnotationProcessorsEnabled();
    }

    public Project getProject() {
        return this.myProject;
    }

    public CompileScope getCompileScope() {
        return this.getProjectCompileScope();
    }

    public CompileScope getProjectCompileScope() {
        return this.myScope;
    }

    public boolean isMake() {
        return true;
    }

    public boolean isAutomake() {
        return true;
    }

    public void addMessage(@NotNull CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum) {
        if (category == null) {
            AutomakeCompileContext.$$$reportNull$$$0(0);
        }
        this.addMessage(category, message, url, lineNum, columnNum, null);
    }

    public void addMessage(@NotNull CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum, Navigatable navigatable) {
        if (category == null) {
            AutomakeCompileContext.$$$reportNull$$$0(1);
        }
        this.createAndAddMessage(category, message, url, lineNum, columnNum, navigatable);
    }

    @NotNull
    public CompilerMessage[] getMessages(@NotNull CompilerMessageCategory category) {
        if (category == null) {
            AutomakeCompileContext.$$$reportNull$$$0(2);
        }
        CompilerMessage[] compilerMessageArray = this.myMessages.getMessages(category).toArray(CompilerMessage.EMPTY_ARRAY);
        if (compilerMessageArray == null) {
            AutomakeCompileContext.$$$reportNull$$$0(3);
        }
        return compilerMessageArray;
    }

    @Nullable
    CompilerMessage createAndAddMessage(CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum, Navigatable navigatable) {
        return this.myMessages.addMessage(category, message, url, lineNum, columnNum, navigatable);
    }

    public int getMessageCount(CompilerMessageCategory category) {
        return this.myMessages.getMessageCount(category);
    }

    @NotNull
    public ProgressIndicator getProgressIndicator() {
        EmptyProgressIndicator emptyProgressIndicator = this.myIndicator;
        if (emptyProgressIndicator == null) {
            AutomakeCompileContext.$$$reportNull$$$0(4);
        }
        return emptyProgressIndicator;
    }

    public void requestRebuildNextTime(String message) {
    }

    public boolean isRebuildRequested() {
        return false;
    }

    @Nullable
    public String getRebuildReason() {
        return null;
    }

    public Module getModuleByFile(@NotNull VirtualFile file) {
        if (file == null) {
            AutomakeCompileContext.$$$reportNull$$$0(5);
        }
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file);
    }

    public VirtualFile getModuleOutputDirectory(@NotNull Module module2) {
        if (module2 == null) {
            AutomakeCompileContext.$$$reportNull$$$0(6);
        }
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)false);
    }

    public VirtualFile getModuleOutputDirectoryForTests(Module module2) {
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)true);
    }

    public boolean isRebuild() {
        return false;
    }

    public boolean isAnnotationProcessorsEnabled() {
        return this.myAnnotationProcessingEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/AutomakeCompileContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/AutomakeCompileContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessages";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleOutputDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

