/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion;

import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import java.io.File;
import java.util.List;
import org.junit.Assert;

public class ProjectConversionTestUtil {
    private ProjectConversionTestUtil() {
    }

    public static void assertNoConversionNeeded(String projectPath) {
        MyConversionListener listener2 = new MyConversionListener();
        ConversionResult result = ConversionService.getInstance().convertSilently(projectPath, (ConversionListener)listener2);
        Assert.assertTrue((boolean)result.conversionNotNeeded());
        Assert.assertFalse((boolean)listener2.isConversionNeeded());
        Assert.assertFalse((boolean)listener2.isConverted());
    }

    public static void convert(String projectPath) {
        MyConversionListener listener2 = new MyConversionListener();
        ConversionResult result = ConversionService.getInstance().convertSilently(projectPath, (ConversionListener)listener2);
        Assert.assertFalse((boolean)result.conversionNotNeeded());
        Assert.assertFalse((boolean)result.openingIsCanceled());
        Assert.assertTrue((boolean)listener2.isConversionNeeded());
        Assert.assertTrue((boolean)listener2.isConverted());
    }

    public static class MyConversionListener
    implements ConversionListener {
        private boolean myConversionNeeded;
        private boolean myConverted;

        public void conversionNeeded() {
            this.myConversionNeeded = true;
        }

        public void successfullyConverted(File backupDir) {
            this.myConverted = true;
        }

        public void error(String message) {
            Assert.fail((String)message);
        }

        public void cannotWriteToFiles(List<File> readonlyFiles) {
        }

        public boolean isConversionNeeded() {
            return this.myConversionNeeded;
        }

        public boolean isConverted() {
            return this.myConverted;
        }
    }
}

