/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapUIImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;

public class HotSwapAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project2);
        DebuggerSession session = debuggerManager.getContext().getDebuggerSession();
        if (session != null && session.isAttached()) {
            HotSwapUI.getInstance(project2).reloadChangedClasses(session, DebuggerSettings.getInstance().COMPILE_BEFORE_HOTSWAP);
        }
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project2);
        DebuggerSession session = debuggerManager.getContext().getDebuggerSession();
        e.getPresentation().setEnabled(session != null && HotSwapUIImpl.canHotSwap(session));
    }
}

