/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundPositionManager
extends PositionManagerEx
implements MultiRequestPositionManager {
    private static final Logger LOG = Logger.getInstance(CompoundPositionManager.class);
    public static final CompoundPositionManager EMPTY = new CompoundPositionManager();
    private final ArrayList<PositionManager> myPositionManagers = new ArrayList();
    private final Map<Location, SourcePosition> mySourcePositionCache = new WeakHashMap<Location, SourcePosition>();

    public CompoundPositionManager() {
    }

    public CompoundPositionManager(PositionManager manager) {
        this.appendPositionManager(manager);
    }

    public void appendPositionManager(PositionManager manager) {
        this.myPositionManagers.remove(manager);
        this.myPositionManagers.add(0, manager);
        this.clearCache();
    }

    public void clearCache() {
        this.mySourcePositionCache.clear();
    }

    private <T> T iterate(Processor<T> processor2, T defaultValue, SourcePosition position) {
        return this.iterate(processor2, defaultValue, position, true);
    }

    private <T> T iterate(Processor<T> processor2, T defaultValue, SourcePosition position, boolean ignorePCE) {
        for (PositionManager positionManager : this.myPositionManagers) {
            Set types;
            if (position != null && (types = positionManager.getAcceptedFileTypes()) != null && !types.contains(position.getFile().getFileType())) continue;
            try {
                if (!ignorePCE) {
                    ProgressManager.checkCanceled();
                }
                return DebuggerUtilsImpl.suppressExceptions(() -> processor2.process(positionManager), defaultValue, ignorePCE, NoDataException.class);
            }
            catch (NoDataException noDataException) {
            }
        }
        return defaultValue;
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location) {
        if (location == null) {
            return null;
        }
        SourcePosition res = null;
        try {
            res = this.mySourcePositionCache.get(location);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (CompoundPositionManager.checkCacheEntry(res, location)) {
            return res;
        }
        return (SourcePosition)DebuggerUtilsImpl.runInReadActionWithWriteActionPriorityWithRetries(() -> this.iterate(positionManager -> {
            SourcePosition res1 = positionManager.getSourcePosition(location);
            this.mySourcePositionCache.put(location, res1);
            return res1;
        }, null, null, false));
    }

    private static boolean checkCacheEntry(@Nullable SourcePosition position, @NotNull Location location) {
        if (location == null) {
            CompoundPositionManager.$$$reportNull$$$0(0);
        }
        if (position == null) {
            return false;
        }
        PsiFile psiFile = position.getFile();
        if (!psiFile.isValid()) {
            return false;
        }
        String url = DebuggerUtilsEx.getAlternativeSourceUrl(location.declaringType().name(), psiFile.getProject());
        if (url == null) {
            return true;
        }
        VirtualFile file = psiFile.getVirtualFile();
        return file != null && url.equals(file.getUrl());
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) {
        if (classPosition == null) {
            CompoundPositionManager.$$$reportNull$$$0(1);
        }
        List<ReferenceType> list = this.iterate(positionManager -> {
            if (classPosition == null) {
                CompoundPositionManager.$$$reportNull$$$0(23);
            }
            return positionManager.getAllClasses(classPosition);
        }, Collections.emptyList(), classPosition);
        if (list == null) {
            CompoundPositionManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) {
        int line;
        LineNumbersMapping mapping;
        VirtualFile file;
        if (type == null) {
            CompoundPositionManager.$$$reportNull$$$0(3);
        }
        if (position == null) {
            CompoundPositionManager.$$$reportNull$$$0(4);
        }
        if ((file = position.getFile().getVirtualFile()) != null && (mapping = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (line = mapping.sourceToBytecode(position.getLine() + 1)) > -1) {
            position = SourcePosition.createFromLine((PsiFile)position.getFile(), (int)(line - 1));
        }
        SourcePosition finalPosition = position;
        List<Location> list = this.iterate(positionManager -> {
            if (type == null) {
                CompoundPositionManager.$$$reportNull$$$0(22);
            }
            return positionManager.locationsOfLine(type, finalPosition);
        }, Collections.emptyList(), position);
        if (list == null) {
            CompoundPositionManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        if (requestor == null) {
            CompoundPositionManager.$$$reportNull$$$0(6);
        }
        if (position == null) {
            CompoundPositionManager.$$$reportNull$$$0(7);
        }
        return this.iterate(positionManager -> {
            if (requestor == null) {
                CompoundPositionManager.$$$reportNull$$$0(20);
            }
            if (position == null) {
                CompoundPositionManager.$$$reportNull$$$0(21);
            }
            return positionManager.createPrepareRequest(requestor, position);
        }, null, position);
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        if (requestor == null) {
            CompoundPositionManager.$$$reportNull$$$0(8);
        }
        if (position == null) {
            CompoundPositionManager.$$$reportNull$$$0(9);
        }
        List<ClassPrepareRequest> list = this.iterate(positionManager -> {
            if (requestor == null) {
                CompoundPositionManager.$$$reportNull$$$0(18);
            }
            if (position == null) {
                CompoundPositionManager.$$$reportNull$$$0(19);
            }
            if (positionManager instanceof MultiRequestPositionManager) {
                return ((MultiRequestPositionManager)positionManager).createPrepareRequests(requestor, position);
            }
            ClassPrepareRequest prepareRequest = positionManager.createPrepareRequest(requestor, position);
            if (prepareRequest == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(prepareRequest);
        }, Collections.emptyList(), position);
        if (list == null) {
            CompoundPositionManager.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
        if (frame == null) {
            CompoundPositionManager.$$$reportNull$$$0(11);
        }
        if (debugProcess == null) {
            CompoundPositionManager.$$$reportNull$$$0(12);
        }
        if (location == null) {
            CompoundPositionManager.$$$reportNull$$$0(13);
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                XStackFrame xStackFrame = ((PositionManagerEx)positionManager).createStackFrame(frame, debugProcess, location);
                if (xStackFrame == null) continue;
                return xStackFrame;
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return null;
    }

    @Override
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
        if (context == null) {
            CompoundPositionManager.$$$reportNull$$$0(14);
        }
        if (frame == null) {
            CompoundPositionManager.$$$reportNull$$$0(15);
        }
        if (location == null) {
            CompoundPositionManager.$$$reportNull$$$0(16);
        }
        if (expression == null) {
            CompoundPositionManager.$$$reportNull$$$0(17);
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                ThreeState result = ((PositionManagerEx)positionManager).evaluateCondition(context, frame, location, expression);
                if (result == ThreeState.UNSURE) continue;
                return result;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return ThreeState.UNSURE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPosition";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/CompoundPositionManager";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: 
            case 8: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/CompoundPositionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrepareRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkCacheEntry";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequests";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createStackFrame";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPrepareRequests$6";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPrepareRequest$5";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$locationsOfLine$4";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllClasses$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Processor<T> {
        public T process(PositionManager var1) throws NoDataException;
    }
}

