/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluatorBase;
import com.intellij.debugger.engine.evaluation.expression.Modifier;

public class ForStatementEvaluator
extends ForStatementEvaluatorBase {
    private final Evaluator myInitializationEvaluator;
    private final Evaluator myConditionEvaluator;
    private final Evaluator myUpdateEvaluator;
    private Modifier myModifier;

    public ForStatementEvaluator(Evaluator initializationEvaluator, Evaluator conditionEvaluator, Evaluator updateEvaluator, Evaluator bodyEvaluator, String labelName) {
        super(labelName, bodyEvaluator);
        this.myInitializationEvaluator = initializationEvaluator != null ? DisableGC.create(initializationEvaluator) : null;
        this.myConditionEvaluator = conditionEvaluator != null ? DisableGC.create(conditionEvaluator) : null;
        this.myUpdateEvaluator = updateEvaluator != null ? DisableGC.create(updateEvaluator) : null;
    }

    @Override
    public Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    protected Object evaluateInitialization(EvaluationContextImpl context, Object value) throws EvaluateException {
        if (this.myInitializationEvaluator != null) {
            value = this.myInitializationEvaluator.evaluate(context);
            this.myModifier = this.myInitializationEvaluator.getModifier();
        }
        return value;
    }

    @Override
    protected Object evaluateCondition(EvaluationContextImpl context) throws EvaluateException {
        if (this.myConditionEvaluator != null) {
            Object value = this.myConditionEvaluator.evaluate(context);
            this.myModifier = this.myConditionEvaluator.getModifier();
            return value;
        }
        return true;
    }

    @Override
    protected Object evaluateUpdate(EvaluationContextImpl context, Object value) throws EvaluateException {
        if (this.myUpdateEvaluator != null) {
            value = this.myUpdateEvaluator.evaluate(context);
            this.myModifier = this.myUpdateEvaluator.getModifier();
        }
        return value;
    }
}

