/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.memory.utils.AbstractTableColumnDescriptor;
import com.intellij.debugger.memory.utils.AbstractTableModelWithColumns;
import com.intellij.debugger.memory.utils.InstancesProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesTable
extends JBTable
implements DataProvider,
Disposable {
    public static final DataKey<ReferenceType> SELECTED_CLASS_KEY = DataKey.create((String)"ClassesTable.SelectedClass");
    public static final DataKey<InstancesProvider> NEW_INSTANCES_PROVIDER_KEY = DataKey.create((String)"ClassesTable.NewInstances");
    public static final DataKey<ReferenceCountProvider> REF_COUNT_PROVIDER_KEY = DataKey.create((String)"ClassesTable.ReferenceCountProvider");
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    private static final JBColor CLICKABLE_COLOR = new JBColor(new Color(250, 251, 252), new Color(62, 66, 69));
    private static final String DEFAULT_EMPTY_TEXT = "Nothing to show";
    private static final int CLASSES_COLUMN_PREFERRED_WIDTH = 250;
    private static final int COUNT_COLUMN_MIN_WIDTH = 80;
    private static final int DIFF_COLUMN_MIN_WIDTH = 80;
    private static final UnknownDiffValue UNKNOWN_VALUE = new UnknownDiffValue();
    private final DiffViewTableModel myModel;
    private final Map<ReferenceType, DiffValue> myCounts;
    private final InstancesTracker myInstancesTracker;
    private final ClassesFilteredView myParent;
    private final ReferenceCountProvider myCountProvider;
    private boolean myOnlyWithDiff;
    private boolean myOnlyTracked;
    private boolean myOnlyWithInstances;
    private MinusculeMatcher myMatcher;
    private String myFilteringPattern;
    private volatile List<ReferenceType> myItems;
    private boolean myIsShowCounts;
    private MouseListener myMouseListener;

    public ClassesTable(@NotNull InstancesTracker tracker, @NotNull ClassesFilteredView parent, boolean onlyWithDiff, boolean onlyWithInstances, boolean onlyTracked) {
        if (tracker == null) {
            ClassesTable.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            ClassesTable.$$$reportNull$$$0(1);
        }
        this.myModel = new DiffViewTableModel();
        this.myCounts = new ConcurrentHashMap<ReferenceType, DiffValue>();
        this.myMatcher = NameUtil.buildMatcher((String)"*").build();
        this.myFilteringPattern = "";
        this.myItems = Collections.unmodifiableList(new ArrayList());
        this.myIsShowCounts = true;
        this.myMouseListener = null;
        this.setModel(this.myModel);
        this.myOnlyWithDiff = onlyWithDiff;
        this.myOnlyWithInstances = onlyWithInstances;
        this.myOnlyTracked = onlyTracked;
        this.myInstancesTracker = tracker;
        this.myParent = parent;
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn classesColumn = columnModel.getColumn(0);
        TableColumn countColumn = columnModel.getColumn(1);
        TableColumn diffColumn = columnModel.getColumn(2);
        this.setAutoResizeMode(2);
        classesColumn.setPreferredWidth(JBUI.scale((int)250));
        countColumn.setMinWidth(JBUI.scale((int)80));
        diffColumn.setMinWidth(JBUI.scale((int)80));
        this.setShowGrid(false);
        this.setIntercellSpacing((Dimension)new JBDimension(0, 0));
        this.setDefaultRenderer(ReferenceType.class, (TableCellRenderer)((Object)new MyClassColumnRenderer()));
        this.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)new MyCountColumnRenderer()));
        this.setDefaultRenderer(DiffValue.class, (TableCellRenderer)((Object)new MyDiffColumnRenderer()));
        TableRowSorter<DiffViewTableModel> sorter = new TableRowSorter<DiffViewTableModel>(this.myModel);
        sorter.setRowFilter(new RowFilter<DiffViewTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends DiffViewTableModel, ? extends Integer> entry) {
                int ix = entry.getIdentifier();
                ReferenceType ref = (ReferenceType)ClassesTable.this.myItems.get(ix);
                DiffValue diff = ClassesTable.this.myCounts.getOrDefault(ref, UNKNOWN_VALUE);
                boolean isFilteringOptionsRefused = ClassesTable.this.myOnlyWithDiff && diff.diff() == 0L || ClassesTable.this.myOnlyWithInstances && !diff.hasInstance() || ClassesTable.this.myOnlyTracked && ClassesTable.this.myParent.getStrategy(ref) == null;
                return !isFilteringOptionsRefused && ClassesTable.this.myMatcher.matches(ref.name());
            }
        });
        List<RowSorter.SortKey> myDefaultSortingKeys = Arrays.asList(new RowSorter.SortKey(2, SortOrder.DESCENDING), new RowSorter.SortKey(1, SortOrder.DESCENDING), new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sorter.setSortKeys(myDefaultSortingKeys);
        this.setRowSorter(sorter);
        this.setSelectionMode(0);
        this.myCountProvider = new ReferenceCountProvider(){

            @Override
            public int getTotalCount(@NotNull ReferenceType ref) {
                if (ref == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (int)((DiffValue)ClassesTable.this.myCounts.get(ref)).myCurrentCount;
            }

            @Override
            public int getDiffCount(@NotNull ReferenceType ref) {
                if (ref == null) {
                    2.$$$reportNull$$$0(1);
                }
                return (int)((DiffValue)ClassesTable.this.myCounts.get(ref)).diff();
            }

            @Override
            public int getNewInstancesCount(@NotNull ReferenceType ref) {
                TrackerForNewInstances strategy;
                if (ref == null) {
                    2.$$$reportNull$$$0(2);
                }
                return (strategy = ClassesTable.this.myParent.getStrategy(ref)) == null || !strategy.isReady() ? -1 : strategy.getCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ref";
                objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesTable$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTotalCount";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDiffCount";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getNewInstancesCount";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    ReferenceType getSelectedClass() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            int ix = this.convertRowIndexToModel(selectedRow);
            return this.myItems.get(ix);
        }
        return null;
    }

    @Nullable
    ReferenceType getClassByName(@NotNull String name2) {
        if (name2 == null) {
            ClassesTable.$$$reportNull$$$0(2);
        }
        for (ReferenceType ref : this.myItems) {
            if (!name2.equals(ref.name())) continue;
            return ref;
        }
        return null;
    }

    boolean isInClickableMode() {
        return this.myMouseListener != null;
    }

    void makeClickable(@NotNull String text, final @NotNull Runnable onClick) {
        if (text == null) {
            ClassesTable.$$$reportNull$$$0(3);
        }
        if (onClick == null) {
            ClassesTable.$$$reportNull$$$0(4);
        }
        this.releaseMouseListener();
        this.getEmptyText().setText(text);
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.getMousePosition() != null) {
            this.setBackground((Color)CLICKABLE_COLOR);
        }
        this.myMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                onClick.run();
                ClassesTable.this.releaseMouseListener();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ClassesTable.this.setBackground((Color)CLICKABLE_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ClassesTable.this.setBackground(JBColor.background());
            }
        };
        this.addMouseListener(this.myMouseListener);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    void exitClickableMode() {
        this.releaseMouseListener();
        this.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
    }

    private void releaseMouseListener() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isInClickableMode()) {
            this.removeMouseListener(this.myMouseListener);
            this.myMouseListener = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setBackground(JBColor.background());
        }
    }

    void setBusy(boolean value) {
        this.setPaintBusy(value);
    }

    void setFilterPattern(String pattern) {
        if (!this.myFilteringPattern.equals(pattern)) {
            this.myFilteringPattern = pattern;
            this.myMatcher = NameUtil.buildMatcher((String)("*" + pattern)).build();
            this.fireTableDataChanged();
            if (this.getSelectedClass() == null && this.getRowCount() > 0) {
                this.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    void setFilteringByInstanceExists(boolean value) {
        if (value != this.myOnlyWithInstances) {
            this.myOnlyWithInstances = value;
            this.fireTableDataChanged();
        }
    }

    void setFilteringByDiffNonZero(boolean value) {
        if (this.myOnlyWithDiff != value) {
            this.myOnlyWithDiff = value;
            this.fireTableDataChanged();
        }
    }

    void setFilteringByTrackingState(boolean value) {
        if (this.myOnlyTracked != value) {
            this.myOnlyTracked = value;
            this.fireTableDataChanged();
        }
    }

    public void updateClassesOnly(@NotNull List<ReferenceType> classes) {
        if (classes == null) {
            ClassesTable.$$$reportNull$$$0(5);
        }
        this.myIsShowCounts = false;
        LinkedHashMap<ReferenceType, Long> class2Count = new LinkedHashMap<ReferenceType, Long>();
        classes.forEach(x -> class2Count.put((ReferenceType)x, 0L));
        this.updateCountsInternal(class2Count);
    }

    public void updateContent(@NotNull Map<ReferenceType, Long> class2Count) {
        if (class2Count == null) {
            ClassesTable.$$$reportNull$$$0(6);
        }
        this.myIsShowCounts = true;
        this.updateCountsInternal(class2Count);
    }

    void hideContent(@NotNull String emptyText) {
        if (emptyText == null) {
            ClassesTable.$$$reportNull$$$0(7);
        }
        this.releaseMouseListener();
        this.getEmptyText().setText(emptyText);
        this.myModel.hide();
    }

    private void showContent() {
        this.myModel.show();
    }

    private void updateCountsInternal(@NotNull Map<ReferenceType, Long> class2Count) {
        if (class2Count == null) {
            ClassesTable.$$$reportNull$$$0(8);
        }
        this.releaseMouseListener();
        this.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        ReferenceType selectedClass = this.myModel.getSelectedClassBeforeHide();
        int newSelectedIndex = -1;
        boolean isInitialized = !this.myItems.isEmpty();
        this.myItems = Collections.unmodifiableList(new ArrayList<ReferenceType>(class2Count.keySet()));
        int i = 0;
        for (ReferenceType ref : class2Count.keySet()) {
            if (ref.equals(selectedClass)) {
                newSelectedIndex = i;
            }
            DiffValue oldValue = isInitialized && !this.myCounts.containsKey(ref) ? new DiffValue(0L, 0L) : this.myCounts.getOrDefault(ref, UNKNOWN_VALUE);
            this.myCounts.put(ref, oldValue.update(class2Count.get(ref)));
            ++i;
        }
        this.showContent();
        if (newSelectedIndex != -1 && !this.myModel.isHidden()) {
            int ix = this.convertRowIndexToView(newSelectedIndex);
            this.changeSelection(ix, 0, false, false);
        }
        this.fireTableDataChanged();
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        TrackerForNewInstances strategy;
        ReferenceType selectedClass;
        if (SELECTED_CLASS_KEY.is(dataId)) {
            return this.getSelectedClass();
        }
        if (NEW_INSTANCES_PROVIDER_KEY.is(dataId) && (selectedClass = this.getSelectedClass()) != null && (strategy = this.myParent.getStrategy(selectedClass)) != null && strategy.isReady()) {
            List<ObjectReference> newInstances = strategy.getNewInstances();
            return limit -> newInstances;
        }
        if (REF_COUNT_PROVIDER_KEY.is(dataId)) {
            return this.myCountProvider;
        }
        return null;
    }

    public void clean(@NotNull String emptyText) {
        if (emptyText == null) {
            ClassesTable.$$$reportNull$$$0(9);
        }
        this.clearSelection();
        this.releaseMouseListener();
        this.getEmptyText().setText(emptyText);
        this.myItems = Collections.emptyList();
        this.myCounts.clear();
        this.myModel.mySelectedClassWhenHidden = null;
        this.fireTableDataChanged();
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> this.clean(""));
    }

    @Nullable
    private TrackingType getTrackingType(int row) {
        ReferenceType ref = (ReferenceType)this.getValueAt(row, this.convertColumnIndexToView(0));
        return this.myInstancesTracker.getTrackingType(ref.name());
    }

    private void fireTableDataChanged() {
        this.myModel.fireTableDataChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClick";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "class2Count";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassByName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "makeClickable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateClassesOnly";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hideContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCountsInternal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "clean";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDiffColumnRenderer
    extends MyNumericRenderer {
        private final SimpleTextAttributes myClickableCellAttributes;

        private MyDiffColumnRenderer() {
            this.myClickableCellAttributes = new SimpleTextAttributes(16, (Color)JBColor.BLUE);
        }

        @Override
        void appendText(@NotNull Object value, int row) {
            TrackingType trackingType;
            if (value == null) {
                MyDiffColumnRenderer.$$$reportNull$$$0(0);
            }
            if ((trackingType = ClassesTable.this.getTrackingType(row)) != null) {
                this.setIcon(AllIcons.Debugger.MemoryView.ClassTracked);
                this.setTransparentIconBackground(true);
            }
            ReferenceType ref = (ReferenceType)ClassesTable.this.myItems.get(ClassesTable.this.convertRowIndexToModel(row));
            long diff = ClassesTable.this.myCountProvider.getDiffCount(ref);
            String text = String.format("%s%d", diff > 0L ? "+" : "", diff);
            int newInstancesCount = ClassesTable.this.myCountProvider.getNewInstancesCount(ref);
            if (newInstancesCount >= 0) {
                if ((long)newInstancesCount == diff) {
                    this.append(text, diff == 0L ? SimpleTextAttributes.REGULAR_ATTRIBUTES : this.myClickableCellAttributes);
                } else {
                    this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (newInstancesCount != 0) {
                        this.append(String.format(" (%d)", newInstancesCount), this.myClickableCellAttributes);
                    }
                }
            } else {
                this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyDiffColumnRenderer", "appendText"));
        }
    }

    private class MyCountColumnRenderer
    extends MyNumericRenderer {
        private MyCountColumnRenderer() {
        }

        @Override
        void appendText(@NotNull Object value, int row) {
            if (value == null) {
                MyCountColumnRenderer.$$$reportNull$$$0(0);
            }
            this.append(value.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyCountColumnRenderer", "appendText"));
        }
    }

    private abstract class MyNumericRenderer
    extends MyTableCellRenderer {
        private MyNumericRenderer() {
        }

        @Override
        protected void addText(@NotNull Object value, boolean isSelected, int row) {
            if (value == null) {
                MyNumericRenderer.$$$reportNull$$$0(0);
            }
            if (ClassesTable.this.myIsShowCounts) {
                this.setTextAlign(4);
                this.appendText(value, row);
            }
        }

        abstract void appendText(@NotNull Object var1, int var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyNumericRenderer", "addText"));
        }
    }

    private class MyClassColumnRenderer
    extends MyTableCellRenderer {
        private MyClassColumnRenderer() {
        }

        @Override
        protected void addText(@NotNull Object value, boolean isSelected, int row) {
            if (value == null) {
                MyClassColumnRenderer.$$$reportNull$$$0(0);
            }
            String presentation = ((ReferenceType)value).name();
            this.append(" ");
            if (isSelected) {
                FList textRanges = ClassesTable.this.myMatcher.matchingFragments(presentation);
                if (textRanges != null) {
                    SimpleTextAttributes attributes = new SimpleTextAttributes(this.getBackground(), this.getForeground(), null, 64);
                    SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)this, (String)presentation, (Iterable)textRanges, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (SimpleTextAttributes)attributes);
                }
            } else {
                this.append(String.format("%s", presentation), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyClassColumnRenderer", "addText"));
        }
    }

    private static abstract class MyTableCellRenderer
    extends ColoredTableCellRenderer {
        private MyTableCellRenderer() {
        }

        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (hasFocus) {
                this.setBorder(EMPTY_BORDER);
            }
            if (value != null) {
                this.addText(value, isSelected, row);
            }
        }

        protected abstract void addText(@NotNull Object var1, boolean var2, int var3);
    }

    private static class DiffValue
    implements Comparable<DiffValue> {
        private long myOldCount;
        private long myCurrentCount;

        DiffValue(long count) {
            this(count, count);
        }

        DiffValue(long old, long current) {
            this.myCurrentCount = current;
            this.myOldCount = old;
        }

        DiffValue update(long count) {
            this.myOldCount = this.myCurrentCount;
            this.myCurrentCount = count;
            return this;
        }

        boolean hasInstance() {
            return this.myCurrentCount > 0L;
        }

        long diff() {
            return this.myCurrentCount - this.myOldCount;
        }

        @Override
        public int compareTo(@NotNull DiffValue o) {
            if (o == null) {
                DiffValue.$$$reportNull$$$0(0);
            }
            return Long.compare(this.diff(), o.diff());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/debugger/memory/ui/ClassesTable$DiffValue", "compareTo"));
        }
    }

    private static class UnknownDiffValue
    extends DiffValue {
        UnknownDiffValue() {
            super(-1L);
        }

        @Override
        boolean hasInstance() {
            return true;
        }

        @Override
        DiffValue update(long count) {
            return new DiffValue(count);
        }
    }

    class DiffViewTableModel
    extends AbstractTableModelWithColumns {
        static final int CLASSNAME_COLUMN_INDEX = 0;
        static final int COUNT_COLUMN_INDEX = 1;
        static final int DIFF_COLUMN_INDEX = 2;
        private ReferenceType mySelectedClassWhenHidden;
        private boolean myIsWithContent;

        DiffViewTableModel() {
            super(new AbstractTableColumnDescriptor[]{new AbstractTableColumnDescriptor("Class", ReferenceType.class){

                @Override
                public Object getValue(int ix) {
                    return ClassesTable.this.myItems.get(ix);
                }
            }, new AbstractTableColumnDescriptor("Count", Long.class){

                @Override
                public Object getValue(int ix) {
                    return ((DiffValue)ClassesTable.this.myCounts.getOrDefault(ClassesTable.this.myItems.get(ix), UNKNOWN_VALUE)).myCurrentCount;
                }
            }, new AbstractTableColumnDescriptor("Diff", DiffValue.class){

                @Override
                public Object getValue(int ix) {
                    return ClassesTable.this.myCounts.getOrDefault(ClassesTable.this.myItems.get(ix), UNKNOWN_VALUE);
                }
            }});
            this.mySelectedClassWhenHidden = null;
            this.myIsWithContent = false;
        }

        ReferenceType getSelectedClassBeforeHide() {
            return this.mySelectedClassWhenHidden;
        }

        void hide() {
            if (this.myIsWithContent) {
                this.mySelectedClassWhenHidden = ClassesTable.this.getSelectedClass();
                this.myIsWithContent = false;
                ClassesTable.this.clearSelection();
                this.fireTableDataChanged();
            }
        }

        void show() {
            if (!this.myIsWithContent) {
                this.myIsWithContent = true;
                this.fireTableDataChanged();
            }
        }

        boolean isHidden() {
            return !this.myIsWithContent;
        }

        @Override
        public int getRowCount() {
            return this.myIsWithContent ? ClassesTable.this.myItems.size() : 0;
        }
    }

    public static interface ReferenceCountProvider {
        public int getTotalCount(@NotNull ReferenceType var1);

        public int getDiffCount(@NotNull ReferenceType var1);

        public int getNewInstancesCount(@NotNull ReferenceType var1);
    }
}

