/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererSettingsListener;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.InternalIterator;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeRendererSettings", storages={@Storage(value="debugger.renderers.xml")})
public class NodeRendererSettings
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String REFERENCE_RENDERER = "Reference renderer";
    @NonNls
    public static final String RENDERER_TAG = "Renderer";
    @NonNls
    private static final String RENDERER_ID = "ID";
    private final EventDispatcher<NodeRendererSettingsListener> myDispatcher = EventDispatcher.create(NodeRendererSettingsListener.class);
    private RendererConfiguration myCustomRenderers = new RendererConfiguration(this);
    private static final String USE_ANDROID_RENDERER = "use.android.renderer";
    private boolean myUseAndroidRenderer = PropertiesComponent.getInstance().getBoolean("use.android.renderer", false);
    private final PrimitiveRenderer myPrimitiveRenderer = new PrimitiveRenderer();
    private final ArrayRenderer myArrayRenderer = new ArrayRenderer();
    private final ClassRenderer myClassRenderer = new ClassRenderer();
    private final HexRenderer myHexRenderer = new HexRenderer();
    private final ToStringRenderer myToStringRenderer = new ToStringRenderer();
    private final NodeRenderer[] myAlternateCollectionRenderers = new NodeRenderer[]{this.createCompoundReferenceRenderer("Map", "java.util.Map", NodeRendererSettings.createLabelRenderer(" size = ", "size()", null), NodeRendererSettings.createExpressionArrayChildrenRenderer("entrySet().toArray()", "!isEmpty()", this.myArrayRenderer)), this.createCompoundReferenceRenderer("Map.Entry", "java.util.Map$Entry", new MapEntryLabelRenderer(), NodeRendererSettings.createEnumerationChildrenRenderer(new String[][]{{"key", "getKey()"}, {"value", "getValue()"}})), new ListObjectRenderer(this, this.myArrayRenderer), this.createCompoundReferenceRenderer("Collection", "java.util.Collection", NodeRendererSettings.createLabelRenderer(" size = ", "size()", null), NodeRendererSettings.createExpressionArrayChildrenRenderer("toArray()", "!isEmpty()", this.myArrayRenderer))};
    @NonNls
    private static final String HEX_VIEW_ENABLED = "HEX_VIEW_ENABLED";
    @NonNls
    private static final String ALTERNATIVE_COLLECTION_VIEW_ENABLED = "ALTERNATIVE_COLLECTION_VIEW_ENABLED";
    @NonNls
    private static final String CUSTOM_RENDERERS_TAG_NAME = "CustomRenderers";

    public NodeRendererSettings() {
        this.myHexRenderer.setEnabled(false);
        this.myToStringRenderer.setEnabled(true);
        this.setAlternateCollectionViewsEnabled(true);
    }

    public static NodeRendererSettings getInstance() {
        return (NodeRendererSettings)ServiceManager.getService(NodeRendererSettings.class);
    }

    public void setAlternateCollectionViewsEnabled(boolean enabled) {
        for (NodeRenderer myAlternateCollectionRenderer : this.myAlternateCollectionRenderers) {
            myAlternateCollectionRenderer.setEnabled(enabled);
        }
    }

    public boolean areAlternateCollectionViewsEnabled() {
        return this.myAlternateCollectionRenderers[0].isEnabled();
    }

    void setUseAndroidRenderer(boolean en) {
        this.myUseAndroidRenderer = en;
        PropertiesComponent.getInstance().setValue(USE_ANDROID_RENDERER, Boolean.toString(en));
    }

    boolean isUsingAndroidRenderer() {
        return this.myUseAndroidRenderer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeRendererSettings)) {
            return false;
        }
        return DebuggerUtilsEx.elementsEqual(this.getState(), ((NodeRendererSettings)o).getState());
    }

    public void addListener(NodeRendererSettingsListener listener2, Disposable disposable) {
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    public Element getState() {
        Element element = new Element("NodeRendererSettings");
        if (this.myHexRenderer.isEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)HEX_VIEW_ENABLED, (String)"true");
        }
        if (!this.areAlternateCollectionViewsEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)ALTERNATIVE_COLLECTION_VIEW_ENABLED, (String)"false");
        }
        try {
            element.addContent(this.writeRenderer(this.myToStringRenderer));
            element.addContent(this.writeRenderer(this.myClassRenderer));
            element.addContent(this.writeRenderer(this.myPrimitiveRenderer));
            if (this.myCustomRenderers.getRendererCount() > 0) {
                Element custom = new Element(CUSTOM_RENDERERS_TAG_NAME);
                element.addContent(custom);
                this.myCustomRenderers.writeExternal(custom);
            }
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    public void loadState(@NotNull Element root) {
        String alternativeEnabled;
        String hexEnabled;
        if (root == null) {
            NodeRendererSettings.$$$reportNull$$$0(0);
        }
        if ((hexEnabled = JDOMExternalizerUtil.readField((Element)root, (String)HEX_VIEW_ENABLED)) != null) {
            this.myHexRenderer.setEnabled(Boolean.parseBoolean(hexEnabled));
        }
        if ((alternativeEnabled = JDOMExternalizerUtil.readField((Element)root, (String)ALTERNATIVE_COLLECTION_VIEW_ENABLED)) != null) {
            this.setAlternateCollectionViewsEnabled(Boolean.parseBoolean(alternativeEnabled));
        }
        for (Element elem : root.getChildren(RENDERER_TAG)) {
            String id = elem.getAttributeValue(RENDERER_ID);
            if (id == null) continue;
            try {
                if ("ToStringRenderer".equals(id)) {
                    this.myToStringRenderer.readExternal(elem);
                    if (this.myToStringRenderer.isEnabled()) continue;
                    this.myToStringRenderer.setEnabled(true);
                    this.myToStringRenderer.setOnDemand(true);
                    continue;
                }
                if ("ClassRenderer".equals(id)) {
                    this.myClassRenderer.readExternal(elem);
                    continue;
                }
                if (!"PrimitiveRenderer".equals(id)) continue;
                this.myPrimitiveRenderer.readExternal(elem);
            }
            catch (InvalidDataException invalidDataException) {}
        }
        Element custom = root.getChild(CUSTOM_RENDERERS_TAG_NAME);
        if (custom != null) {
            this.myCustomRenderers.readExternal(custom);
        }
        ((NodeRendererSettingsListener)this.myDispatcher.getMulticaster()).renderersChanged();
    }

    public RendererConfiguration getCustomRenderers() {
        return this.myCustomRenderers;
    }

    public void setCustomRenderers(@NotNull RendererConfiguration customRenderers) {
        if (customRenderers == null) {
            NodeRendererSettings.$$$reportNull$$$0(1);
        }
        RendererConfiguration oldConfig = this.myCustomRenderers;
        this.myCustomRenderers = customRenderers;
        if (oldConfig == null || !oldConfig.equals(customRenderers)) {
            this.fireRenderersChanged();
        }
    }

    public PrimitiveRenderer getPrimitiveRenderer() {
        return this.myPrimitiveRenderer;
    }

    public ArrayRenderer getArrayRenderer() {
        return this.myArrayRenderer;
    }

    public ClassRenderer getClassRenderer() {
        return this.myClassRenderer;
    }

    public HexRenderer getHexRenderer() {
        return this.myHexRenderer;
    }

    public ToStringRenderer getToStringRenderer() {
        return this.myToStringRenderer;
    }

    public NodeRenderer[] getAlternateCollectionRenderers() {
        return this.myAlternateCollectionRenderers;
    }

    public void fireRenderersChanged() {
        ((NodeRendererSettingsListener)this.myDispatcher.getMulticaster()).renderersChanged();
    }

    public List<NodeRenderer> getAllRenderers() {
        ArrayList<NodeRenderer> allRenderers = new ArrayList<NodeRenderer>();
        this.myCustomRenderers.iterateRenderers((InternalIterator<NodeRenderer>)((InternalIterator)renderer -> {
            allRenderers.add((NodeRenderer)renderer);
            return true;
        }));
        Collections.addAll(allRenderers, NodeRenderer.EP_NAME.getExtensions());
        allRenderers.add(this.myHexRenderer);
        allRenderers.add(this.myPrimitiveRenderer);
        Collections.addAll(allRenderers, this.myAlternateCollectionRenderers);
        allRenderers.add(this.myToStringRenderer);
        allRenderers.add(this.myArrayRenderer);
        allRenderers.add(this.myClassRenderer);
        if (!this.myUseAndroidRenderer) {
            int androidIndex = -1;
            for (int i = 0; i < allRenderers.size(); ++i) {
                if (!"android.resource.renderer".equals(((NodeRenderer)allRenderers.get(i)).getUniqueId())) continue;
                androidIndex = i;
                break;
            }
            if (androidIndex != -1) {
                NodeRenderer androidRenderer = (NodeRenderer)allRenderers.remove(androidIndex);
                allRenderers.add(androidRenderer);
            }
        }
        return allRenderers;
    }

    public Renderer readRenderer(Element root) throws InvalidDataException {
        if (root == null) {
            return null;
        }
        if (!RENDERER_TAG.equals(root.getName())) {
            throw new InvalidDataException("Cannot read renderer - tag name is not 'Renderer'");
        }
        String rendererId = root.getAttributeValue(RENDERER_ID);
        if (rendererId == null) {
            throw new InvalidDataException("unknown renderer ID: " + rendererId);
        }
        Renderer renderer = this.createRenderer(rendererId);
        if (renderer == null) {
            throw new InvalidDataException("unknown renderer ID: " + rendererId);
        }
        renderer.readExternal(root);
        return renderer;
    }

    public Element writeRenderer(Renderer renderer) throws WriteExternalException {
        Element root = new Element(RENDERER_TAG);
        if (renderer != null) {
            root.setAttribute(RENDERER_ID, renderer.getUniqueId());
            renderer.writeExternal(root);
        }
        return root;
    }

    public Renderer createRenderer(String rendererId) {
        if ("ClassRenderer".equals(rendererId)) {
            return this.myClassRenderer;
        }
        if ("ArrayRenderer".equals(rendererId)) {
            return this.myArrayRenderer;
        }
        if ("PrimitiveRenderer".equals(rendererId)) {
            return this.myPrimitiveRenderer;
        }
        if ("HexRenderer".equals(rendererId)) {
            return this.myHexRenderer;
        }
        if (rendererId.equals("ExpressionChildrenRenderer")) {
            return new ExpressionChildrenRenderer();
        }
        if (rendererId.equals("LabelRenderer")) {
            return new LabelRenderer();
        }
        if (rendererId.equals("EnumerationChildrenRenderer")) {
            return new EnumerationChildrenRenderer();
        }
        if (rendererId.equals("ToStringRenderer")) {
            return this.myToStringRenderer;
        }
        if (rendererId.equals("CompoundNodeRenderer") || rendererId.equals(REFERENCE_RENDERER)) {
            return this.createCompoundReferenceRenderer("unnamed", "java.lang.Object", null, null);
        }
        if (rendererId.equals("CompoundTypeRenderer")) {
            return this.createCompoundTypeRenderer("unnamed", "java.lang.Object", null, null);
        }
        return null;
    }

    public CompoundTypeRenderer createCompoundTypeRenderer(@NonNls String rendererName, @NonNls String className, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundTypeRenderer renderer = new CompoundTypeRenderer(this, rendererName, labelRenderer, childrenRenderer);
        renderer.setClassName(className);
        return renderer;
    }

    public CompoundReferenceRenderer createCompoundReferenceRenderer(@NonNls String rendererName, @NonNls String className, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundReferenceRenderer renderer = new CompoundReferenceRenderer(this, rendererName, labelRenderer, childrenRenderer);
        renderer.setClassName(className);
        return renderer;
    }

    private static ExpressionChildrenRenderer createExpressionArrayChildrenRenderer(String expressionText, String childrenExpandableText, ArrayRenderer arrayRenderer) {
        ExpressionChildrenRenderer renderer = NodeRendererSettings.createExpressionChildrenRenderer(expressionText, childrenExpandableText);
        renderer.setPredictedRenderer(arrayRenderer);
        return renderer;
    }

    public static ExpressionChildrenRenderer createExpressionChildrenRenderer(@NonNls String expressionText, @NonNls String childrenExpandableText) {
        ExpressionChildrenRenderer childrenRenderer = new ExpressionChildrenRenderer();
        childrenRenderer.setChildrenExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText, "", (FileType)StdFileTypes.JAVA));
        if (childrenExpandableText != null) {
            childrenRenderer.setChildrenExpandable(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, childrenExpandableText, "", (FileType)StdFileTypes.JAVA));
        }
        return childrenRenderer;
    }

    public static EnumerationChildrenRenderer createEnumerationChildrenRenderer(@NonNls String[][] expressions) {
        EnumerationChildrenRenderer childrenRenderer = new EnumerationChildrenRenderer();
        if (expressions != null && expressions.length > 0) {
            ArrayList<EnumerationChildrenRenderer.ChildInfo> childrenList = new ArrayList<EnumerationChildrenRenderer.ChildInfo>(expressions.length);
            for (String[] expression : expressions) {
                childrenList.add(new EnumerationChildrenRenderer.ChildInfo(expression[0], new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression[1], "", (FileType)StdFileTypes.JAVA), false));
            }
            childrenRenderer.setChildren(childrenList);
        }
        return childrenRenderer;
    }

    private static LabelRenderer createLabelRenderer(final @NonNls String prefix, @NonNls String expressionText, final @NonNls String postfix) {
        LabelRenderer labelRenderer = new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
                String evaluated = super.calcLabel(descriptor2, evaluationContext, labelListener);
                if (prefix == null && postfix == null) {
                    return evaluated;
                }
                if (prefix != null && postfix != null) {
                    return prefix + evaluated + postfix;
                }
                if (prefix != null) {
                    return prefix + evaluated;
                }
                return evaluated + postfix;
            }
        };
        labelRenderer.setLabelExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText, "", (FileType)StdFileTypes.JAVA));
        return labelRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customRenderers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/settings/NodeRendererSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCustomRenderers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DescriptorUpdater
    implements DescriptorLabelListener {
        private final ValueDescriptor myTargetDescriptor;
        @Nullable
        private ValueDescriptorImpl myKeyDescriptor;
        @Nullable
        private ValueDescriptorImpl myValueDescriptor;
        private final DescriptorLabelListener myDelegate;

        private DescriptorUpdater(ValueDescriptor descriptor2, DescriptorLabelListener delegate) {
            this.myTargetDescriptor = descriptor2;
            this.myDelegate = delegate;
        }

        public void setKeyDescriptor(@Nullable ValueDescriptorImpl keyDescriptor) {
            this.myKeyDescriptor = keyDescriptor;
        }

        public void setValueDescriptor(@Nullable ValueDescriptorImpl valueDescriptor) {
            this.myValueDescriptor = valueDescriptor;
        }

        @Override
        public void labelChanged() {
            this.myTargetDescriptor.setValueLabel(DescriptorUpdater.constructLabelText(DescriptorUpdater.getDescriptorLabel(this.myKeyDescriptor), DescriptorUpdater.getDescriptorLabel(this.myValueDescriptor)));
            this.myDelegate.labelChanged();
        }

        static String constructLabelText(String keylabel, String valueLabel) {
            StringBuilder sb = new StringBuilder();
            sb.append('\"').append(keylabel).append("\" -> ");
            if (!StringUtil.isEmpty((String)valueLabel)) {
                sb.append('\"').append(valueLabel).append('\"');
            }
            return sb.toString();
        }

        private static String getDescriptorLabel(ValueDescriptorImpl keyDescriptor) {
            return keyDescriptor == null ? "null" : keyDescriptor.getValueLabel();
        }
    }

    private static class ListObjectRenderer
    extends CompoundReferenceRenderer {
        public ListObjectRenderer(NodeRendererSettings rendererSettings, ArrayRenderer arrayRenderer) {
            super(rendererSettings, "List", NodeRendererSettings.createLabelRenderer(" size = ", "size()", null), NodeRendererSettings.createExpressionArrayChildrenRenderer("toArray()", "!isEmpty()", arrayRenderer));
            this.setClassName("java.util.List");
        }

        @Override
        public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
            LOG.assertTrue(node.getDescriptor() instanceof ArrayElementDescriptorImpl);
            try {
                return this.getChildValueExpression("this.get(" + ((ArrayElementDescriptorImpl)node.getDescriptor()).getIndex() + ")", node, context);
            }
            catch (IncorrectOperationException e) {
                return super.getChildValueExpression(node, context);
            }
        }
    }

    private static class MapEntryLabelRenderer
    extends ReferenceRenderer
    implements ValueLabelRenderer {
        private static final Computable<String> NULL_LABEL_COMPUTABLE = () -> "null";
        private final MyCachedEvaluator myKeyExpression = new MyCachedEvaluator();
        private final MyCachedEvaluator myValueExpression = new MyCachedEvaluator();

        private MapEntryLabelRenderer() {
            super("java.util.Map$Entry");
            this.myKeyExpression.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getKey()", "", (FileType)StdFileTypes.JAVA));
            this.myValueExpression.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getValue()", "", (FileType)StdFileTypes.JAVA));
        }

        @Override
        public Icon calcValueIcon(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
            return null;
        }

        @Override
        public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
            DescriptorUpdater descriptorUpdater = new DescriptorUpdater(descriptor2, listener2);
            Value originalValue = descriptor2.getValue();
            Pair<Computable<String>, ValueDescriptorImpl> keyPair = this.createValueComputable(evaluationContext, originalValue, this.myKeyExpression, descriptorUpdater);
            Pair<Computable<String>, ValueDescriptorImpl> valuePair = this.createValueComputable(evaluationContext, originalValue, this.myValueExpression, descriptorUpdater);
            descriptorUpdater.setKeyDescriptor((ValueDescriptorImpl)keyPair.second);
            descriptorUpdater.setValueDescriptor((ValueDescriptorImpl)valuePair.second);
            return DescriptorUpdater.constructLabelText((String)((Computable)keyPair.first).compute(), (String)((Computable)valuePair.first).compute());
        }

        private Pair<Computable<String>, ValueDescriptorImpl> createValueComputable(EvaluationContext evaluationContext, Value originalValue, MyCachedEvaluator evaluator, DescriptorLabelListener listener2) throws EvaluateException {
            Value eval = this.doEval(evaluationContext, originalValue, evaluator);
            if (eval != null) {
                WatchItemDescriptor evalDescriptor = new WatchItemDescriptor(evaluationContext.getProject(), evaluator.getReferenceExpression(), eval);
                evalDescriptor.setShowIdLabel(false);
                return new Pair(() -> {
                    evalDescriptor.updateRepresentation((EvaluationContextImpl)evaluationContext, listener2);
                    return evalDescriptor.getValueLabel();
                }, (Object)evalDescriptor);
            }
            return new Pair(NULL_LABEL_COMPUTABLE, null);
        }

        @Override
        public String getUniqueId() {
            return "MapEntry renderer";
        }

        private Value doEval(EvaluationContext evaluationContext, Value originalValue, MyCachedEvaluator cachedEvaluator) throws EvaluateException {
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            if (originalValue == null) {
                return null;
            }
            try {
                ExpressionEvaluator evaluator = cachedEvaluator.getEvaluator(debugProcess.getProject());
                if (!debugProcess.isAttached()) {
                    throw EvaluateExceptionUtil.PROCESS_EXITED;
                }
                EvaluationContext thisEvaluationContext = evaluationContext.createEvaluationContext(originalValue);
                return evaluator.evaluate(thisEvaluationContext);
            }
            catch (EvaluateException ex) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + ex.getMessage(), (Throwable)ex);
            }
        }

        private class MyCachedEvaluator
        extends CachedEvaluator {
            private MyCachedEvaluator() {
            }

            @Override
            protected String getClassName() {
                return MapEntryLabelRenderer.this.getClassName();
            }

            @Override
            public ExpressionEvaluator getEvaluator(Project project2) throws EvaluateException {
                return super.getEvaluator(project2);
            }
        }
    }
}

