/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class MethodBreakpoint
extends BreakpointWithHighlighter<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.MethodBreakpoint");
    @Nullable
    private JVMName mySignature;
    private boolean myIsStatic;
    @NonNls
    public static final Key<MethodBreakpoint> CATEGORY = BreakpointCategory.lookup("method_breakpoints");

    protected MethodBreakpoint(@NotNull Project project2, XBreakpoint breakpoint) {
        if (project2 == null) {
            MethodBreakpoint.$$$reportNull$$$0(0);
        }
        super(project2, breakpoint);
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    @NotNull
    public Key<MethodBreakpoint> getCategory() {
        Key<MethodBreakpoint> key = CATEGORY;
        if (key == null) {
            MethodBreakpoint.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getMethodName() != null;
    }

    @Override
    protected void reload(@NotNull PsiFile psiFile) {
        PsiClass psiClass;
        if (psiFile == null) {
            MethodBreakpoint.$$$reportNull$$$0(2);
        }
        this.setMethodName(null);
        this.mySignature = null;
        MethodDescriptor descriptor2 = MethodBreakpoint.getMethodDescriptor(this.myProject, psiFile, this.getSourcePosition());
        if (descriptor2 != null) {
            this.setMethodName(descriptor2.methodName);
            this.mySignature = descriptor2.methodSignature;
            this.myIsStatic = descriptor2.isStatic;
        }
        if ((psiClass = this.getPsiClass()) != null) {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = psiClass.getQualifiedName();
        }
        if (this.myIsStatic) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    private static void createRequestForSubClasses(final @NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType baseType) {
        if (breakpoint == null) {
            MethodBreakpoint.$$$reportNull$$$0(3);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(4);
        }
        if (baseType == null) {
            MethodBreakpoint.$$$reportNull$$$0(5);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
        ClassPrepareRequest request = requestsManager.createClassPrepareRequest((debuggerProcess, referenceType) -> {
            if (baseType == null) {
                MethodBreakpoint.$$$reportNull$$$0(42);
            }
            if (breakpoint == null) {
                MethodBreakpoint.$$$reportNull$$$0(43);
            }
            if (debugProcess == null) {
                MethodBreakpoint.$$$reportNull$$$0(44);
            }
            if (MethodBreakpoint.instanceOf(referenceType, baseType)) {
                MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, referenceType, false);
            }
        }, null);
        if (request != null) {
            requestsManager.registerRequest(breakpoint, request);
            request.enable();
        }
        AtomicReference indicatorRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (debugProcess == null) {
                MethodBreakpoint.$$$reportNull$$$0(41);
            }
            ProgressWindow progress = new ProgressWindow(true, false, debugProcess.getProject(), "Cancel emulation");
            progress.setDelayInMillis(2000);
            indicatorRef.set(progress);
        });
        final ProgressWindow indicator = (ProgressWindow)indicatorRef.get();
        final AtomicBoolean changed = new AtomicBoolean();
        XBreakpointListener listener2 = new XBreakpointListener<XBreakpoint<?>>(){

            void changed(@NotNull XBreakpoint b) {
                if (b == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (b == breakpoint.getXBreakpoint()) {
                    changed.set(true);
                    indicator.cancel();
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint b) {
                if (b == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.changed(b);
            }

            public void breakpointChanged(@NotNull XBreakpoint b) {
                if (b == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.changed(b);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "b";
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        XDebuggerManager.getInstance((Project)debugProcess.getProject()).getBreakpointManager().addBreakpointListener(listener2, (Disposable)indicator);
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (baseType == null) {
                MethodBreakpoint.$$$reportNull$$$0(36);
            }
            if (breakpoint == null) {
                MethodBreakpoint.$$$reportNull$$$0(37);
            }
            if (debugProcess == null) {
                MethodBreakpoint.$$$reportNull$$$0(38);
            }
            MethodBreakpoint.processPreparedSubTypes(baseType, (subType, classesByName) -> {
                if (breakpoint == null) {
                    MethodBreakpoint.$$$reportNull$$$0(39);
                }
                if (debugProcess == null) {
                    MethodBreakpoint.$$$reportNull$$$0(40);
                }
                MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, subType, classesByName, false);
            }, (ProgressIndicator)indicator);
        }, (ProgressIndicator)indicator);
        if (indicator.isCanceled() && !changed.get()) {
            breakpoint.disableEmulation();
        }
    }

    @Override
    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation(this);
    }

    static void createRequestForPreparedClassEmulated(@NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, boolean base) {
        if (breakpoint == null) {
            MethodBreakpoint.$$$reportNull$$$0(6);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(7);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(8);
        }
        MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, classType, debugProcess.getVirtualMachineProxy().getClassesByNameProvider(), base);
    }

    static void createRequestForPreparedClassEmulated(final @NotNull MethodBreakpointBase breakpoint, final @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, @NotNull ClassesByNameProvider classesByName, boolean base) {
        if (breakpoint == null) {
            MethodBreakpoint.$$$reportNull$$$0(9);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(10);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(11);
        }
        if (classesByName == null) {
            MethodBreakpoint.$$$reportNull$$$0(12);
        }
        if (!base && !MethodBreakpoint.shouldCreateRequest(breakpoint, breakpoint.getXBreakpoint(), debugProcess, true)) {
            return;
        }
        try {
            Method lambdaMethod = MethodBytecodeUtil.getLambdaMethod(classType, classesByName);
            if (lambdaMethod != null && !breakpoint.matchingMethods((StreamEx<Method>)StreamEx.of(((ClassType)classType).interfaces()).flatCollection(ReferenceType::allMethods), debugProcess).findFirst().isPresent()) {
                return;
            }
            StreamEx methods = lambdaMethod != null ? StreamEx.of((Object)lambdaMethod) : breakpoint.matchingMethods((StreamEx<Method>)((StreamEx)StreamEx.of(classType.methods()).filter(m -> base || !m.isAbstract())), debugProcess);
            boolean found = false;
            for (Method method : methods) {
                List<Location> allLineLocations;
                found = true;
                if (method.isNative()) {
                    breakpoint.disableEmulation();
                    return;
                }
                Method target = MethodBytecodeUtil.getBridgeTargetMethod(method, classesByName);
                if (target != null && !ContainerUtil.isEmpty(DebuggerUtilsEx.allLineLocations(target))) {
                    method = target;
                }
                if ((allLineLocations = DebuggerUtilsEx.allLineLocations(method)) == null && !method.isBridge()) {
                    breakpoint.disableEmulation();
                    return;
                }
                if (ContainerUtil.isEmpty(allLineLocations)) continue;
                if (breakpoint.isWatchEntry()) {
                    MethodBreakpoint.createLocationBreakpointRequest(breakpoint, (Location)ContainerUtil.getFirstItem(allLineLocations), debugProcess, true);
                }
                if (!breakpoint.isWatchExit()) continue;
                MethodBytecodeUtil.visit(method, new MethodVisitor(393216){
                    int myLastLine;
                    {
                        super(x0);
                        this.myLastLine = 0;
                    }

                    public void visitLineNumber(int line, Label start) {
                        this.myLastLine = line;
                    }

                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 172: 
                            case 173: 
                            case 174: 
                            case 175: 
                            case 176: 
                            case 177: {
                                allLineLocations.stream().filter(l -> l.lineNumber() == this.myLastLine).findFirst().ifPresent(location -> {
                                    if (breakpoint == null) {
                                        2.$$$reportNull$$$0(0);
                                    }
                                    if (debugProcess == null) {
                                        2.$$$reportNull$$$0(1);
                                    }
                                    MethodBreakpoint.createLocationBreakpointRequest(breakpoint, location, debugProcess, false);
                                });
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "breakpoint";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugProcess";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$2";
                        objectArray[2] = "lambda$visitInsn$1";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, true);
            }
            if (base && found) {
                MethodBreakpoint.createRequestForSubClasses(breakpoint, debugProcess, classType);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    private static void createLocationBreakpointRequest(@NotNull FilteredRequestor requestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcess, boolean methodEntry) {
        BreakpointRequest request;
        if (requestor == null) {
            MethodBreakpoint.$$$reportNull$$$0(13);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(14);
        }
        if ((request = MethodBreakpoint.createLocationBreakpointRequest(requestor, location, debugProcess)) != null) {
            request.putProperty("METHOD_ENTRY_KEY", methodEntry);
        }
    }

    @Override
    protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(15);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(16);
        }
        if (this.isEmulated()) {
            MethodBreakpoint.createRequestForPreparedClassEmulated(this, debugProcess, classType, true);
        } else {
            this.createRequestForPreparedClassOriginal(debugProcess, classType);
        }
    }

    private void createRequestForPreparedClassOriginal(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(17);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(18);
        }
        try {
            boolean hasMethod = false;
            for (Method method : classType.allMethods()) {
                String signature = method.signature();
                String name2 = method.name();
                if (!this.getMethodName().equals(name2) || !this.mySignature.getName(debugProcess).equals(signature)) continue;
                hasMethod = true;
                break;
            }
            if (!hasMethod) {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.method.not.found", (Object[])new Object[]{classType.name()}));
                return;
            }
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            if (this.isWatchEntry()) {
                MethodEntryRequest entryRequest = MethodBreakpoint.findRequest(debugProcess, MethodEntryRequest.class, this);
                if (entryRequest == null) {
                    entryRequest = requestManager.createMethodEntryRequest(this);
                } else {
                    entryRequest.disable();
                }
                entryRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(entryRequest);
            }
            if (this.isWatchExit()) {
                MethodExitRequest exitRequest = MethodBreakpoint.findRequest(debugProcess, MethodExitRequest.class, this);
                if (exitRequest == null) {
                    exitRequest = requestManager.createMethodExitRequest(this);
                } else {
                    exitRequest.disable();
                }
                exitRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(exitRequest);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent event) {
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(19);
        }
        return MethodBreakpoint.getEventMessage(event, this.getFileName());
    }

    static String getEventMessage(@NotNull LocatableEvent event, @NotNull String defaultFileName) {
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(20);
        }
        if (defaultFileName == null) {
            MethodBreakpoint.$$$reportNull$$$0(21);
        }
        Location location = event.location();
        if (event instanceof MethodEntryEvent) {
            return MethodBreakpoint.getEventMessage(true, ((MethodEntryEvent)event).method(), location, defaultFileName);
        }
        if (event instanceof MethodExitEvent) {
            return MethodBreakpoint.getEventMessage(false, ((MethodExitEvent)event).method(), location, defaultFileName);
        }
        Object entryProperty = event.request().getProperty("METHOD_ENTRY_KEY");
        if (entryProperty instanceof Boolean) {
            return MethodBreakpoint.getEventMessage((Boolean)entryProperty, location.method(), location, defaultFileName);
        }
        return "";
    }

    private static String getEventMessage(boolean entry, Method method, Location location, String defaultFileName) {
        String locationQName = DebuggerUtilsEx.getLocationMethodQName(location);
        String locationFileName = DebuggerUtilsEx.getSourceName(location, e -> defaultFileName);
        int locationLine = location.lineNumber();
        return DebuggerBundle.message((String)(entry ? "status.method.entry.breakpoint.reached" : "status.method.exit.breakpoint.reached"), (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
        if (master != null) {
            return isMuted ? AllIcons.Debugger.Db_muted_dep_method_breakpoint : AllIcons.Debugger.Db_dep_method_breakpoint;
        }
        return null;
    }

    @Override
    @NotNull
    protected Icon getInvalidIcon(boolean isMuted) {
        Icon icon = isMuted ? AllIcons.Debugger.Db_muted_invalid_method_breakpoint : AllIcons.Debugger.Db_invalid_method_breakpoint;
        if (icon == null) {
            MethodBreakpoint.$$$reportNull$$$0(22);
        }
        return icon;
    }

    @Override
    @NotNull
    protected Icon getVerifiedIcon(boolean isMuted) {
        Icon icon = isMuted ? AllIcons.Debugger.Db_muted_verified_method_breakpoint : AllIcons.Debugger.Db_verified_method_breakpoint;
        if (icon == null) {
            MethodBreakpoint.$$$reportNull$$$0(23);
        }
        return icon;
    }

    @Override
    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        Icon icon = isMuted ? AllIcons.Debugger.Db_muted_method_warning_breakpoint : AllIcons.Debugger.Db_method_warning_breakpoint;
        if (icon == null) {
            MethodBreakpoint.$$$reportNull$$$0(24);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            if (this.isValid()) {
                boolean classNameExists;
                String className = this.getClassName();
                boolean bl = classNameExists = className != null && className.length() > 0;
                if (classNameExists) {
                    buffer.append(className);
                }
                if (this.getMethodName() != null) {
                    if (classNameExists) {
                        buffer.append(".");
                    }
                    buffer.append(this.getMethodName());
                }
            } else {
                buffer.append(DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]));
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    @Override
    public boolean evaluateCondition(@NotNull EvaluationContextImpl context, @NotNull LocatableEvent event) throws EvaluateException {
        if (context == null) {
            MethodBreakpoint.$$$reportNull$$$0(25);
        }
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(26);
        }
        if (!this.matchesEvent(event, context.getDebugProcess())) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public boolean matchesEvent(@NotNull LocatableEvent event, DebugProcessImpl process2) throws EvaluateException {
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(27);
        }
        if (this.isEmulated()) {
            return true;
        }
        if (this.getMethodName() == null || this.mySignature == null) {
            return false;
        }
        Method method = event.location().method();
        return method != null && method.name().equals(this.getMethodName()) && method.signature().equals(this.mySignature.getName(process2));
    }

    @Nullable
    public static MethodBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            MethodBreakpoint.$$$reportNull$$$0(28);
        }
        MethodBreakpoint breakpoint = new MethodBreakpoint(project2, xBreakpoint);
        return (MethodBreakpoint)breakpoint.init();
    }

    @Nullable
    private static MethodDescriptor getMethodDescriptor(@NotNull Project project2, @NotNull PsiFile psiJavaFile, @Nullable SourcePosition sourcePosition) {
        if (project2 == null) {
            MethodBreakpoint.$$$reportNull$$$0(29);
        }
        if (psiJavaFile == null) {
            MethodBreakpoint.$$$reportNull$$$0(30);
        }
        if (sourcePosition == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiJavaFile);
        if (document == null) {
            return null;
        }
        MethodDescriptor descriptor2 = (MethodDescriptor)ReadAction.compute(() -> {
            PsiMethod method;
            if (project2 == null) {
                MethodBreakpoint.$$$reportNull$$$0(35);
            }
            if ((method = PositionUtil.getPsiElementAt(project2, PsiMethod.class, sourcePosition)) == null) {
                return null;
            }
            int methodOffset = method.getTextOffset();
            if (methodOffset < 0) {
                return null;
            }
            if (document.getLineNumber(methodOffset) < sourcePosition.getLine()) {
                return null;
            }
            PsiIdentifier identifier = method.getNameIdentifier();
            int methodNameOffset = identifier != null ? identifier.getTextOffset() : methodOffset;
            MethodDescriptor res = new MethodDescriptor();
            res.methodName = JVMNameUtil.getJVMMethodName(method);
            try {
                res.methodSignature = JVMNameUtil.getJVMSignature(method);
                res.isStatic = method.hasModifierProperty("static");
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
            res.methodLine = document.getLineNumber(methodNameOffset);
            return res;
        });
        if (descriptor2 == null || descriptor2.methodName == null || descriptor2.methodSignature == null) {
            return null;
        }
        return descriptor2;
    }

    @Nullable
    static <T extends EventRequest> T findRequest(@NotNull DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor) {
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(31);
        }
        return (T)((EventRequest)StreamEx.of(debugProcess.getRequestsManager().findRequests(requestor)).select(requestClass).findFirst().orElse(null));
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        if (breakpointNode == null) {
            MethodBreakpoint.$$$reportNull$$$0(32);
        }
        super.readExternal(breakpointNode);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).EMULATED;
    }

    @Override
    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    @Override
    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        try {
            String methodName = this.getMethodName();
            String signature = this.mySignature != null ? this.mySignature.getName(debugProcess) : null;
            return (StreamEx)((StreamEx)methods.filter(m -> Comparing.equal((String)methodName, (String)m.name()) && Comparing.equal((String)signature, (String)m.signature()))).limit(1L);
        }
        catch (EvaluateException e) {
            LOG.warn((Throwable)e);
            return StreamEx.empty();
        }
    }

    @Nullable
    private String getMethodName() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    private void setMethodName(@Nullable String methodName) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = methodName;
    }

    private static boolean instanceOf(@Nullable ReferenceType type, @NotNull ReferenceType superType) {
        if (superType == null) {
            MethodBreakpoint.$$$reportNull$$$0(33);
        }
        if (type == null) {
            return false;
        }
        if (superType.equals(type)) {
            return true;
        }
        return MethodBreakpoint.supertypes(type).anyMatch(t -> {
            if (superType == null) {
                MethodBreakpoint.$$$reportNull$$$0(34);
            }
            return MethodBreakpoint.instanceOf(t, superType);
        });
    }

    private static Stream<? extends ReferenceType> supertypes(ReferenceType type) {
        if (type instanceof InterfaceType) {
            return ((InterfaceType)type).superinterfaces().stream();
        }
        if (type instanceof ClassType) {
            return StreamEx.ofNullable((Object)((ClassType)type).superclass()).prepend(((ClassType)type).interfaces());
        }
        return StreamEx.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPreparedSubTypes(ReferenceType classType, BiConsumer<ReferenceType, ClassesByNameProvider> consumer, ProgressIndicator progressIndicator) {
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        progressIndicator.setIndeterminate(false);
        progressIndicator.start();
        progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.processing.classes", (Object[])new Object[0]));
        try {
            MultiMap inheritance = new MultiMap();
            List<ReferenceType> allTypes = classType.virtualMachine().allClasses();
            for (int i = 0; i < allTypes.size(); ++i) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                ReferenceType type = allTypes.get(i);
                if (type.isPrepared()) {
                    MethodBreakpoint.supertypes(type).forEach(st -> inheritance.putValue(st, (Object)type));
                }
                progressIndicator.setText2(i + "/" + allTypes.size());
                progressIndicator.setFraction((double)i / (double)allTypes.size());
            }
            List types = ((StreamEx)StreamEx.ofTree((Object)classType, t -> StreamEx.of((Collection)inheritance.get(t))).skip(1L)).toList();
            progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.setting.breakpoints", (Object[])new Object[0]));
            ClassesByNameProvider classesByName = ClassesByNameProvider.createCache(allTypes);
            for (int i = 0; i < types.size(); ++i) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                consumer.accept((ReferenceType)types.get(i), classesByName);
                progressIndicator.setText2(i + "/" + types.size());
                progressIndicator.setFraction((double)i / (double)types.size());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processed " + types.size() + " classes in " + String.valueOf(System.currentTimeMillis() - start) + "ms");
            }
        }
        finally {
            progressIndicator.stop();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 31: 
            case 38: 
            case 40: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 5: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesByName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 19: 
            case 20: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFileName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiJavaFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerifiedIcon";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerifiedWarningsIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reload";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForSubClasses";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassEmulated";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLocationBreakpointRequest";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassOriginal";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEventMessage";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "matchesEvent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDescriptor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findRequest";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$instanceOf$8";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMethodDescriptor$6";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequestForSubClasses$3";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequestForSubClasses$1";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequestForSubClasses$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MethodDescriptor {
        String methodName;
        JVMName methodSignature;
        boolean isStatic;
        int methodLine;

        private MethodDescriptor() {
        }
    }
}

