/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.SimpleColoredText;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeNodeImpl
extends TreeBuilderNode
implements DebuggerTreeNode,
NodeDescriptorProvider,
MutableTreeNode {
    private Icon myIcon;
    private SimpleColoredText myText;
    private String myMarkupTooltipText;
    private final DebuggerTree myTree;
    private final Map myProperties = new HashMap();

    public DebuggerTreeNodeImpl(DebuggerTree tree, NodeDescriptor descriptor2) {
        super(descriptor2);
        this.myTree = tree;
    }

    @Override
    public DebuggerTreeNodeImpl getParent() {
        return (DebuggerTreeNodeImpl)super.getParent();
    }

    @Override
    protected TreeBuilder getTreeBuilder() {
        return this.myTree.getMutableModel();
    }

    public DebuggerTree getTree() {
        return this.myTree;
    }

    @Override
    public String toString() {
        return this.myText != null ? this.myText.toString() : "";
    }

    @Override
    public NodeDescriptorImpl getDescriptor() {
        return (NodeDescriptorImpl)this.getUserObject();
    }

    @Override
    public Project getProject() {
        return this.getTree().getProject();
    }

    @Override
    public void setRenderer(NodeRenderer renderer) {
        ((ValueDescriptorImpl)this.getDescriptor()).setRenderer(renderer);
        this.calcRepresentation();
    }

    private void updateCaches() {
        ValueMarkup markup;
        NodeDescriptorImpl descriptor2 = this.getDescriptor();
        this.myIcon = DebuggerTreeRenderer.getDescriptorIcon(descriptor2);
        DebuggerContextImpl context = this.getTree().getDebuggerContext();
        this.myText = DebuggerTreeRenderer.getDescriptorText(context, descriptor2, DebuggerUIUtil.getColorScheme((JComponent)((Object)this.myTree)), false);
        this.myMarkupTooltipText = descriptor2 instanceof ValueDescriptor ? ((markup = ((ValueDescriptor)((Object)descriptor2)).getMarkup(context.getDebugProcess())) != null ? markup.getToolTipText() : null) : null;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public SimpleColoredText getText() {
        return this.myText;
    }

    @Nullable
    public String getMarkupTooltipText() {
        return this.myMarkupTooltipText;
    }

    @Override
    public void clear() {
        this.removeAllChildren();
        this.myIcon = null;
        this.myText = null;
        super.clear();
    }

    private void update(DebuggerContextImpl context, final Runnable runnable2, boolean labelOnly) {
        if (!labelOnly) {
            this.clear();
        }
        if (context != null && context.getDebugProcess() != null) {
            this.getTree().saveState(this);
            this.myIcon = DebuggerTreeRenderer.getDescriptorIcon(MessageDescriptor.EVALUATING);
            this.myText = DebuggerTreeRenderer.getDescriptorText(context, MessageDescriptor.EVALUATING, false);
            context.getDebugProcess().getManagerThread().invoke(new DebuggerContextCommandImpl(context){

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    runnable2.run();
                }

                @Override
                protected void commandCancelled() {
                    DebuggerTreeNodeImpl.this.clear();
                    DebuggerTreeNodeImpl.this.getDescriptor().clear();
                    DebuggerTreeNodeImpl.this.updateCaches();
                    DebuggerTreeNodeImpl.this.labelChanged();
                    DebuggerTreeNodeImpl.this.childrenChanged(true);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/impl/watch/DebuggerTreeNodeImpl$1", "threadAction"));
                }
            });
        }
        this.labelChanged();
        if (!labelOnly) {
            this.childrenChanged(true);
        }
    }

    public void calcLabel() {
        DebuggerContextImpl context = this.getTree().getDebuggerContext();
        this.update(context, () -> this.getDescriptor().updateRepresentation(context.createEvaluationContext(), new DescriptorLabelListener(){

            @Override
            public void labelChanged() {
                DebuggerTreeNodeImpl.this.updateCaches();
                DebuggerTreeNodeImpl.this.labelChanged();
            }
        }), true);
    }

    public void calcRepresentation() {
        DebuggerContextImpl context = this.getTree().getDebuggerContext();
        this.update(context, () -> this.getDescriptor().updateRepresentation(context.createEvaluationContext(), new DescriptorLabelListener(){

            @Override
            public void labelChanged() {
                DebuggerTreeNodeImpl.this.updateCaches();
                DebuggerTreeNodeImpl.this.labelChanged();
            }
        }), false);
    }

    public void calcValue() {
        DebuggerContextImpl context = this.getTree().getDebuggerContext();
        this.update(context, () -> {
            EvaluationContextImpl evaluationContext = context.createEvaluationContext();
            this.getDescriptor().setContext(evaluationContext);
            this.getDescriptor().updateRepresentation(evaluationContext, new DescriptorLabelListener(){

                @Override
                public void labelChanged() {
                    DebuggerTreeNodeImpl.this.updateCaches();
                    DebuggerTreeNodeImpl.this.labelChanged();
                }
            });
            this.childrenChanged(true);
        }, false);
    }

    private static void invoke(Runnable r) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void labelChanged() {
        DebuggerTreeNodeImpl.invoke(() -> {
            this.updateCaches();
            this.getTree().getMutableModel().nodeChanged(this);
        });
    }

    public void childrenChanged(boolean scrollToVisible) {
        DebuggerTreeNodeImpl.invoke(() -> {
            this.getTree().getMutableModel().nodeStructureChanged(this);
            this.getTree().restoreState(this);
        });
    }

    public DebuggerTreeNodeImpl add(MessageDescriptor message) {
        DebuggerTreeNodeImpl node = this.getNodeFactory().createMessageNode(message);
        this.add(node);
        return node;
    }

    public NodeManagerImpl getNodeFactory() {
        return this.myTree.getNodeFactory();
    }

    public Object getProperty(Key key) {
        return this.myProperties.get(key);
    }

    public void putProperty(Key key, Object data) {
        this.myProperties.put(key, data);
    }

    @NotNull
    public static DebuggerTreeNodeImpl createNodeNoUpdate(DebuggerTree tree, NodeDescriptor descriptor2) {
        DebuggerTreeNodeImpl node = new DebuggerTreeNodeImpl(tree, descriptor2);
        node.updateCaches();
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = node;
        if (debuggerTreeNodeImpl == null) {
            DebuggerTreeNodeImpl.$$$reportNull$$$0(0);
        }
        return debuggerTreeNodeImpl;
    }

    @NotNull
    protected static DebuggerTreeNodeImpl createNode(DebuggerTree tree, NodeDescriptorImpl descriptor2, EvaluationContextImpl evaluationContext) {
        final DebuggerTreeNodeImpl node = new DebuggerTreeNodeImpl(tree, descriptor2);
        descriptor2.updateRepresentationNoNotify(evaluationContext, new DescriptorLabelListener(){

            @Override
            public void labelChanged() {
                node.updateCaches();
                node.labelChanged();
            }
        });
        node.updateCaches();
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = node;
        if (debuggerTreeNodeImpl == null) {
            DebuggerTreeNodeImpl.$$$reportNull$$$0(1);
        }
        return debuggerTreeNodeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/ui/impl/watch/DebuggerTreeNodeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeNoUpdate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

