/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.codeInspection.SmartHashMap;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.VMDisconnectedException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class NodeDescriptorImpl
implements NodeDescriptor {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl");
    public static final String UNKNOWN_VALUE_MESSAGE = "";
    public boolean myIsExpanded = false;
    public boolean myIsSelected = false;
    public boolean myIsVisible = false;
    public boolean myIsSynthetic = false;
    private EvaluateException myEvaluateException;
    private String myLabel = "";
    private Map<Key, Object> myUserData;
    private static final Key<Map<ObjectReference, ValueMarkup>> MARKUP_MAP_KEY = new Key("ValueMarkupMap");

    public String getName() {
        return null;
    }

    public <T> T getUserData(Key<T> key) {
        if (this.myUserData == null) {
            return null;
        }
        return (T)this.myUserData.get(key);
    }

    public <T> void putUserData(Key<T> key, T value) {
        if (this.myUserData == null) {
            this.myUserData = new SmartHashMap();
        }
        this.myUserData.put(key, value);
    }

    public void updateRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        this.updateRepresentationNoNotify(context, labelListener);
        labelListener.labelChanged();
    }

    protected void updateRepresentationNoNotify(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        try {
            try {
                this.myEvaluateException = null;
                this.myLabel = this.calcRepresentation(context, labelListener);
            }
            catch (InconsistentDebugInfoException e) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.inconsistent.debug.info", (Object[])new Object[0]));
            }
            catch (InvalidStackFrameException e) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.stackframe", (Object[])new Object[0]));
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof InterruptedException) {
                    throw e;
                }
                LOG.error((Throwable)e);
                throw new EvaluateException("Internal error, see logs for more details");
            }
        }
        catch (EvaluateException e) {
            this.setFailed(e);
        }
    }

    protected abstract String calcRepresentation(EvaluationContextImpl var1, DescriptorLabelListener var2) throws EvaluateException;

    public void displayAs(NodeDescriptor descriptor2) {
        if (descriptor2 instanceof NodeDescriptorImpl) {
            NodeDescriptorImpl that = (NodeDescriptorImpl)descriptor2;
            this.myIsExpanded = that.myIsExpanded;
            this.myIsSelected = that.myIsSelected;
            this.myIsVisible = that.myIsVisible;
            HashMap<Key, Object> hashMap = this.myUserData = that.myUserData != null ? new HashMap<Key, Object>(that.myUserData) : null;
            if (this.myUserData != null) {
                this.myUserData.remove(OnDemandRenderer.ON_DEMAND_CALCULATED);
            }
        }
    }

    public abstract boolean isExpandable();

    public abstract void setContext(EvaluationContextImpl var1);

    public EvaluateException getEvaluateException() {
        return this.myEvaluateException;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String toString() {
        return this.getLabel();
    }

    protected String setFailed(EvaluateException e) {
        this.myEvaluateException = e;
        return e.getMessage();
    }

    protected String setLabel(String customLabel) {
        this.myLabel = customLabel;
        return this.myLabel;
    }

    public void clear() {
        this.myEvaluateException = null;
        this.myLabel = UNKNOWN_VALUE_MESSAGE;
    }

    public void setAncestor(NodeDescriptor oldDescriptor) {
        this.displayAs(oldDescriptor);
    }

    @Nullable
    public static Map<ObjectReference, ValueMarkup> getMarkupMap(DebugProcess process2) {
        if (process2 == null) {
            return null;
        }
        HashMap map2 = (HashMap)process2.getUserData(MARKUP_MAP_KEY);
        if (map2 == null) {
            map2 = new HashMap();
            process2.putUserData(MARKUP_MAP_KEY, map2);
        }
        return map2;
    }
}

