/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.List;

public class MorphingAction
extends AnAction {
    private final DesignerEditorPanel myDesigner;
    private final EditableArea myArea;
    private final List<RadComponent> myComponents;
    private final MetaModel myTarget;

    public MorphingAction(DesignerEditorPanel designer, EditableArea area, List<RadComponent> components, MetaModel target) {
        super(target.getTag(), null, target.getIcon());
        this.myDesigner = designer;
        this.myArea = area;
        this.myComponents = components;
        this.myTarget = target;
    }

    public void update(AnActionEvent e) {
        PaletteItem paletteItem = this.myTarget.getPaletteItem();
        e.getPresentation().setEnabled(paletteItem == null || paletteItem.isEnabled());
    }

    public void actionPerformed(AnActionEvent e) {
        this.myDesigner.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            ArrayList<RadComponent> newComponents = new ArrayList<RadComponent>();
            for (RadComponent component : this.myComponents) {
                RadComponent newComponent = component.morphingTo(this.myTarget);
                if (newComponent == null) continue;
                newComponents.add(newComponent);
            }
            this.myArea.setSelection(newComponents);
        }), "Run Morphing action", true);
    }

    public static void fill(DesignerEditorPanel designer, DefaultActionGroup group, EditableArea area) {
        List<RadComponent> selection = area.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        MetaModel model2 = null;
        for (RadComponent component : selection) {
            if (model2 == null) {
                model2 = component.getMetaModel();
                continue;
            }
            if (model2 == component.getMetaModel()) continue;
            return;
        }
        if (model2 == null) {
            return;
        }
        List<MetaModel> models = model2.getMorphingModels();
        if (models.isEmpty()) {
            return;
        }
        DefaultActionGroup morphingGroup = new DefaultActionGroup("Morphing", true);
        for (MetaModel morphingModel : models) {
            morphingGroup.add((AnAction)new MorphingAction(designer, area, selection, morphingModel));
        }
        group.add((AnAction)morphingGroup);
    }
}

