/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.ToolProvider;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public final class ComponentGlassLayer
implements KeyListener,
MouseListener,
MouseMotionListener {
    private final JComponent myComponent;
    private final ToolProvider myToolProvider;
    private final EditableArea myArea;

    public ComponentGlassLayer(JComponent component, ToolProvider provider2, EditableArea area) {
        this.myComponent = component;
        this.myToolProvider = provider2;
        this.myArea = area;
        this.myComponent.addKeyListener(this);
        this.myComponent.addMouseListener(this);
        this.myComponent.addMouseMotionListener(this);
    }

    public void dispose() {
        this.myComponent.removeKeyListener(this);
        this.myComponent.removeMouseListener(this);
        this.myComponent.removeMouseMotionListener(this);
    }

    @Override
    public void keyTyped(KeyEvent event) {
        this.myToolProvider.processKeyEvent(event, this.myArea);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.myToolProvider.processKeyEvent(event, this.myArea);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.myToolProvider.processKeyEvent(event, this.myArea);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.myToolProvider.processMouseEvent(event, this.myArea);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.myToolProvider.processMouseEvent(event, this.myArea);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.myToolProvider.processMouseEvent(event, this.myArea);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.myToolProvider.processMouseEvent(event, this.myArea);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.myToolProvider.processMouseEvent(event, this.myArea);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.myToolProvider.processMouseEvent(event, this.myArea);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.myToolProvider.processMouseEvent(event, this.myArea);
    }
}

