/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractPatternBasedConfigurationProducer<T extends JavaTestConfigurationBase>
extends AbstractJavaTestConfigurationProducer<T>
implements Cloneable {
    public AbstractPatternBasedConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public boolean isConfiguredFromContext(ConfigurationContext context, Set<String> patterns) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)dataContext)) {
            return false;
        }
        PsiElement[] locationElements = this.collectLocationElements(classes, dataContext);
        if (locationElements == null) {
            this.collectContextElements(dataContext, true, false, classes, (PsiElementProcessor.CollectElements<PsiElement>)new PsiElementProcessor.CollectElements());
        }
        if (Comparing.equal(classes, patterns)) {
            String pattern;
            if (patterns.size() == 1 && !(pattern = patterns.iterator().next()).contains(",")) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)), PsiMethod.class);
                return method != null && this.isTestMethod(false, method);
            }
            return true;
        }
        return false;
    }

    public PsiElement checkPatterns(ConfigurationContext context, LinkedHashSet<String> classes) {
        PsiElement[] result;
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)dataContext)) {
            return null;
        }
        PsiElement[] locationElements = this.collectLocationElements(classes, dataContext);
        PsiElementProcessor.CollectElements processor2 = new PsiElementProcessor.CollectElements();
        if (locationElements != null) {
            this.collectTestMembers(locationElements, false, true, (PsiElementProcessor.CollectElements<PsiElement>)processor2);
            result = processor2.toArray();
        } else if (this.collectContextElements(dataContext, true, true, classes, (PsiElementProcessor.CollectElements<PsiElement>)processor2)) {
            result = processor2.toArray();
        } else {
            return null;
        }
        if (result.length <= 1) {
            return null;
        }
        return result[0];
    }
}

