/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.addSupport.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.addSupport.impl.AddSupportForSingleFrameworkDialog;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddFrameworkSupportInProjectStructureAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.addSupport.impl.AddFrameworkSupportInProjectStructureAction");
    private final FrameworkTypeEx myFrameworkType;
    private final FrameworkSupportInModuleProvider myProvider;
    @NotNull
    private final ModuleStructureConfigurable myModuleStructureConfigurable;

    public AddFrameworkSupportInProjectStructureAction(@NotNull FrameworkTypeEx frameworkType, @NotNull FrameworkSupportInModuleProvider provider2, @NotNull ModuleStructureConfigurable moduleStructureConfigurable) {
        if (frameworkType == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(1);
        }
        if (moduleStructureConfigurable == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(2);
        }
        super(frameworkType.getPresentableName(), "Add " + frameworkType.getPresentableName() + " support", frameworkType.getIcon());
        this.myFrameworkType = frameworkType;
        this.myProvider = provider2;
        this.myModuleStructureConfigurable = moduleStructureConfigurable;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(this.isVisible());
    }

    private boolean isVisible() {
        Module module2 = this.getSelectedModule();
        if (module2 == null || !this.myProvider.isEnabledForModuleType(ModuleType.get((Module)module2))) {
            return false;
        }
        ProjectFacetsConfigurator facetsProvider = this.myModuleStructureConfigurable.getFacetConfigurator();
        if (!this.myProvider.canAddSupport(module2, facetsProvider)) {
            return false;
        }
        String underlyingFrameworkTypeId = this.myFrameworkType.getUnderlyingFrameworkTypeId();
        if (underlyingFrameworkTypeId == null) {
            return true;
        }
        FrameworkSupportInModuleProvider underlyingProvider = FrameworkSupportUtil.findProvider(underlyingFrameworkTypeId, FrameworkSupportUtil.getAllProviders());
        if (underlyingProvider == null) {
            LOG.error("framework not found by id " + underlyingFrameworkTypeId);
        }
        return underlyingProvider.isSupportAlreadyAdded(module2, facetsProvider);
    }

    @Nullable
    private Module getSelectedModule() {
        Object selected = this.myModuleStructureConfigurable.getSelectedObject();
        if (selected instanceof Module) {
            return (Module)selected;
        }
        Facet facet = this.getSelectedFacet();
        return facet != null ? facet.getModule() : null;
    }

    @Nullable
    private Facet getSelectedFacet() {
        Object selected = this.myModuleStructureConfigurable.getSelectedObject();
        if (selected instanceof Facet) {
            return (Facet)selected;
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        Module module2 = this.getSelectedModule();
        if (module2 == null) {
            return;
        }
        LibrariesContainer librariesContainer = LibrariesContainerFactory.createContainer(this.myModuleStructureConfigurable.getContext());
        new AddSupportForSingleFrameworkDialog(module2, this.myFrameworkType, this.myProvider, librariesContainer, new IdeaModifiableModelsProvider()).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "frameworkType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "provider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleStructureConfigurable";
                break;
            }
        }
        objectArray[1] = "com/intellij/framework/addSupport/impl/AddFrameworkSupportInProjectStructureAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

