/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.addSupport.impl;

import com.intellij.CommonBundle;
import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportOptionsComponent;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AddSupportForSingleFrameworkDialog
extends DialogWrapper {
    private final Module myModule;
    private final FrameworkSupportInModuleConfigurable myConfigurable;
    private final FrameworkSupportModelBase myModel;
    private final FrameworkSupportOptionsComponent myComponent;
    private final FrameworkTypeEx myFrameworkType;
    private final ModifiableModelsProvider myModifiableModelsProvider;

    public AddSupportForSingleFrameworkDialog(@NotNull Module module2, FrameworkTypeEx frameworkType, @NotNull FrameworkSupportInModuleProvider provider2, @NotNull LibrariesContainer librariesContainer, ModifiableModelsProvider modifiableModelsProvider) {
        if (module2 == null) {
            AddSupportForSingleFrameworkDialog.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            AddSupportForSingleFrameworkDialog.$$$reportNull$$$0(1);
        }
        if (librariesContainer == null) {
            AddSupportForSingleFrameworkDialog.$$$reportNull$$$0(2);
        }
        super(module2.getProject(), true);
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        VirtualFile baseDir = roots.length > 0 ? roots[0] : module2.getProject().getBaseDir();
        String baseDirectoryForLibraries = baseDir != null ? baseDir.getPath() : "";
        this.myFrameworkType = frameworkType;
        this.myModifiableModelsProvider = modifiableModelsProvider;
        this.setTitle(ProjectBundle.message((String)"dialog.title.add.framework.0.support", (Object[])new Object[]{frameworkType.getPresentableName()}));
        this.myModule = module2;
        this.myModel = new FrameworkSupportModelImpl(module2.getProject(), baseDirectoryForLibraries, librariesContainer);
        this.myConfigurable = provider2.createConfigurable(this.myModel);
        this.myComponent = new FrameworkSupportOptionsComponent(this.myModel, this.myModel.getLibrariesContainer(), this.myDisposable, provider2, this.myConfigurable);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myConfigurable);
        this.init();
    }

    public static AddSupportForSingleFrameworkDialog createDialog(@NotNull Module module2, @NotNull FrameworkSupportInModuleProvider provider2) {
        List<FrameworkSupportInModuleProvider> providers;
        if (module2 == null) {
            AddSupportForSingleFrameworkDialog.$$$reportNull$$$0(3);
        }
        if (provider2 == null) {
            AddSupportForSingleFrameworkDialog.$$$reportNull$$$0(4);
        }
        if ((providers = FrameworkSupportUtil.getProviders(module2, DefaultFacetsProvider.INSTANCE)).isEmpty()) {
            return null;
        }
        IdeaModifiableModelsProvider modifiableModelsProvider = new IdeaModifiableModelsProvider();
        LibrariesContainer container = LibrariesContainerFactory.createContainer(modifiableModelsProvider.getModuleModifiableModel(module2));
        return new AddSupportForSingleFrameworkDialog(module2, provider2.getFrameworkType(), provider2, container, modifiableModelsProvider);
    }

    protected void doOKAction() {
        if (this.addSupport()) {
            super.doOKAction();
        }
    }

    private boolean addSupport() {
        final LibraryCompositionSettings librarySettings = this.myComponent.getLibraryCompositionSettings();
        if (librarySettings != null) {
            int answer;
            final ModifiableRootModel modifiableModel = this.myModifiableModelsProvider.getModuleModifiableModel(this.myModule);
            if (!this.askAndRemoveDuplicatedLibraryEntry(modifiableModel, librarySettings.getLibraryDescription())) {
                if (this.myConfigurable.isOnlyLibraryAdded()) {
                    this.myModifiableModelsProvider.disposeModuleModifiableModel(modifiableModel);
                    return false;
                }
                return false;
            }
            new WriteAction(){

                protected void run(@NotNull Result result) {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AddSupportForSingleFrameworkDialog.this.myModifiableModelsProvider.commitModuleModifiableModel(modifiableModel);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog$1", "run"));
                }
            }.execute();
            boolean downloaded = librarySettings.downloadFiles(this.getRootPane());
            if (!downloaded && (answer = Messages.showYesNoDialog((Component)this.getRootPane(), (String)ProjectBundle.message((String)"warning.message.some.required.libraries.wasn.t.downloaded", (Object[])new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon())) != 0) {
                return false;
            }
        }
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                ModifiableRootModel rootModel = AddSupportForSingleFrameworkDialog.this.myModifiableModelsProvider.getModuleModifiableModel(AddSupportForSingleFrameworkDialog.this.myModule);
                if (librarySettings != null) {
                    librarySettings.addLibraries(rootModel, new ArrayList<Library>(), AddSupportForSingleFrameworkDialog.this.myModel.getLibrariesContainer());
                }
                AddSupportForSingleFrameworkDialog.this.myConfigurable.addSupport(AddSupportForSingleFrameworkDialog.this.myModule, rootModel, AddSupportForSingleFrameworkDialog.this.myModifiableModelsProvider);
                AddSupportForSingleFrameworkDialog.this.myModifiableModelsProvider.commitModuleModifiableModel(rootModel);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog$2", "run"));
            }
        }.execute();
        return true;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.framework.addSupport.AddSupportForSingleFrameworkDialog";
    }

    protected String getHelpId() {
        return "reference.frameworks.support.dialog";
    }

    protected JComponent createCenterPanel() {
        return this.myComponent.getMainPanel();
    }

    private boolean askAndRemoveDuplicatedLibraryEntry(@NotNull ModifiableRootModel rootModel, @NotNull CustomLibraryDescription description) {
        if (rootModel == null) {
            AddSupportForSingleFrameworkDialog.$$$reportNull$$$0(5);
        }
        if (description == null) {
            AddSupportForSingleFrameworkDialog.$$$reportNull$$$0(6);
        }
        ArrayList<OrderEntry> existingEntries = new ArrayList<OrderEntry>();
        LibrariesContainer container = this.myModel.getLibrariesContainer();
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null || !LibraryPresentationManager.getInstance().isLibraryOfKind(library, container, description.getSuitableLibraryKinds())) continue;
            existingEntries.add(entry);
        }
        if (!existingEntries.isEmpty()) {
            String message;
            if (existingEntries.size() > 1) {
                message = "There are already " + existingEntries.size() + " " + this.myFrameworkType.getPresentableName() + " libraries.\n Do you want to replace them?";
            } else {
                String name2 = ((OrderEntry)existingEntries.get(0)).getPresentableName();
                message = "There is already a " + this.myFrameworkType.getPresentableName() + " library '" + name2 + "'.\n Do you want to replace it?";
            }
            int result = Messages.showYesNoCancelDialog((Project)rootModel.getProject(), (String)message, (String)"Library Already Exists", (String)"&Replace", (String)"&Add", (String)"&Cancel", null);
            if (result == 0) {
                for (OrderEntry entry : existingEntries) {
                    rootModel.removeOrderEntry(entry);
                }
            } else if (result != 1) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesContainer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDialog";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "askAndRemoveDuplicatedLibraryEntry";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

