/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourcePathsStep
extends AbstractStepWithProgress<List<JavaModuleSourceRoot>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.newProjectWizard.SourcePathsStep");
    private String myCurrentMode;
    @NonNls
    private static final String CREATE_SOURCE_PANEL = "create_source";
    @NonNls
    private static final String CHOOSE_SOURCE_PANEL = "choose_source";
    private final SourcePathsBuilder myBuilder;
    private final Icon myIcon;
    private final String myHelpId;
    private ElementsChooser<JavaModuleSourceRoot> mySourcePathsChooser;
    private String myCurrentContentEntryPath = null;
    private JRadioButton myRbCreateSource;
    private JRadioButton myRbNoSource;
    private JTextField myTfSourceDirectoryName;
    private JTextField myTfFullPath;
    private JPanel myResultPanel;

    public SourcePathsStep(SourcePathsBuilder builder, Icon icon, @NonNls String helpId) {
        super(IdeBundle.message((String)"prompt.stop.searching.for.sources", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.myBuilder = builder;
        this.myIcon = icon;
        this.myHelpId = helpId;
    }

    @Override
    protected JComponent createResultsPanel() {
        this.myResultPanel = new JPanel(new CardLayout());
        this.myResultPanel.add((Component)this.createComponentForEmptyRootCase(), CREATE_SOURCE_PANEL);
        this.myResultPanel.add((Component)this.createComponentForChooseSources(), CHOOSE_SOURCE_PANEL);
        return this.myResultPanel;
    }

    private JComponent createComponentForEmptyRootCase() {
        JPanel panel = new JPanel(new GridBagLayout());
        String text = IdeBundle.message((String)"prompt.please.specify.java.sources.directory", (Object[])new Object[0]);
        JLabel label = new JLabel(text);
        label.setUI((LabelUI)new MultiLineLabelUI());
        panel.add((Component)label, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.myRbCreateSource = new JRadioButton(IdeBundle.message((String)"radio.create.source.directory", (Object[])new Object[0]), true);
        panel.add((Component)this.myRbCreateSource, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.myTfSourceDirectoryName = new JTextField(this.suggestSourceDirectoryName());
        final JLabel srcPathLabel = new JLabel(IdeBundle.message((String)"prompt.enter.relative.path.to.module.content.root", (Object[])new Object[]{File.separator}));
        panel.add((Component)srcPathLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)30, (int)0, (int)0), 0, 0));
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        chooserDescriptor.withTreeRootVisible(true);
        final FieldPanel fieldPanel = SourcePathsStep.createFieldPanel((JTextField)this.myTfSourceDirectoryName, null, (BrowseFilesListener)new BrowsePathListener(this.myTfSourceDirectoryName, chooserDescriptor));
        panel.add((Component)fieldPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)30, (int)0, (int)10), 0, 0));
        this.myRbNoSource = new JRadioButton(IdeBundle.message((String)"radio.do.not.create.source.directory", (Object[])new Object[0]), true);
        panel.add((Component)this.myRbNoSource, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        final JLabel fullPathLabel = new JLabel(IdeBundle.message((String)"label.source.directory", (Object[])new Object[0]));
        panel.add((Component)fullPathLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 16, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.myTfFullPath = new JTextField();
        this.myTfFullPath.setEditable(false);
        this.myTfFullPath.setOpaque(false);
        Insets borderInsets = this.myTfFullPath.getBorder().getBorderInsets(this.myTfFullPath);
        this.myTfFullPath.setBorder(BorderFactory.createEmptyBorder(borderInsets.top, borderInsets.left, borderInsets.bottom, borderInsets.right));
        panel.add((Component)this.myTfFullPath, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 16, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbCreateSource);
        group.add(this.myRbNoSource);
        this.myTfSourceDirectoryName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                SourcePathsStep.this.updateFullPathField();
            }
        });
        this.myRbCreateSource.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                srcPathLabel.setEnabled(enabled);
                fieldPanel.setEnabled(enabled);
                fullPathLabel.setVisible(enabled);
                SourcePathsStep.this.myTfFullPath.setVisible(enabled);
                if (enabled) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)SourcePathsStep.this.myTfSourceDirectoryName, true));
                }
            }
        });
        return panel;
    }

    @NonNls
    protected String suggestSourceDirectoryName() {
        return "src";
    }

    private void updateFullPathField() {
        String sourceDirectoryPath = this.getSourceDirectoryPath();
        if (sourceDirectoryPath != null) {
            this.myTfFullPath.setText(sourceDirectoryPath.replace('/', File.separatorChar));
        } else {
            this.myTfFullPath.setText("");
        }
    }

    private JComponent createComponentForChooseSources() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.mySourcePathsChooser = new ElementsChooser<JavaModuleSourceRoot>(true){

            public String getItemText(@NotNull JavaModuleSourceRoot sourceRoot) {
                if (sourceRoot == null) {
                    3.$$$reportNull$$$0(0);
                }
                String packagePrefix = sourceRoot.getPackagePrefix();
                return sourceRoot.getDirectory().getAbsolutePath() + (packagePrefix.isEmpty() ? "" : " (" + packagePrefix + ")") + " [" + sourceRoot.getRootTypeName() + "]";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/intellij/ide/util/newProjectWizard/SourcePathsStep$3", "getItemText"));
            }
        };
        String text = IdeBundle.message((String)"label.java.source.files.have.been.found", (Object[])new Object[0]);
        JLabel label = new JLabel(text);
        label.setUI((LabelUI)new MultiLineLabelUI());
        panel.add((Component)label, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        panel.add((Component)this.mySourcePathsChooser, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JButton markAllButton = new JButton(IdeBundle.message((String)"button.mark.all", (Object[])new Object[0]));
        panel.add((Component)markAllButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)10, (int)8, (int)2), 0, 0));
        JButton unmarkAllButton = new JButton(IdeBundle.message((String)"button.unmark.all", (Object[])new Object[0]));
        panel.add((Component)unmarkAllButton, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)0, (int)8, (int)10), 0, 0));
        markAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcePathsStep.this.mySourcePathsChooser.setAllElementsMarked(true);
            }
        });
        unmarkAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcePathsStep.this.mySourcePathsChooser.setAllElementsMarked(false);
            }
        });
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRbCreateSource.isSelected() ? this.myTfSourceDirectoryName : this.mySourcePathsChooser.getComponent();
    }

    public void updateDataModel() {
        String sourceDirectoryPath;
        List<Object> paths = null;
        if (CHOOSE_SOURCE_PANEL.equals(this.myCurrentMode)) {
            List selectedElements = this.mySourcePathsChooser.getMarkedElements();
            if (selectedElements.size() > 0) {
                paths = new ArrayList(selectedElements.size());
                for (JavaModuleSourceRoot root : selectedElements) {
                    paths.add(Pair.create((Object)FileUtil.toSystemIndependentName((String)root.getDirectory().getAbsolutePath()), (Object)root.getPackagePrefix()));
                }
            }
        } else if (this.myRbCreateSource.isSelected() && (sourceDirectoryPath = this.getSourceDirectoryPath()) != null) {
            paths = Collections.singletonList(Pair.create((Object)sourceDirectoryPath, (Object)""));
        }
        this.myBuilder.setContentEntryPath(this.getContentRootPath());
        if (paths != null) {
            this.myBuilder.setSourcePaths(paths);
        } else {
            this.myBuilder.setSourcePaths(new ArrayList());
        }
    }

    @Override
    public boolean validate() throws ConfigurationException {
        if (!super.validate()) {
            return false;
        }
        if (CREATE_SOURCE_PANEL.equals(this.myCurrentMode) && this.myRbCreateSource.isSelected()) {
            String sourceDirectoryPath = this.getSourceDirectoryPath();
            String relativePath = this.myTfSourceDirectoryName.getText().trim();
            if (relativePath.length() == 0) {
                String text = IdeBundle.message((String)"prompt.relative.path.to.sources.empty", (Object[])new Object[]{FileUtil.toSystemDependentName((String)sourceDirectoryPath)});
                int answer = Messages.showYesNoCancelDialog((Component)this.myTfSourceDirectoryName, (String)text, (String)IdeBundle.message((String)"title.mark.source.directory", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.mark", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.do.not.mark", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                if (answer == 2) {
                    return false;
                }
                if (answer == 1) {
                    this.myRbNoSource.doClick();
                }
            }
            if (sourceDirectoryPath != null) {
                File srcDir;
                File rootDir = new File(this.getContentRootPath());
                if (!FileUtil.isAncestor((File)rootDir, (File)(srcDir = new File(sourceDirectoryPath)), (boolean)false)) {
                    Messages.showErrorDialog((Component)this.myTfSourceDirectoryName, (String)IdeBundle.message((String)"error.source.directory.should.be.under.module.content.root.directory", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
                    return false;
                }
                try {
                    VfsUtil.createDirectories((String)srcDir.getPath());
                }
                catch (IOException e) {
                    throw new ConfigurationException(e.getMessage());
                }
            }
        }
        return true;
    }

    @Nullable
    private String getSourceDirectoryPath() {
        String contentEntryPath = this.getContentRootPath();
        if (contentEntryPath != null) {
            String dirName = this.myTfSourceDirectoryName.getText().trim().replace(File.separatorChar, '/');
            return dirName.length() > 0 ? contentEntryPath + "/" + dirName : contentEntryPath;
        }
        return null;
    }

    @Override
    protected boolean shouldRunProgress() {
        return this.isContentEntryChanged();
    }

    @Override
    protected void onFinished(List<JavaModuleSourceRoot> foundPaths, boolean canceled) {
        if (foundPaths.size() > 0) {
            this.myCurrentMode = CHOOSE_SOURCE_PANEL;
            this.mySourcePathsChooser.setElements(foundPaths, true);
        } else {
            this.myCurrentMode = CREATE_SOURCE_PANEL;
            this.updateFullPathField();
        }
        this.updateStepUI(canceled ? null : this.getContentRootPath());
        if (CHOOSE_SOURCE_PANEL.equals(this.myCurrentMode)) {
            this.mySourcePathsChooser.selectElements(foundPaths.subList(0, 1));
        } else if (CREATE_SOURCE_PANEL.equals(this.myCurrentMode)) {
            this.myTfSourceDirectoryName.selectAll();
        }
    }

    private void updateStepUI(String contentEntryPath) {
        this.myCurrentContentEntryPath = contentEntryPath;
        ((CardLayout)this.myResultPanel.getLayout()).show(this.myResultPanel, this.myCurrentMode);
        this.myResultPanel.revalidate();
    }

    protected boolean isContentEntryChanged() {
        String contentEntryPath = this.getContentRootPath();
        return this.myCurrentContentEntryPath == null ? contentEntryPath != null : !this.myCurrentContentEntryPath.equals(contentEntryPath);
    }

    @Override
    protected List<JavaModuleSourceRoot> calculate() {
        return new ArrayList<JavaModuleSourceRoot>(SourcePathsStep.calculateSourceRoots(this.getContentRootPath()));
    }

    @NotNull
    public static Collection<JavaModuleSourceRoot> calculateSourceRoots(String contentRootPath) {
        if (contentRootPath == null) {
            List<JavaModuleSourceRoot> list = Collections.emptyList();
            if (list == null) {
                SourcePathsStep.$$$reportNull$$$0(0);
            }
            return list;
        }
        Collection<JavaModuleSourceRoot> collection = JavaSourceRootDetectionUtil.suggestRoots(new File(contentRootPath));
        if (collection == null) {
            SourcePathsStep.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    private String getContentRootPath() {
        return this.myBuilder.getContentEntryPath();
    }

    protected void setSourceDirectoryName(String name2) {
        name2 = name2 == null ? "" : name2.trim();
        this.myTfSourceDirectoryName.setText(name2);
    }

    @Override
    protected String getProgressText() {
        String root = this.getContentRootPath();
        return IdeBundle.message((String)"progress.searching.for.sources", (Object[])new Object[]{root != null ? root.replace('/', File.separatorChar) : ""});
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    public String getName() {
        return "Path to Sources";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/SourcePathsStep", "calculateSourceRoots"));
    }

    private class BrowsePathListener
    extends BrowseFilesListener {
        private final FileChooserDescriptor myChooserDescriptor;
        private final JTextField myField;

        public BrowsePathListener(JTextField textField, FileChooserDescriptor chooserDescriptor) {
            super(textField, IdeBundle.message((String)"prompt.select.source.directory", (Object[])new Object[0]), "", chooserDescriptor);
            this.myChooserDescriptor = chooserDescriptor;
            this.myField = textField;
        }

        @Nullable
        private VirtualFile getContentEntryDir() {
            String contentEntryPath = SourcePathsStep.this.getContentRootPath();
            if (contentEntryPath != null) {
                return (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(contentEntryPath));
            }
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            VirtualFile contentEntryDir = this.getContentEntryDir();
            if (contentEntryDir != null) {
                this.myChooserDescriptor.setRoots(new VirtualFile[]{contentEntryDir});
                String textBefore = this.myField.getText().trim();
                super.actionPerformed(e);
                if (!textBefore.equals(this.myField.getText().trim())) {
                    String fullPath = this.myField.getText().trim().replace(File.separatorChar, '/');
                    VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(fullPath);
                    LOG.assertTrue(fileByPath != null);
                    this.myField.setText(VfsUtilCore.getRelativePath((VirtualFile)fileByPath, (VirtualFile)contentEntryDir, (char)File.separatorChar));
                }
            }
        }
    }
}

