/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nullable;

public class CLionConfigImportSettings
extends ConfigImportSettings {
    public void importFinished(String newConfigPath) {
        super.importFinished(newConfigPath);
        CLionConfigImportSettings.convertToolchainSetting(newConfigPath);
    }

    private static void convertToolchainSetting(String newConfigPath) {
        File settings = new File(newConfigPath, "options/other.xml");
        if (!settings.exists()) {
            return;
        }
        try {
            String text = FileUtil.loadFile((File)settings);
            String migrated = CLionConfigImportSettings.doMigrateToolchainSettings(SystemInfo.isMac, text);
            if (migrated != null) {
                FileUtil.writeToFile((File)settings, (String)migrated);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public static String doMigrateToolchainSettings(boolean isMac, String text) {
        try {
            Element loaded = JDOMUtil.load((CharSequence)text);
            boolean migrated = false;
            for (Element eachComponent : loaded.getChildren("component")) {
                if (!"CPPToolchains".equals(eachComponent.getAttributeValue("name"))) continue;
                migrated = CLionConfigImportSettings.migrateToolchainsElement(isMac, eachComponent);
                break;
            }
            return migrated ? JDOMUtil.writeElement((Element)loaded) : null;
        }
        catch (IOException | JDOMException ignore) {
            return null;
        }
    }

    public static boolean migrateToolchainsElement(boolean isMac, Element eachComponent) {
        ToolchainsSettingsBean bean;
        if (StringUtil.parseInt((String)eachComponent.getAttributeValue("version"), (int)0) >= 2) {
            return false;
        }
        try {
            bean = (ToolchainsSettingsBean)XmlSerializer.deserialize((Element)eachComponent, ToolchainsSettingsBean.class);
        }
        catch (XmlSerializationException ignore) {
            return false;
        }
        eachComponent.removeContent();
        eachComponent.setAttribute("version", "2");
        Element toolchainsElement = new Element("toolchains");
        toolchainsElement.setAttribute("detectedVersion", Integer.toString(bean.detectedVersion));
        eachComponent.addContent(toolchainsElement);
        Element toolchainElement = new Element("toolchain");
        toolchainsElement.addContent(toolchainElement);
        toolchainElement.setAttribute("name", "Default");
        if (bean.winEnvironment != null) {
            toolchainElement.setAttribute("toolSetKind", bean.winEnvironment);
            switch (bean.winEnvironment) {
                case "CYGWIN": {
                    if (bean.cygwinHomePath == null) break;
                    toolchainElement.setAttribute("toolSetPath", bean.cygwinHomePath);
                    break;
                }
                case "MINGW": {
                    if (bean.minGWHomePath == null) break;
                    toolchainElement.setAttribute("toolSetPath", bean.minGWHomePath);
                    break;
                }
                case "MSVC": {
                    if (bean.MSVCHomePath == null) break;
                    toolchainElement.setAttribute("toolSetPath", bean.MSVCHomePath);
                }
            }
        }
        toolchainElement.setAttribute("useCustomCMake", Boolean.toString(!bean.useBundledCMake));
        if (bean.specifiedCMakeExecutablePath != null) {
            toolchainElement.setAttribute("customCMakePath", bean.specifiedCMakeExecutablePath);
        }
        if (bean.useBundledLLDB == null && bean.useBundledGDB == null) {
            toolchainElement.setAttribute("debuggerKind", isMac ? "BUNDLED_LLDB" : "BUNDLED_GDB");
        } else if ("true".equalsIgnoreCase(bean.useBundledGDB)) {
            toolchainElement.setAttribute("debuggerKind", "BUNDLED_GDB");
        } else if ("true".equalsIgnoreCase(bean.useBundledLLDB)) {
            toolchainElement.setAttribute("debuggerKind", "BUNDLED_LLDB");
        } else {
            toolchainElement.setAttribute("debuggerKind", "CUSTOM_GDB");
        }
        if (bean.specifiedGDBExecutablePath != null) {
            toolchainElement.setAttribute("customGDBPath", bean.specifiedGDBExecutablePath);
        }
        Element debuggersElement = new Element("debuggers");
        eachComponent.addContent(debuggersElement);
        for (String eachDebugger : bean.debuggers) {
            Element eachElement = new Element("debugger");
            debuggersElement.addContent(eachElement);
            eachElement.setAttribute("path", eachDebugger);
        }
        return true;
    }

    private static class ToolchainsSettingsBean {
        public int detectedVersion;
        @Nullable
        public String winEnvironment;
        @Nullable
        public String MSVCHomePath;
        @Nullable
        public String minGWHomePath;
        @Nullable
        public String cygwinHomePath;
        public boolean useBundledCMake = true;
        @Nullable
        public String specifiedCMakeExecutablePath;
        public String useBundledLLDB;
        public String useBundledGDB;
        @Nullable
        public String specifiedGDBExecutablePath;
        public List<String> debuggers = new ArrayList<String>();

        private ToolchainsSettingsBean() {
        }
    }
}

