/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemTaskConfigurationType
implements ConfigurationType {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final ConfigurationFactory[] myFactories;
    @NotNull
    private final NotNullLazyValue<Icon> myIcon;

    protected AbstractExternalSystemTaskConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(0);
        }
        this.myFactories = new ConfigurationFactory[1];
        this.myIcon = new NotNullLazyValue<Icon>(){

            @NotNull
            protected Icon compute() {
                ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId);
                Icon result = null;
                if (manager instanceof ExternalSystemUiAware) {
                    result = ((ExternalSystemUiAware)manager).getProjectIcon();
                }
                Icon icon = result == null ? DefaultExternalSystemUiAware.INSTANCE.getTaskIcon() : result;
                if (icon == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$1", "compute"));
            }
        };
        this.myExternalSystemId = externalSystemId;
        this.myFactories[0] = new ConfigurationFactory(this){

            @NotNull
            public RunConfiguration createTemplateConfiguration(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExternalSystemRunConfiguration externalSystemRunConfiguration = AbstractExternalSystemTaskConfigurationType.this.doCreateConfiguration(AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId, project2, this, "");
                if (externalSystemRunConfiguration == null) {
                    2.$$$reportNull$$$0(1);
                }
                return externalSystemRunConfiguration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTemplateConfiguration";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTemplateConfiguration";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(1);
        }
        return projectSystemId;
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        ConfigurationFactory configurationFactory = this.myFactories[0];
        if (configurationFactory == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(2);
        }
        return configurationFactory;
    }

    @NotNull
    protected ExternalSystemRunConfiguration doCreateConfiguration(@NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull ConfigurationFactory factory2, @NotNull String name2) {
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(4);
        }
        if (factory2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(5);
        }
        if (name2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(6);
        }
        ExternalSystemRunConfiguration externalSystemRunConfiguration = new ExternalSystemRunConfiguration(externalSystemId, project2, factory2, name2);
        if (externalSystemRunConfiguration == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(7);
        }
        return externalSystemRunConfiguration;
    }

    public String getDisplayName() {
        return this.myExternalSystemId.getReadableName();
    }

    public String getConfigurationTypeDescription() {
        return ExternalSystemBundle.message((String)"run.configuration.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @NotNull
    public String getId() {
        String string = this.myExternalSystemId.getReadableName() + "RunConfiguration";
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(8);
        }
        return string;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return this.myFactories;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ExternalSystemTaskExecutionSettings settings) {
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(10);
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, settings.getExternalSystemId(), settings.getExternalProjectPath(), settings.getTaskNames(), settings.getExecutionName());
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ExternalTaskPojo task, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(12);
        }
        if (task == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(13);
        }
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(14);
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemId, task.getLinkedExternalProjectPath(), Collections.singletonList(task.getName()));
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames) {
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(16);
        }
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(17);
        }
        if (taskNames == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(18);
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemId, externalProjectPath, taskNames, null);
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable String executionName) {
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(20);
        }
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(21);
        }
        if (taskNames == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(22);
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemId, externalProjectPath, taskNames, executionName, " [", "]");
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable String executionName, @NotNull String tasksPrefix, @NotNull String tasksPostfix) {
        String projectName;
        ExternalProjectInfo projectInfo;
        if (project2 == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(24);
        }
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(25);
        }
        if (taskNames == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(26);
        }
        if (tasksPrefix == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(27);
        }
        if (tasksPostfix == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(28);
        }
        String rootProjectPath = null;
        if (externalProjectPath != null && (projectInfo = ExternalSystemUtil.getExternalProjectInfo(project2, externalSystemId, externalProjectPath)) != null) {
            rootProjectPath = projectInfo.getExternalProjectPath();
        }
        StringBuilder buffer = new StringBuilder();
        if (rootProjectPath == null) {
            projectName = null;
        } else {
            ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
            projectName = uiAware.getProjectRepresentationName(project2, externalProjectPath, rootProjectPath);
        }
        if (!StringUtil.isEmptyOrSpaces(projectName)) {
            buffer.append(projectName);
        } else {
            buffer.append(externalProjectPath);
        }
        buffer.append(tasksPrefix);
        if (!StringUtil.isEmpty((String)executionName)) {
            buffer.append(executionName);
        } else if (!taskNames.isEmpty()) {
            for (String taskName : taskNames) {
                buffer.append(taskName).append(' ');
            }
            buffer.setLength(buffer.length() - 1);
        }
        buffer.append(tasksPostfix);
        String string = buffer.toString();
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 16: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksPrefix";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksPostfix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "generateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 29: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConfiguration";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "generateName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

