/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkUtil {
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Nullable
    public static Sdk getJdk(@Nullable Project project2, @Nullable String jdkName) throws ExternalSystemJdkException {
        if (jdkName == null) {
            return null;
        }
        if (USE_INTERNAL_JAVA.equals(jdkName)) {
            return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        }
        if (USE_PROJECT_JDK.equals(jdkName)) {
            if (project2 != null) {
                Module[] modules;
                Sdk res = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
                if (res != null) {
                    return res;
                }
                for (Module module2 : modules = ModuleManager.getInstance((Project)project2).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                    if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                    return sdk;
                }
            }
            if (project2 == null || project2.isDefault()) {
                Sdk recent = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
                return recent != null ? recent : JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            }
            throw new ProjectJdkNotFoundException();
        }
        if (USE_JAVA_HOME.equals(jdkName)) {
            String javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME");
            if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
                throw new UndefinedJavaHomeException();
            }
            if (!ExternalSystemJdkUtil.isValidJdk(javaHome)) {
                throw new InvalidJavaHomeException(javaHome);
            }
            return JavaSdk.getInstance().createJdk("", javaHome);
        }
        Sdk projectJdk = ProjectJdkTable.getInstance().findJdk(jdkName);
        if (projectJdk != null) {
            String homePath = projectJdk.getHomePath();
            if (!ExternalSystemJdkUtil.isValidJdk(homePath)) {
                throw new InvalidSdkException(homePath);
            }
            return projectJdk;
        }
        return null;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project2) throws ExternalSystemJdkException {
        String javaHome;
        Stream<Sdk> projectSdks;
        Sdk projectSdk;
        JavaSdk javaSdkType = JavaSdk.getInstance();
        if (project2 != null && (projectSdk = (Sdk)(projectSdks = Stream.concat(Stream.of(ProjectRootManager.getInstance((Project)project2).getProjectSdk()), Stream.of(ModuleManager.getInstance((Project)project2).getModules()).map(module2 -> ModuleRootManager.getInstance((Module)module2).getSdk()))).filter(sdk -> sdk != null && sdk.getSdkType() == javaSdkType && ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).findFirst().orElse(null)) != null) {
            Pair pair2 = Pair.pair((Object)USE_PROJECT_JDK, (Object)projectSdk);
            if (pair2 == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(0);
            }
            return pair2;
        }
        List allJdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdkType);
        Sdk mostRecentSdk = allJdks.stream().filter(sdk -> ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).max(javaSdkType.versionComparator()).orElse(null);
        if (mostRecentSdk != null) {
            Pair pair3 = Pair.pair((Object)mostRecentSdk.getName(), (Object)mostRecentSdk);
            if (pair3 == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(1);
            }
            return pair3;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME"))) {
            Pair pair4 = Pair.pair((Object)USE_JAVA_HOME, (Object)javaSdkType.createJdk("", javaHome));
            if (pair4 == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(2);
            }
            return pair4;
        }
        Pair pair5 = Pair.pair((Object)USE_INTERNAL_JAVA, (Object)JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk());
        if (pair5 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(3);
        }
        return pair5;
    }

    public static boolean checkForJdk(@NotNull Project project2, @Nullable String jdkName) {
        if (project2 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(4);
        }
        try {
            Sdk sdk = ExternalSystemJdkUtil.getJdk(project2, jdkName);
            return sdk != null && sdk.getHomePath() != null && JdkUtil.checkForJdk((String)sdk.getHomePath());
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            return false;
        }
    }

    public static boolean isValidJdk(@Nullable String homePath) {
        return !StringUtil.isEmptyOrSpaces((String)homePath) && (JdkUtil.checkForJdk((String)homePath) || JdkUtil.checkForJre((String)homePath));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableJdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

