/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.BeforeRunTaskImporter;
import com.intellij.openapi.externalSystem.service.project.settings.BeforeRunTaskImporterExtensionManager;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigImporterExtensionManager;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "()V", "apply", "", "module", "Lcom/intellij/openapi/module/Module;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "project", "Lcom/intellij/openapi/project/Project;", "isTrue", "", "", "Companion", "intellij.platform.externalSystem.impl"})
public final class RunConfigurationHandler
implements ConfigurationHandler {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    private final boolean isTrue(@Nullable Object $receiver) {
        return $receiver != null && $receiver instanceof Boolean && (Boolean)$receiver != false;
    }

    public void apply(@NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Object runCfgMap = configuration.find("runConfigurations");
        RunManagerEx runManagerEx = RunManagerEx.getInstanceEx((Project)project2);
        if (!(runCfgMap instanceof List)) {
            return;
        }
        Iterable iterable = (Iterable)runCfgMap;
        Object object = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof Map)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        object = $receiver$iv;
        destination$iv$iv = new Comparator<T>(this){
            final /* synthetic */ RunConfigurationHandler this$0;
            {
                this.this$0 = runConfigurationHandler;
            }

            public final int compare(T a, T b) {
                Map it;
                Map map2 = it = (Map)b;
                String string = "defaults";
                RunConfigurationHandler runConfigurationHandler = this.this$0;
                V v = map2.get(string);
                it = (Map)a;
                Comparable comparable = Boolean.valueOf(RunConfigurationHandler.access$isTrue(runConfigurationHandler, v));
                map2 = it;
                string = "defaults";
                runConfigurationHandler = this.this$0;
                v = map2.get(string);
                Boolean bl = RunConfigurationHandler.access$isTrue(runConfigurationHandler, v);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)bl);
            }
        };
        $receiver$iv = CollectionsKt.sortedWith((Iterable)object, (Comparator)destination$iv$iv);
        for (Object element$iv : $receiver$iv) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings;
            String typeName;
            String string;
            Object $i$f$filterIsInstanceTo;
            Object element$iv$iv;
            Map cfg = (Map)element$iv;
            element$iv$iv = cfg;
            Object v = element$iv$iv.get($i$f$filterIsInstanceTo = "name");
            if (!(v instanceof String)) {
                v = null;
            }
            if ((string = (String)v) == null) {
                string = "";
            }
            String name2 = string;
            $i$f$filterIsInstanceTo = cfg;
            String string2 = "type";
            Object v2 = $i$f$filterIsInstanceTo.get(string2);
            if (!(v2 instanceof String)) {
                v2 = null;
            }
            if ((typeName = (String)v2) == null) {
                Companion.getLOG().warn("Missing type for run configuration: '" + name2 + "', skipping");
                continue;
            }
            RunConfigurationImporter importer = RunConfigImporterExtensionManager.Companion.handlerForType(typeName);
            if (importer == null) {
                Companion.getLOG().warn("No importers for run configuration '" + name2 + "' with type '" + typeName + "', skipping");
                continue;
            }
            RunConfigurationHandler runConfigurationHandler = this;
            Map map2 = cfg;
            String string3 = "defaults";
            Object v3 = map2.get(string3);
            boolean isDefaults = runConfigurationHandler.isTrue(v3);
            if (isDefaults) {
                ConfigurationFactory configurationFactory = importer.getConfigurationFactory();
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"importer.configurationFactory");
                runnerAndConfigurationSettings = runManagerEx.getConfigurationTemplate(configurationFactory);
            } else {
                ConfigurationFactory configurationFactory = importer.getConfigurationFactory();
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"importer.configurationFactory");
                runnerAndConfigurationSettings = runManagerEx.createConfiguration(name2, configurationFactory);
            }
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            try {
                Map map3 = cfg;
                if (map3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                }
                importer.process(project2, runnerAndConfigurationSettings2.getConfiguration(), map3, modelsProvider);
                if (!isDefaults) {
                    runManagerEx.addConfiguration(runnerAndConfigurationSettings2);
                }
                ObjectUtils.consumeIfCast(cfg.get("beforeRun"), List.class, (Consumer)new Consumer<T>(runnerAndConfigurationSettings2, this, runManagerEx, project2, modelsProvider){
                    final /* synthetic */ RunnerAndConfigurationSettings $runnerAndConfigurationSettings;
                    final /* synthetic */ RunConfigurationHandler this$0;
                    final /* synthetic */ RunManagerEx $runManagerEx$inlined;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ IdeModifiableModelsProvider $modelsProvider$inlined;
                    {
                        this.$runnerAndConfigurationSettings = runnerAndConfigurationSettings;
                        this.this$0 = runConfigurationHandler;
                        this.$runManagerEx$inlined = runManagerEx;
                        this.$project$inlined = project2;
                        this.$modelsProvider$inlined = ideModifiableModelsProvider;
                    }

                    public final void consume(List<?> it) {
                        List tasksList = this.$runManagerEx$inlined.getBeforeRunTasks(this.$runnerAndConfigurationSettings.getConfiguration());
                        List<?> list = it;
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"it");
                        Iterable $receiver$iv = CollectionsKt.filterIsInstance((Iterable)list, Map.class);
                        for (T element$iv : $receiver$iv) {
                            String typeName;
                            String string;
                            Map beforeRunConfig = (Map)element$iv;
                            Map map2 = beforeRunConfig;
                            V v = map2.get(string = "type");
                            if (!(v instanceof String)) {
                                v = null;
                            }
                            if ((String)v == null) {
                                continue;
                            }
                            BeforeRunTaskImporter beforeRunTaskImporter = BeforeRunTaskImporterExtensionManager.Companion.importerForType(typeName);
                            if (beforeRunTaskImporter == null) continue;
                            Map importer = map2 = beforeRunTaskImporter;
                            Map map3 = beforeRunConfig;
                            if (map3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, *>");
                            }
                            tasksList = importer.process(this.$project$inlined, this.$modelsProvider$inlined, this.$runnerAndConfigurationSettings.getConfiguration(), tasksList, TypeIntrinsics.asMutableMap((Object)map3));
                        }
                        this.$runManagerEx$inlined.setBeforeRunTasks(this.$runnerAndConfigurationSettings.getConfiguration(), tasksList);
                    }
                });
            }
            catch (Exception e) {
                Companion.getLOG().warn("Error occurred when importing run configuration " + name2 + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(RunConfigurationHandler.class);
    }

    public static final /* synthetic */ boolean access$isTrue(RunConfigurationHandler $this, @Nullable Object $receiver) {
        return $this.isTrue($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

