/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import icons.ExternalSystemIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Order(value=30)
public class RunConfigurationsNode
extends ExternalSystemNode<Void> {
    private final ModuleData myModuleData;

    public RunConfigurationsNode(@NotNull ExternalProjectsView externalProjectsView, ModuleNode parent) {
        if (externalProjectsView == null) {
            RunConfigurationsNode.$$$reportNull$$$0(0);
        }
        super(externalProjectsView, parent, null);
        this.myModuleData = (ModuleData)parent.getData();
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(ExternalSystemIcons.TaskGroup);
    }

    public String getName() {
        return this.message("external.system.view.nodes.run_configurations.name", new Object[0]);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.hasChildren();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        ArrayList runConfigurationNodes = ContainerUtil.newArrayList();
        AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(this.myModuleData.getOwner());
        if (configurationType == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RunConfigurationsNode.$$$reportNull$$$0(1);
            }
            return list;
        }
        THashSet settings = new THashSet((Collection)RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList((ConfigurationType)configurationType));
        String directory = PathUtil.getCanonicalPath((String)this.myModuleData.getLinkedExternalProjectPath());
        for (RunnerAndConfigurationSettings cfg : settings) {
            ExternalSystemRunConfiguration externalSystemRunConfiguration = (ExternalSystemRunConfiguration)cfg.getConfiguration();
            if (!directory.equals(PathUtil.getCanonicalPath((String)externalSystemRunConfiguration.getSettings().getExternalProjectPath()))) continue;
            runConfigurationNodes.add(new RunConfigurationNode(this.getExternalProjectsView(), this, cfg));
        }
        ArrayList arrayList = runConfigurationNodes;
        if (arrayList == null) {
            RunConfigurationsNode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void updateRunConfigurations() {
        this.cleanUpCache();
        this.getExternalProjectsView().updateUpTo(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/RunConfigurationsNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/RunConfigurationsNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

