/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.util.Disposer;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.Nullable;

public class IdeaModifiableModelsProvider
implements ModifiableModelsProvider {
    @Nullable
    public ModifiableRootModel getModuleModifiableModel(Module module2) {
        ModuleEditor moduleEditor;
        Project project2 = module2.getProject();
        ModulesConfigurator configurator = IdeaModifiableModelsProvider.getModulesConfigurator(project2);
        if (configurator != null && !configurator.isModuleModelCommitted() && (moduleEditor = configurator.getModuleEditor(module2)) != null) {
            return moduleEditor.getModifiableRootModelProxy();
        }
        return ModuleRootManager.getInstance((Module)module2).getModifiableModel();
    }

    @Nullable
    private static ModulesConfigurator getModulesConfigurator(Project project2) {
        StructureConfigurableContext context = IdeaModifiableModelsProvider.getProjectStructureContext(project2);
        return context != null ? context.getModulesConfigurator() : null;
    }

    public void commitModuleModifiableModel(ModifiableRootModel model2) {
        if (!(model2 instanceof Proxy)) {
            model2.commit();
        }
    }

    public void disposeModuleModifiableModel(ModifiableRootModel model2) {
        if (!(model2 instanceof Proxy)) {
            model2.dispose();
        }
    }

    public ModifiableFacetModel getFacetModifiableModel(Module module2) {
        ModulesConfigurator configurator = IdeaModifiableModelsProvider.getModulesConfigurator(module2.getProject());
        if (configurator != null) {
            return configurator.getFacetsConfigurator().getOrCreateModifiableModel(module2);
        }
        return FacetManager.getInstance((Module)module2).createModifiableModel();
    }

    public void commitFacetModifiableModel(Module module2, ModifiableFacetModel model2) {
        ModulesConfigurator configurator = IdeaModifiableModelsProvider.getModulesConfigurator(module2.getProject());
        if (configurator == null || !(configurator.getFacetsConfigurator().getFacetModel(module2) instanceof ModifiableFacetModel)) {
            model2.commit();
        }
    }

    public LibraryTable.ModifiableModel getLibraryTableModifiableModel() {
        Project[] projects;
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            LibraryTable.ModifiableModel modifiableModel;
            if (!project2.isInitialized()) continue;
            StructureConfigurableContext context = IdeaModifiableModelsProvider.getProjectStructureContext(project2);
            StructureLibraryTableModifiableModelProvider provider2 = context != null ? context.createModifiableModelProvider("application") : null;
            LibraryTable.ModifiableModel modifiableModel2 = modifiableModel = provider2 != null ? provider2.getModifiableModel() : null;
            if (modifiableModel == null) continue;
            return modifiableModel;
        }
        return LibraryTablesRegistrar.getInstance().getLibraryTable().getModifiableModel();
    }

    public LibraryTable.ModifiableModel getLibraryTableModifiableModel(Project project2) {
        StructureConfigurableContext context = IdeaModifiableModelsProvider.getProjectStructureContext(project2);
        if (context != null) {
            StructureLibraryTableModifiableModelProvider provider2 = context.createModifiableModelProvider("project");
            return provider2.getModifiableModel();
        }
        return LibraryTablesRegistrar.getInstance().getLibraryTable(project2).getModifiableModel();
    }

    public void disposeLibraryTableModifiableModel(LibraryTable.ModifiableModel model2) {
        if (!(model2 instanceof LibrariesModifiableModel)) {
            Disposer.dispose((Disposable)model2);
        }
    }

    @Nullable
    private static StructureConfigurableContext getProjectStructureContext(Project project2) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return null;
        }
        ProjectStructureConfigurable structureConfigurable = ProjectStructureConfigurable.getInstance(project2);
        return structureConfigurable.isUiInitialized() ? structureConfigurable.getContext() : null;
    }
}

