/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurableBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactStructureConfigurableState;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.InvalidArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsStructureConfigurable
extends BaseStructureConfigurable {
    private ArtifactsStructureConfigurableContextImpl myPackagingEditorContext;
    private final ArtifactEditorSettings myDefaultSettings;

    public ArtifactsStructureConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            ArtifactsStructureConfigurable.$$$reportNull$$$0(0);
        }
        super(project2, new ArtifactStructureConfigurableState());
        this.myDefaultSettings = new ArtifactEditorSettings();
    }

    protected String getComponentStateKey() {
        return "ArtifactsStructureConfigurable.UI";
    }

    public void init(StructureConfigurableContext context, ModuleStructureConfigurable moduleStructureConfigurable, ProjectLibrariesConfigurable projectLibrariesConfig, GlobalLibrariesConfigurable globalLibrariesConfig) {
        super.init(context);
        this.myPackagingEditorContext = new ArtifactsStructureConfigurableContextImpl(this.myContext, this.myProject, this.myDefaultSettings, new ArtifactAdapter(){

            public void artifactAdded(@NotNull Artifact artifact) {
                if (artifact == null) {
                    1.$$$reportNull$$$0(0);
                }
                MasterDetailsComponent.MyNode node = ArtifactsStructureConfigurable.this.addArtifactNode(artifact);
                ArtifactsStructureConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$1", "artifactAdded"));
            }
        });
        context.getModulesConfigurator().addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
                for (ProjectStructureElement projectStructureElement : ArtifactsStructureConfigurable.this.getProjectStructureElements()) {
                    ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement);
                }
            }
        });
        MasterDetailsComponent.ItemsChangeListener listener2 = new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                if (deletedItem instanceof Library || deletedItem instanceof Module) {
                    ArtifactsStructureConfigurable.this.onElementDeleted();
                }
            }
        };
        moduleStructureConfigurable.addItemsChangeListener(listener2);
        projectLibrariesConfig.addItemsChangeListener(listener2);
        globalLibrariesConfig.addItemsChangeListener(listener2);
        context.addLibraryEditorListener(new LibraryEditorListener(){

            @Override
            public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
                Artifact[] artifacts;
                if (library == null) {
                    4.$$$reportNull$$$0(0);
                }
                for (Artifact artifact : artifacts = ArtifactsStructureConfigurable.this.myPackagingEditorContext.getArtifactModel().getArtifacts()) {
                    ArtifactsStructureConfigurable.this.updateLibraryElements(artifact, library, oldName, newName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$4", "libraryRenamed"));
            }
        });
    }

    private void updateLibraryElements(Artifact artifact, final Library library, final String oldName, final String newName) {
        if (ArtifactUtil.processPackagingElements(this.myPackagingEditorContext.getRootElement(artifact), LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

            @Override
            public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(1);
                }
                return !ArtifactsStructureConfigurable.isResolvedToLibrary(element, library, oldName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$5";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myPackagingEditorContext, false, artifact.getArtifactType())) {
            return;
        }
        this.myPackagingEditorContext.editLayout(artifact, () -> {
            ModifiableArtifact modifiableArtifact = this.myPackagingEditorContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(artifact);
            ArtifactUtil.processPackagingElements((Artifact)modifiableArtifact, LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

                @Override
                public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    if (ArtifactsStructureConfigurable.isResolvedToLibrary(element, library, oldName)) {
                        element.setLibraryName(newName);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$6";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (PackagingElementResolvingContext)this.myPackagingEditorContext, false);
        });
        ArtifactEditorImpl artifactEditor = this.myPackagingEditorContext.getArtifactEditor(artifact);
        if (artifactEditor != null) {
            artifactEditor.rebuildTries();
        }
    }

    private static boolean isResolvedToLibrary(LibraryPackagingElement element, Library library, String name2) {
        if (!element.getLibraryName().equals(name2)) {
            return false;
        }
        LibraryTable table = library.getTable();
        if (table != null) {
            return table.getTableLevel().equals(element.getLevel());
        }
        return element.getLevel().equals("module");
    }

    private void onElementDeleted() {
        for (ArtifactEditorImpl artifactEditorImpl : this.myPackagingEditorContext.getArtifactEditors()) {
            artifactEditorImpl.getSourceItemsTree().rebuildTree();
            artifactEditorImpl.queueValidation();
        }
    }

    protected MasterDetailsState getState() {
        ((ArtifactStructureConfigurableState)this.myState).setDefaultArtifactSettings(this.myDefaultSettings.getState());
        return super.getState();
    }

    public void loadState(MasterDetailsState object) {
        super.loadState(object);
        this.myDefaultSettings.loadState(((ArtifactStructureConfigurableState)this.myState).getDefaultArtifactSettings());
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"display.name.artifacts", (Object[])new Object[0]);
    }

    @Override
    protected void loadTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        for (Artifact artifact : this.myPackagingEditorContext.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            this.addArtifactNode(artifact);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ArtifactProjectStructureElement> elements = new ArrayList<ArtifactProjectStructureElement>();
        for (Artifact artifact : this.myPackagingEditorContext.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            elements.add(this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
        }
        ArrayList<ArtifactProjectStructureElement> arrayList = elements;
        if (arrayList == null) {
            ArtifactsStructureConfigurable.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private MasterDetailsComponent.MyNode addArtifactNode(Artifact artifact) {
        ArtifactConfigurableBase configurable = artifact instanceof InvalidArtifact ? new InvalidArtifactConfigurable((InvalidArtifact)artifact, this.myPackagingEditorContext, this.TREE_UPDATER) : new ArtifactConfigurable(artifact, this.myPackagingEditorContext, this.TREE_UPDATER);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
        this.addNode(node, this.myRoot);
        return node;
    }

    @Override
    public void reset() {
        this.loadComponentState();
        this.myPackagingEditorContext.resetModifiableModel();
        super.reset();
    }

    public boolean isModified() {
        ModifiableArtifactModel modifiableModel = this.myPackagingEditorContext.getActualModifiableModel();
        if (modifiableModel != null && modifiableModel.isModified()) {
            return true;
        }
        return this.myPackagingEditorContext.getManifestFilesInfo().isManifestFilesModified() || super.isModified();
    }

    public ArtifactsStructureConfigurableContext getArtifactsStructureContext() {
        return this.myPackagingEditorContext;
    }

    public ModifiableArtifactModel getModifiableArtifactModel() {
        return this.myPackagingEditorContext.getOrCreateModifiableArtifactModel();
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.header.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                ArtifactType[] types = ArtifactType.getAllTypes();
                AnAction[] actions = new AnAction[types.length];
                for (int i = 0; i < types.length; ++i) {
                    actions[i] = ArtifactsStructureConfigurable.this.createAddArtifactAction(types[i]);
                }
                if (actions == null) {
                    7.$$$reportNull$$$0(0);
                }
                return actions;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$7", "getChildren"));
            }
        };
    }

    private AnAction createAddArtifactAction(final @NotNull ArtifactType type) {
        if (type == null) {
            ArtifactsStructureConfigurable.$$$reportNull$$$0(2);
        }
        List templates = type.getNewArtifactTemplates((PackagingElementResolvingContext)this.myPackagingEditorContext);
        ArtifactTemplate emptyTemplate = new ArtifactTemplate(){

            public String getPresentableName() {
                return "Empty";
            }

            public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
                String name2 = "unnamed";
                return new ArtifactTemplate.NewArtifactConfiguration(type.createRootElement("unnamed"), "unnamed", type);
            }
        };
        if (templates.isEmpty()) {
            return new AddArtifactAction(type, emptyTemplate, type.getPresentableName(), type.getIcon());
        }
        DefaultActionGroup group = new DefaultActionGroup(type.getPresentableName(), true);
        group.getTemplatePresentation().setIcon(type.getIcon());
        group.add((AnAction)new AddArtifactAction(type, emptyTemplate, emptyTemplate.getPresentableName(), null));
        group.addSeparator();
        for (ArtifactTemplate template : templates) {
            group.add((AnAction)new AddArtifactAction(type, template, template.getPresentableName(), null));
        }
        return group;
    }

    private void addArtifact(@NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate) {
        if (type == null) {
            ArtifactsStructureConfigurable.$$$reportNull$$$0(3);
        }
        if (artifactTemplate == null) {
            ArtifactsStructureConfigurable.$$$reportNull$$$0(4);
        }
        Artifact artifact = ArtifactUtil.addArtifact(this.myPackagingEditorContext.getOrCreateModifiableArtifactModel(), type, artifactTemplate);
        this.selectNodeInTree((DefaultMutableTreeNode)ArtifactsStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)artifact));
    }

    public void apply() throws ConfigurationException {
        this.myPackagingEditorContext.saveEditorSettings();
        this.checkForEmptyAndDuplicatedNames("Artifact", CommonBundle.getErrorTitle(), ArtifactConfigurableBase.class);
        super.apply();
        this.myPackagingEditorContext.getManifestFilesInfo().saveManifestFiles();
        final ModifiableArtifactModel modifiableModel = this.myPackagingEditorContext.getActualModifiableModel();
        if (modifiableModel != null) {
            new WriteAction(){

                protected void run(@NotNull Result result) {
                    if (result == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    modifiableModel.commit();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$9", "run"));
                }
            }.execute();
        }
        this.myPackagingEditorContext.resetModifiableModel();
        this.reloadTreeNodes();
        this.restoreLastSelection();
    }

    @Override
    public void disposeUIResources() {
        this.myPackagingEditorContext.saveEditorSettings();
        super.disposeUIResources();
        this.myPackagingEditorContext.disposeUIResources();
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        ArtifactEditorImpl editor;
        boolean selectionChanged;
        boolean bl = selectionChanged = !Comparing.equal((Object)this.myCurrentConfigurable, (Object)configurable);
        if (selectionChanged && this.myCurrentConfigurable instanceof ArtifactConfigurable && (editor = this.myPackagingEditorContext.getArtifactEditor(((ArtifactConfigurable)this.myCurrentConfigurable).getArtifact())) != null) {
            editor.getLayoutTreeComponent().saveElementProperties();
        }
        super.updateSelection(configurable);
        if (selectionChanged && configurable instanceof ArtifactConfigurable && (editor = this.myPackagingEditorContext.getArtifactEditor(((ArtifactConfigurable)configurable).getArtifact())) != null) {
            editor.getLayoutTreeComponent().resetElementProperties();
        }
    }

    public String getHelpTopic() {
        String topic = super.getHelpTopic();
        return topic != null ? topic : "reference.settingsdialog.project.structure.artifacts";
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new ArtifactRemoveHandler());
    }

    @NotNull
    public String getId() {
        if ("project.artifacts" == null) {
            ArtifactsStructureConfigurable.$$$reportNull$$$0(5);
        }
        return "project.artifacts";
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAddArtifactAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AddArtifactAction
    extends DumbAwareAction {
        private final ArtifactType myType;
        private final ArtifactTemplate myArtifactTemplate;

        public AddArtifactAction(@NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate, String actionText, Icon icon) {
            if (type == null) {
                AddArtifactAction.$$$reportNull$$$0(0);
            }
            if (artifactTemplate == null) {
                AddArtifactAction.$$$reportNull$$$0(1);
            }
            if (actionText == null) {
                AddArtifactAction.$$$reportNull$$$0(2);
            }
            super(actionText, null, icon);
            this.myType = type;
            this.myArtifactTemplate = artifactTemplate;
        }

        public void actionPerformed(AnActionEvent e) {
            ArtifactsStructureConfigurable.this.addArtifact(this.myType, this.myArtifactTemplate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifactTemplate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionText";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$AddArtifactAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ArtifactRemoveHandler
    extends RemoveConfigurableHandler<Artifact> {
        public ArtifactRemoveHandler() {
            super(ArtifactConfigurableBase.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Artifact> artifacts) {
            if (artifacts == null) {
                ArtifactRemoveHandler.$$$reportNull$$$0(0);
            }
            for (Artifact artifact : artifacts) {
                ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateModifiableArtifactModel().removeArtifact(artifact);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$ArtifactRemoveHandler", "remove"));
        }
    }
}

