/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ParameterizedRunnable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddCustomLibraryDialog
extends DialogWrapper {
    private final LibraryOptionsPanel myPanel;
    private final LibrariesContainer myLibrariesContainer;
    private final Module myModule;
    private final ModifiableRootModel myModifiableRootModel;
    @Nullable
    private final ParameterizedRunnable<ModifiableRootModel> myBeforeLibraryAdded;
    private final List<Library> myAddedLibraries = new ArrayList<Library>();

    private AddCustomLibraryDialog(CustomLibraryDescription description, LibrariesContainer librariesContainer, Module module2, ModifiableRootModel modifiableRootModel, @Nullable ParameterizedRunnable<ModifiableRootModel> beforeLibraryAdded) {
        super(module2.getProject(), true);
        this.myLibrariesContainer = librariesContainer;
        this.myModule = module2;
        this.myModifiableRootModel = modifiableRootModel;
        this.myBeforeLibraryAdded = beforeLibraryAdded;
        this.setTitle(IdeBundle.message((String)"setup.library.dialog.title", (Object[])new Object[0]));
        VirtualFile baseDir = this.myModule.getProject().getBaseDir();
        String baseDirPath = baseDir != null ? baseDir.getPath() : "";
        this.myPanel = new LibraryOptionsPanel(description, baseDirPath, FrameworkLibraryVersionFilter.ALL, this.myLibrariesContainer, false);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myPanel);
        this.init();
    }

    public static AddCustomLibraryDialog createDialog(@NotNull CustomLibraryDescription description, @NotNull Module module2, ParameterizedRunnable<ModifiableRootModel> beforeLibraryAdded) {
        if (description == null) {
            AddCustomLibraryDialog.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            AddCustomLibraryDialog.$$$reportNull$$$0(1);
        }
        return AddCustomLibraryDialog.createDialog(description, LibrariesContainerFactory.createContainer(module2), module2, null, beforeLibraryAdded);
    }

    public static AddCustomLibraryDialog createDialog(CustomLibraryDescription description, @NotNull LibrariesContainer librariesContainer, @NotNull Module module2, @Nullable ModifiableRootModel modifiableRootModel, @Nullable ParameterizedRunnable<ModifiableRootModel> beforeLibraryAdded) {
        if (librariesContainer == null) {
            AddCustomLibraryDialog.$$$reportNull$$$0(2);
        }
        if (module2 == null) {
            AddCustomLibraryDialog.$$$reportNull$$$0(3);
        }
        return new AddCustomLibraryDialog(description, librariesContainer, module2, modifiableRootModel, beforeLibraryAdded);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.getMainPanel();
    }

    protected void doOKAction() {
        final LibraryCompositionSettings settings = this.myPanel.apply();
        if (settings != null && settings.downloadFiles(this.myPanel.getMainPanel())) {
            if (this.myModifiableRootModel == null) {
                final ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
                new WriteAction(){

                    protected void run(@NotNull Result result) {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        AddCustomLibraryDialog.this.addLibraries(model2, settings);
                        model2.commit();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/libraries/AddCustomLibraryDialog$1", "run"));
                    }
                }.execute();
            } else {
                this.addLibraries(this.myModifiableRootModel, settings);
            }
        }
        super.doOKAction();
    }

    private void addLibraries(ModifiableRootModel model2, LibraryCompositionSettings settings) {
        if (this.myBeforeLibraryAdded != null) {
            this.myBeforeLibraryAdded.run((Object)model2);
        }
        settings.addLibraries(model2, this.myAddedLibraries, this.myLibrariesContainer);
    }

    public List<Library> getAddedLibraries() {
        return this.myAddedLibraries;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "description";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "librariesContainer";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/AddCustomLibraryDialog";
        objectArray[2] = "createDialog";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

