/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExcludedRootElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsTreeSpeedSearch;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeBuilder;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTreeRenderer;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTreeStructure;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.OrderRootTypeElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.UrlComparator;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryRootsComponent
implements Disposable,
LibraryEditorComponent {
    static final UrlComparator ourUrlComparator = new UrlComparator();
    private JPanel myPanel;
    private JPanel myTreePanel;
    private MultiLineLabel myPropertiesLabel;
    private JPanel myPropertiesPanel;
    private JPanel myBottomPanel;
    private LibraryPropertiesEditor myPropertiesEditor;
    private Tree myTree;
    private LibraryTableTreeBuilder myTreeBuilder;
    private final ModificationOfImportedModelWarningComponent myModificationOfImportedModelWarningComponent;
    private VirtualFile myLastChosen;
    private final Collection<Runnable> myListeners;
    @Nullable
    private final Project myProject;
    private final Computable<LibraryEditor> myLibraryEditorComputable;
    private LibraryRootsComponentDescriptor myDescriptor;
    private Module myContextModule;
    private AddExcludedRootActionButton myAddExcludedRootActionButton;

    public LibraryRootsComponent(@Nullable Project project2, @NotNull LibraryEditor libraryEditor) {
        if (libraryEditor == null) {
            LibraryRootsComponent.$$$reportNull$$$0(0);
        }
        this(project2, (Computable<LibraryEditor>)new Computable.PredefinedValueComputable((Object)libraryEditor));
    }

    public LibraryRootsComponent(@Nullable Project project2, @NotNull Computable<LibraryEditor> libraryEditorComputable) {
        if (libraryEditorComputable == null) {
            LibraryRootsComponent.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project2;
        this.myLibraryEditorComputable = libraryEditorComputable;
        LibraryEditor editor = this.getLibraryEditor();
        LibraryType type = editor.getType();
        if (type != null) {
            this.myDescriptor = type.createLibraryRootsComponentDescriptor();
            this.myPropertiesEditor = type.createPropertiesEditor((LibraryEditorComponent)this);
            if (this.myPropertiesEditor != null) {
                this.myPropertiesPanel.add((Component)this.myPropertiesEditor.createComponent(), "Center");
            }
        }
        if (this.myDescriptor == null) {
            this.myDescriptor = new DefaultLibraryRootsComponentDescriptor();
        }
        this.myModificationOfImportedModelWarningComponent = new ModificationOfImportedModelWarningComponent();
        this.myBottomPanel.add("Center", this.myModificationOfImportedModelWarningComponent.getLabel());
        this.init(new LibraryTreeStructure(this, this.myDescriptor));
        this.updatePropertiesLabel();
        this.onRootsChanged();
    }

    private void onRootsChanged() {
        this.myAddExcludedRootActionButton.setEnabled(!this.getNotExcludedRoots().isEmpty());
    }

    @NotNull
    public LibraryProperties getProperties() {
        LibraryProperties libraryProperties = this.getLibraryEditor().getProperties();
        if (libraryProperties == null) {
            LibraryRootsComponent.$$$reportNull$$$0(2);
        }
        return libraryProperties;
    }

    public boolean isNewLibrary() {
        return this.getLibraryEditor() instanceof NewLibraryEditor;
    }

    public void updatePropertiesLabel() {
        StringBuilder text = new StringBuilder();
        LibraryType type = this.getLibraryEditor().getType();
        Set<LibraryKind> excluded = type != null ? Collections.singleton(type.getKind()) : Collections.emptySet();
        for (String description : LibraryPresentationManager.getInstance().getDescriptions(this.getLibraryEditor().getFiles(OrderRootType.CLASSES), excluded)) {
            if (text.length() > 0) {
                text.append("\n");
            }
            text.append(description);
        }
        this.myPropertiesLabel.setText(text.toString());
    }

    private void init(AbstractTreeStructure treeStructure) {
        this.myTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        new LibraryRootsTreeSpeedSearch(this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new LibraryTreeRenderer()));
        this.myTreeBuilder = new LibraryTableTreeBuilder((JTree)this.myTree, (DefaultTreeModel)this.myTree.getModel(), treeStructure);
        this.myTreePanel.setLayout(new BorderLayout());
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTree)this.myTree).disableUpDownActions().setRemoveActionName(ProjectBundle.message((String)"library.remove.action", (Object[])new Object[0])).disableRemoveAction();
        toolbarDecorator.setPanelBorder((Border)new CustomLineBorder(1, 0, 0, 0));
        final ArrayList<AttachRootButtonDescriptor> popupItems = new ArrayList<AttachRootButtonDescriptor>();
        for (AttachRootButtonDescriptor descriptor2 : this.myDescriptor.createAttachButtons()) {
            Icon icon = descriptor2.getToolbarIcon();
            if (icon != null) {
                AttachItemAction action = new AttachItemAction(descriptor2, descriptor2.getButtonText(), icon);
                toolbarDecorator.addExtraAction(AnActionButton.fromAction((AnAction)action));
                continue;
            }
            popupItems.add(descriptor2);
        }
        this.myAddExcludedRootActionButton = new AddExcludedRootActionButton();
        toolbarDecorator.addExtraAction((AnActionButton)this.myAddExcludedRootActionButton);
        toolbarDecorator.addExtraAction(new AnActionButton("Remove", IconUtil.getRemoveIcon()){

            public void actionPerformed(AnActionEvent e) {
                Object[] selectedElements = LibraryRootsComponent.this.getSelectedElements();
                if (selectedElements.length == 0) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    for (Object selectedElement : selectedElements) {
                        if (selectedElement instanceof ItemElement) {
                            ItemElement itemElement = (ItemElement)((Object)((Object)selectedElement));
                            LibraryRootsComponent.this.getLibraryEditor().removeRoot(itemElement.getUrl(), itemElement.getRootType());
                            continue;
                        }
                        if (selectedElement instanceof OrderRootTypeElement) {
                            String[] urls;
                            OrderRootType rootType = ((OrderRootTypeElement)((Object)((Object)selectedElement))).getOrderRootType();
                            for (String url : urls = LibraryRootsComponent.this.getLibraryEditor().getUrls(rootType)) {
                                LibraryRootsComponent.this.getLibraryEditor().removeRoot(url, rootType);
                            }
                            continue;
                        }
                        if (!(selectedElement instanceof ExcludedRootElement)) continue;
                        LibraryRootsComponent.this.getLibraryEditor().removeExcludedRoot(((ExcludedRootElement)((Object)((Object)selectedElement))).getUrl());
                    }
                });
                LibraryRootsComponent.this.libraryChanged(true);
            }

            public void updateButton(AnActionEvent e) {
                super.updateButton(e);
                Object[] elements = LibraryRootsComponent.this.getSelectedElements();
                Presentation presentation = e.getPresentation();
                if (ContainerUtil.and((Object[])elements, (Condition)new FilteringIterator.InstanceOf(ExcludedRootElement.class))) {
                    presentation.setText("Cancel Exclusion");
                } else {
                    presentation.setText(this.getTemplatePresentation().getText());
                }
            }

            public ShortcutSet getShortcut() {
                return CommonShortcuts.getDelete();
            }
        });
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (popupItems.isEmpty()) {
                    new AttachFilesAction(LibraryRootsComponent.this.myDescriptor.getAttachFilesActionName()).actionPerformed(null);
                    return;
                }
                ArrayList<AttachItemActionBase> actions = new ArrayList<AttachItemActionBase>();
                actions.add(new AttachFilesAction(LibraryRootsComponent.this.myDescriptor.getAttachFilesActionName()));
                for (AttachRootButtonDescriptor descriptor2 : popupItems) {
                    actions.add(new AttachItemAction(descriptor2, descriptor2.getButtonText(), null));
                }
                DefaultActionGroup group = new DefaultActionGroup(actions);
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(button.getPreferredPopupPoint());
            }
        });
        this.myTreePanel.add((Component)toolbarDecorator.createPanel(), "Center");
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void setContextModule(Module module2) {
        this.myContextModule = module2;
    }

    @Nullable
    public VirtualFile getExistingRootDirectory() {
        for (PersistentOrderRootType orderRootType : OrderRootType.getAllPersistentTypes()) {
            VirtualFile[] existingRoots = this.getLibraryEditor().getFiles((OrderRootType)orderRootType);
            if (existingRoots.length <= 0) continue;
            VirtualFile existingRoot = existingRoots[0];
            if (existingRoot.getFileSystem() instanceof JarFileSystem) {
                existingRoot = JarFileSystem.getInstance().getVirtualFileForJar(existingRoot);
            }
            if (existingRoot == null) continue;
            if (existingRoot.isDirectory()) {
                return existingRoot;
            }
            return existingRoot.getParent();
        }
        return null;
    }

    @Nullable
    public VirtualFile getBaseDirectory() {
        if (this.myProject != null) {
            return this.myProject.getBaseDir();
        }
        return null;
    }

    public LibraryEditor getLibraryEditor() {
        return (LibraryEditor)this.myLibraryEditorComputable.compute();
    }

    public boolean hasChanges() {
        if (this.myPropertiesEditor != null && this.myPropertiesEditor.isModified()) {
            return true;
        }
        return this.getLibraryEditor().hasChanges();
    }

    private Object[] getSelectedElements() {
        if (this.myTreeBuilder == null || this.myTreeBuilder.isDisposed()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        TreePath[] selectionPaths = this.myTreeBuilder.getTree().getSelectionPaths();
        if (selectionPaths == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        for (TreePath selectionPath : selectionPaths) {
            Object pathElement = LibraryRootsComponent.getPathElement(selectionPath);
            if (pathElement == null) continue;
            elements.add(pathElement);
        }
        return ArrayUtil.toObjectArray(elements);
    }

    public void onLibraryRenamed() {
        this.updateModificationOfImportedModelWarning();
    }

    @Nullable
    private static Object getPathElement(TreePath selectionPath) {
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        if (lastPathComponent == null) {
            return null;
        }
        Object userObject = lastPathComponent.getUserObject();
        if (!(userObject instanceof NodeDescriptor)) {
            return null;
        }
        Object element = ((NodeDescriptor)userObject).getElement();
        if (!(element instanceof LibraryTableTreeContentElement)) {
            return null;
        }
        return element;
    }

    public void renameLibrary(String newName) {
        LibraryEditor libraryEditor = this.getLibraryEditor();
        libraryEditor.setName(newName);
        this.libraryChanged(false);
    }

    public void dispose() {
        if (this.myPropertiesEditor != null) {
            this.myPropertiesEditor.disposeUIResources();
        }
        this.myTreeBuilder = null;
    }

    public void resetProperties() {
        if (this.myPropertiesEditor != null) {
            this.myPropertiesEditor.reset();
        }
    }

    public void applyProperties() {
        if (this.myPropertiesEditor != null && this.myPropertiesEditor.isModified()) {
            this.myPropertiesEditor.apply();
        }
    }

    public void updateRootsTree() {
        if (this.myTreeBuilder != null) {
            this.myTreeBuilder.queueUpdate();
        }
    }

    @Nullable
    private VirtualFile getFileToSelect() {
        if (this.myLastChosen != null) {
            return this.myLastChosen;
        }
        VirtualFile directory = this.getExistingRootDirectory();
        if (directory != null) {
            return directory;
        }
        return this.getBaseDirectory();
    }

    private List<OrderRoot> attachFiles(List<OrderRoot> roots) {
        List<OrderRoot> rootsToAttach = this.filterAlreadyAdded(roots);
        if (!rootsToAttach.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.getLibraryEditor().addRoots((Collection)rootsToAttach));
            this.updatePropertiesLabel();
            this.onRootsChanged();
            this.myTreeBuilder.queueUpdate();
        }
        return rootsToAttach;
    }

    private List<OrderRoot> filterAlreadyAdded(@NotNull List<OrderRoot> roots) {
        if (roots == null) {
            LibraryRootsComponent.$$$reportNull$$$0(3);
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        for (OrderRoot root : roots) {
            Object[] libraryFiles = this.getLibraryEditor().getFiles(root.getType());
            if (ArrayUtil.contains((Object)root.getFile(), (Object[])libraryFiles)) continue;
            result.add(root);
        }
        return result;
    }

    private void libraryChanged(boolean putFocusIntoTree) {
        this.onRootsChanged();
        this.updatePropertiesLabel();
        this.myTreeBuilder.queueUpdate();
        if (putFocusIntoTree) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTree, true));
        }
        this.fireLibraryChanged();
    }

    private void fireLibraryChanged() {
        for (Runnable listener2 : this.myListeners) {
            listener2.run();
        }
        this.updateModificationOfImportedModelWarning();
    }

    private void updateModificationOfImportedModelWarning() {
        LibraryEditor libraryEditor = this.getLibraryEditor();
        ProjectModelExternalSource externalSource = libraryEditor.getExternalSource();
        if (externalSource != null && this.hasChanges()) {
            String name2 = libraryEditor instanceof ExistingLibraryEditor ? ((ExistingLibraryEditor)libraryEditor).getLibrary().getName() : libraryEditor.getName();
            this.myModificationOfImportedModelWarningComponent.showWarning(name2 != null ? "Library '" + name2 + "'" : "Library", externalSource);
        } else {
            this.myModificationOfImportedModelWarningComponent.hideWarning();
        }
    }

    public void addListener(Runnable listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(Runnable listener2) {
        this.myListeners.remove(listener2);
    }

    private Set<VirtualFile> getNotExcludedRoots() {
        LinkedHashSet<VirtualFile> roots = new LinkedHashSet<VirtualFile>();
        String[] excludedRootUrls = this.getLibraryEditor().getExcludedRootUrls();
        HashSet excludedRoots = new HashSet();
        for (String string : excludedRootUrls) {
            ContainerUtil.addIfNotNull(excludedRoots, (Object)VirtualFileManager.getInstance().findFileByUrl(string));
        }
        for (String string : OrderRootType.getAllPersistentTypes()) {
            VirtualFile[] files;
            for (VirtualFile file : files = this.getLibraryEditor().getFiles((OrderRootType)string)) {
                if (VfsUtilCore.isUnder((VirtualFile)file, excludedRoots)) continue;
                roots.add(VfsUtil.getLocalFile((VirtualFile)file));
            }
        }
        return roots;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryEditorComputable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryRootsComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryRootsComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyAdded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        MultiLineLabel multiLineLabel;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, 2, false, false));
        this.myTreePanel = jPanel3 = new JPanel();
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(300, -1), null));
        this.myPropertiesLabel = multiLineLabel = new MultiLineLabel();
        jPanel4.add((Component)multiLineLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myPropertiesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBottomPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class AddExcludedRootActionButton
    extends AnActionButton {
        public AddExcludedRootActionButton() {
            super("Exclude", null, AllIcons.Modules.AddExcludedRoot);
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile[] files;
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            descriptor2.setTitle("Exclude from Library");
            descriptor2.setDescription("Select directories which should be excluded from the library content. Content of excluded directories won't be processed by IDE.");
            Set roots = LibraryRootsComponent.this.getNotExcludedRoots();
            descriptor2.setRoots(roots.toArray(VirtualFile.EMPTY_ARRAY));
            if (roots.size() < 2) {
                descriptor2.withTreeRootVisible(true);
            }
            VirtualFile toSelect = null;
            for (Object o : LibraryRootsComponent.this.getSelectedElements()) {
                Object itemElement;
                Object object = itemElement = o instanceof ExcludedRootElement ? ((ExcludedRootElement)((Object)o)).getParentDescriptor() : o;
                if (!(itemElement instanceof ItemElement)) continue;
                toSelect = VirtualFileManager.getInstance().findFileByUrl(((ItemElement)((Object)itemElement)).getUrl());
                break;
            }
            if ((files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Component)LibraryRootsComponent.this.myPanel, (Project)LibraryRootsComponent.this.myProject, toSelect)).length > 0) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    for (VirtualFile file : files) {
                        LibraryRootsComponent.this.getLibraryEditor().addExcludedRoot(file.getUrl());
                    }
                });
                LibraryRootsComponent.this.myLastChosen = files[0];
                LibraryRootsComponent.this.libraryChanged(true);
            }
        }
    }

    private class AttachItemAction
    extends AttachItemActionBase {
        private final AttachRootButtonDescriptor myDescriptor;

        protected AttachItemAction(AttachRootButtonDescriptor descriptor2, String title, Icon icon) {
            super(title);
            this.getTemplatePresentation().setIcon(icon);
            this.myDescriptor = descriptor2;
        }

        @Override
        protected List<OrderRoot> selectRoots(@Nullable VirtualFile initialSelection) {
            VirtualFile[] files = this.myDescriptor.selectFiles((JComponent)LibraryRootsComponent.this.myPanel, initialSelection, LibraryRootsComponent.this.myContextModule, LibraryRootsComponent.this.getLibraryEditor());
            if (files.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<OrderRoot> roots = new ArrayList<OrderRoot>();
            for (VirtualFile file : this.myDescriptor.scanForActualRoots(files, (JComponent)LibraryRootsComponent.this.myPanel)) {
                roots.add(new OrderRoot(file, this.myDescriptor.getRootType(), this.myDescriptor.addAsJarDirectories()));
            }
            return roots;
        }
    }

    public abstract class AttachItemActionBase
    extends DumbAwareAction {
        protected AttachItemActionBase(String text) {
            super(text);
        }

        public void actionPerformed(@Nullable AnActionEvent e) {
            VirtualFile toSelect = LibraryRootsComponent.this.getFileToSelect();
            List<OrderRoot> roots = this.selectRoots(toSelect);
            if (roots.isEmpty()) {
                return;
            }
            List attachedRoots = LibraryRootsComponent.this.attachFiles(roots);
            OrderRoot first = (OrderRoot)ContainerUtil.getFirstItem((List)attachedRoots);
            if (first != null) {
                LibraryRootsComponent.this.myLastChosen = first.getFile();
            }
            LibraryRootsComponent.this.fireLibraryChanged();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)LibraryRootsComponent.this.myTree, true));
        }

        protected abstract List<OrderRoot> selectRoots(@Nullable VirtualFile var1);
    }

    private class AttachFilesAction
    extends AttachItemActionBase {
        public AttachFilesAction(String title) {
            super(title);
        }

        @Override
        protected List<OrderRoot> selectRoots(@Nullable VirtualFile initialSelection) {
            VirtualFile[] files;
            String name2 = LibraryRootsComponent.this.getLibraryEditor().getName();
            FileChooserDescriptor chooserDescriptor = LibraryRootsComponent.this.myDescriptor.createAttachFilesChooserDescriptor(name2);
            if (LibraryRootsComponent.this.myContextModule != null) {
                chooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)LibraryRootsComponent.this.myContextModule);
            }
            if ((files = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)LibraryRootsComponent.this.myPanel, (Project)LibraryRootsComponent.this.myProject, (VirtualFile)initialSelection)).length == 0) {
                return Collections.emptyList();
            }
            return RootDetectionUtil.detectRoots(Arrays.asList(files), (Component)LibraryRootsComponent.this.myPanel, (Project)LibraryRootsComponent.this.myProject, (LibraryRootsComponentDescriptor)LibraryRootsComponent.this.myDescriptor);
        }
    }
}

