/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.compiler.server.BuildManager;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactImpl;
import com.intellij.packaging.impl.artifacts.ArtifactLoadingErrorDescription;
import com.intellij.packaging.impl.artifacts.ArtifactManagerStateSplitter;
import com.intellij.packaging.impl.artifacts.ArtifactModelBase;
import com.intellij.packaging.impl.artifacts.ArtifactModelImpl;
import com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactVirtualFileListener;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.UnknownPackagingElementTypeException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.artifact.ArtifactManagerState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactPropertiesState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

@State(name="ArtifactManager", storages={@Storage(value="artifacts", stateSplitter=ArtifactManagerStateSplitter.class)})
public class ArtifactManagerImpl
extends ArtifactManager
implements ProjectComponent,
PersistentStateComponent<ArtifactManagerState>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.artifacts.ArtifactManagerImpl");
    @NonNls
    public static final String COMPONENT_NAME = "ArtifactManager";
    @NonNls
    public static final String PACKAGING_ELEMENT_NAME = "element";
    @NonNls
    public static final String TYPE_ID_ATTRIBUTE = "id";
    private final ArtifactManagerModel myModel;
    private final Project myProject;
    private final DefaultPackagingElementResolvingContext myResolvingContext;
    private boolean myInsideCommit = false;
    private boolean myLoaded;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    private final Map<String, LocalFileSystem.WatchRequest> myWatchedOutputs = new HashMap<String, LocalFileSystem.WatchRequest>();

    public ArtifactManagerImpl(Project project2) {
        this.myProject = project2;
        this.myModel = new ArtifactManagerModel();
        this.myResolvingContext = new DefaultPackagingElementResolvingContext(this.myProject);
        ((ArtifactPointerManagerImpl)ArtifactPointerManager.getInstance((Project)project2)).setArtifactManager(this);
    }

    @NotNull
    public Artifact[] getArtifacts() {
        Artifact[] artifactArray = this.myModel.getArtifacts();
        if (artifactArray == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(0);
        }
        return artifactArray;
    }

    public Artifact findArtifact(@NotNull String name2) {
        if (name2 == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(1);
        }
        return this.myModel.findArtifact(name2);
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(2);
        }
        Artifact artifact2 = this.myModel.getArtifactByOriginal(artifact);
        if (artifact2 == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(3);
        }
        return artifact2;
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(4);
        }
        Artifact artifact2 = this.myModel.getOriginalArtifact(artifact);
        if (artifact2 == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(5);
        }
        return artifact2;
    }

    @NotNull
    public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type) {
        if (type == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(6);
        }
        Collection<? extends Artifact> collection = this.myModel.getArtifactsByType(type);
        if (collection == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
        return this.myModel.getAllArtifactsIncludingInvalid();
    }

    public ArtifactManagerState getState() {
        ArtifactManagerState state = new ArtifactManagerState();
        for (Artifact artifact : this.getAllArtifactsIncludingInvalid()) {
            ArtifactState artifactState;
            if (artifact instanceof InvalidArtifact) {
                artifactState = ((InvalidArtifact)artifact).getState();
            } else {
                artifactState = new ArtifactState();
                artifactState.setBuildOnMake(artifact.isBuildOnMake());
                artifactState.setName(artifact.getName());
                artifactState.setOutputPath(artifact.getOutputPath());
                artifactState.setRootElement(ArtifactManagerImpl.serializePackagingElement(artifact.getRootElement()));
                artifactState.setArtifactType(artifact.getArtifactType().getId());
                ProjectModelExternalSource externalSource = artifact.getExternalSource();
                if (externalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)this.myProject)) {
                    artifactState.setExternalSystemId(externalSource.getId());
                }
                for (ArtifactPropertiesProvider provider2 : artifact.getPropertiesProviders()) {
                    ArtifactPropertiesState propertiesState = ArtifactManagerImpl.serializeProperties(provider2, artifact.getProperties(provider2));
                    if (propertiesState == null) continue;
                    artifactState.getPropertiesList().add(propertiesState);
                }
                Collections.sort(artifactState.getPropertiesList(), Comparator.comparing(ArtifactPropertiesState::getId));
            }
            state.getArtifacts().add(artifactState);
        }
        return state;
    }

    @Nullable
    private static <S> ArtifactPropertiesState serializeProperties(ArtifactPropertiesProvider provider2, ArtifactProperties<S> properties) {
        Element options = XmlSerializer.serialize((Object)properties.getState());
        if (options == null) {
            return null;
        }
        options.setName("options");
        ArtifactPropertiesState state = new ArtifactPropertiesState();
        state.setId(provider2.getId());
        state.setOptions(options);
        return state;
    }

    private static Element serializePackagingElement(PackagingElement<?> packagingElement) {
        Element element = new Element(PACKAGING_ELEMENT_NAME);
        element.setAttribute(TYPE_ID_ATTRIBUTE, packagingElement.getType().getId());
        Object bean = packagingElement.getState();
        if (bean != null) {
            XmlSerializer.serializeObjectInto((Object)bean, (Element)element);
        }
        if (packagingElement instanceof CompositePackagingElement) {
            for (PackagingElement child : ((CompositePackagingElement)packagingElement).getChildren()) {
                element.addContent(ArtifactManagerImpl.serializePackagingElement(child));
            }
        }
        return element;
    }

    private <T> PackagingElement<T> deserializeElement(Element element) throws UnknownPackagingElementTypeException {
        String id = element.getAttributeValue(TYPE_ID_ATTRIBUTE);
        PackagingElementType type = PackagingElementFactory.getInstance().findElementType(id);
        if (type == null) {
            throw new UnknownPackagingElementTypeException(id);
        }
        PackagingElement packagingElement = type.createEmpty(this.myProject);
        Object state = packagingElement.getState();
        if (state != null) {
            XmlSerializer.deserializeInto((Element)element, (Object)state);
            packagingElement.loadState(state);
        }
        List children = element.getChildren(PACKAGING_ELEMENT_NAME);
        for (Element child : children) {
            ((CompositePackagingElement)packagingElement).addOrFindChild(this.deserializeElement(child));
        }
        return packagingElement;
    }

    public void loadState(@NotNull ArtifactManagerState managerState) {
        if (managerState == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(8);
        }
        List artifactStates = managerState.getArtifacts();
        ArrayList<ArtifactImpl> artifacts = new ArrayList<ArtifactImpl>(artifactStates.size());
        if (!artifactStates.isEmpty()) {
            ApplicationManager.getApplication().runReadAction(() -> {
                for (ArtifactState state : artifactStates) {
                    artifacts.add(this.loadArtifact(state));
                }
            });
        }
        if (this.myLoaded) {
            ArtifactModelImpl model2 = new ArtifactModelImpl(this, artifacts);
            this.doCommit(model2);
        } else {
            this.myModel.setArtifactsList(artifacts);
            this.myLoaded = true;
        }
    }

    private ArtifactImpl loadArtifact(ArtifactState state) {
        CompositePackagingElement rootElement;
        ArtifactType type = ArtifactType.findById((String)state.getArtifactType());
        ProjectModelExternalSource externalSource = ArtifactManagerImpl.findExternalSource(state.getExternalSystemId());
        if (type == null) {
            return this.createInvalidArtifact(state, externalSource, "Unknown artifact type: " + state.getArtifactType());
        }
        Element element = state.getRootElement();
        String artifactName = state.getName();
        if (element != null) {
            try {
                rootElement = (CompositePackagingElement)this.deserializeElement(element);
            }
            catch (UnknownPackagingElementTypeException e) {
                return this.createInvalidArtifact(state, externalSource, "Unknown element: " + e.getTypeId());
            }
        } else {
            rootElement = type.createRootElement(artifactName);
        }
        ArtifactImpl artifact = new ArtifactImpl(artifactName, type, state.isBuildOnMake(), rootElement, state.getOutputPath(), externalSource);
        List propertiesList = state.getPropertiesList();
        for (ArtifactPropertiesState propertiesState : propertiesList) {
            ArtifactPropertiesProvider provider2 = ArtifactPropertiesProvider.findById((String)propertiesState.getId());
            if (provider2 != null) {
                ArtifactManagerImpl.deserializeProperties(artifact.getProperties(provider2), propertiesState);
                continue;
            }
            return this.createInvalidArtifact(state, externalSource, "Unknown artifact properties: " + propertiesState.getId());
        }
        return artifact;
    }

    private InvalidArtifact createInvalidArtifact(ArtifactState state, ProjectModelExternalSource externalSource, String errorMessage) {
        InvalidArtifact artifact = new InvalidArtifact(state, errorMessage, externalSource);
        ProjectLoadingErrorsNotifier.getInstance((Project)this.myProject).registerError((ConfigurationErrorDescription)new ArtifactLoadingErrorDescription(this.myProject, artifact));
        UnknownFeaturesCollector.getInstance((Project)this.myProject).registerUnknownFeature("com.intellij.packaging.artifacts.ArtifactType", state.getArtifactType(), "Artifact");
        return artifact;
    }

    @Nullable
    private static ProjectModelExternalSource findExternalSource(@Nullable String externalSourceId) {
        return externalSourceId != null ? ExternalProjectSystemRegistry.getInstance().getSourceById(externalSourceId) : null;
    }

    private static <S> void deserializeProperties(ArtifactProperties<S> artifactProperties, ArtifactPropertiesState propertiesState) {
        Element options = propertiesState.getOptions();
        if (artifactProperties == null || options == null) {
            return;
        }
        Object state = artifactProperties.getState();
        if (state != null) {
            XmlSerializer.deserializeInto((Element)options, (Object)state);
            artifactProperties.loadState(state);
        }
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchedOutputs.values());
    }

    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(9);
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new ArtifactVirtualFileListener(this.myProject, this), (Disposable)this.myProject);
        this.updateWatchedRoots();
    }

    private void updateWatchedRoots() {
        HashSet<String> pathsToRemove = new HashSet<String>(this.myWatchedOutputs.keySet());
        HashSet<String> toAdd = new HashSet<String>();
        for (Artifact artifact : this.getArtifacts()) {
            String path = artifact.getOutputPath();
            if (path == null || path.length() <= 0) continue;
            pathsToRemove.remove(path);
            if (this.myWatchedOutputs.containsKey(path)) continue;
            toAdd.add(path);
        }
        ArrayList requestsToRemove = new ArrayList();
        for (String path : pathsToRemove) {
            LocalFileSystem.WatchRequest request = this.myWatchedOutputs.remove(path);
            ContainerUtil.addIfNotNull(requestsToRemove, (Object)request);
        }
        Set newRequests = LocalFileSystem.getInstance().replaceWatchedRoots(requestsToRemove, toAdd, null);
        for (LocalFileSystem.WatchRequest request : newRequests) {
            this.myWatchedOutputs.put(request.getRootPath(), request);
        }
    }

    public Artifact[] getSortedArtifacts() {
        return this.myModel.getSortedArtifacts();
    }

    public ModifiableArtifactModel createModifiableModel() {
        return new ArtifactModelImpl(this, this.getArtifactsList());
    }

    public PackagingElementResolvingContext getResolvingContext() {
        return this.myResolvingContext;
    }

    public List<ArtifactImpl> getArtifactsList() {
        return this.myModel.myArtifactsList;
    }

    public void commit(ArtifactModelImpl artifactModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.doCommit(artifactModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(ArtifactModelImpl artifactModel) {
        boolean hasChanges;
        LOG.assertTrue(!this.myInsideCommit, (Object)"Recursive commit");
        this.myInsideCommit = true;
        try {
            List<ArtifactImpl> allArtifacts = artifactModel.getOriginalArtifacts();
            THashSet removed = new THashSet((Collection)this.myModel.myArtifactsList);
            ArrayList<ArtifactImpl> added = new ArrayList<ArtifactImpl>();
            ArrayList<Pair> changed = new ArrayList<Pair>();
            for (ArtifactImpl artifact : allArtifacts) {
                boolean isAdded = !removed.remove((Object)artifact);
                ArtifactImpl modifiableCopy = artifactModel.getModifiableCopy((Artifact)artifact);
                if (isAdded) {
                    added.add(artifact);
                    continue;
                }
                if (modifiableCopy == null || ((Object)((Object)modifiableCopy)).equals((Object)artifact)) continue;
                String oldName = artifact.getName();
                artifact.copyFrom(modifiableCopy);
                changed.add(Pair.create((Object)((Object)artifact), (Object)oldName));
            }
            this.myModel.setArtifactsList(allArtifacts);
            this.myModificationTracker.incModificationCount();
            ArtifactListener publisher = (ArtifactListener)this.myProject.getMessageBus().syncPublisher(TOPIC);
            hasChanges = !removed.isEmpty() || !added.isEmpty() || !changed.isEmpty();
            ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> ArtifactManagerImpl.lambda$doCommit$1((Set)removed, publisher, added, changed));
        }
        finally {
            this.myInsideCommit = false;
        }
        this.updateWatchedRoots();
        if (hasChanges) {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Artifact addArtifact(final @NotNull String name2, final @NotNull ArtifactType type, final CompositePackagingElement<?> root) {
        if (name2 == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(10);
        }
        if (type == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(11);
        }
        Artifact artifact = (Artifact)new WriteAction<Artifact>(){

            protected void run(@NotNull Result<Artifact> result) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                ModifiableArtifactModel model2 = ArtifactManagerImpl.this.createModifiableModel();
                ModifiableArtifact artifact = model2.addArtifact(name2, type);
                if (root != null) {
                    artifact.setRootElement(root);
                }
                model2.commit();
                result.setResult((Object)artifact);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/artifacts/ArtifactManagerImpl$1", "run"));
            }
        }.execute().getResultObject();
        if (artifact == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(12);
        }
        return artifact;
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String relativePath, @NotNull PackagingElement<?> element) {
        if (artifact == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(13);
        }
        if (relativePath == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(14);
        }
        if (element == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(15);
        }
        this.addElementsToDirectory(artifact, relativePath, Collections.singletonList(element));
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String relativePath, @NotNull Collection<? extends PackagingElement<?>> elements) {
        if (artifact == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(16);
        }
        if (relativePath == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(17);
        }
        if (elements == null) {
            ArtifactManagerImpl.$$$reportNull$$$0(18);
        }
        final ModifiableArtifactModel model2 = this.createModifiableModel();
        CompositePackagingElement root = model2.getOrCreateModifiableArtifact(artifact).getRootElement();
        PackagingElementFactory.getInstance().getOrCreateDirectory(root, relativePath).addOrFindChildren(elements);
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                model2.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/artifacts/ArtifactManagerImpl$2", "run"));
            }
        }.execute();
    }

    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    private static /* synthetic */ void lambda$doCommit$1(Set removed, ArtifactListener publisher, List added, List changed) {
        for (ArtifactImpl artifact : removed) {
            publisher.artifactRemoved((Artifact)artifact);
        }
        for (ArtifactImpl artifact : added) {
            publisher.artifactAdded((Artifact)artifact);
        }
        for (Pair pair2 : changed) {
            publisher.artifactChanged((Artifact)pair2.getFirst(), (String)pair2.getSecond());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/ArtifactManagerImpl";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerState";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = PACKAGING_ELEMENT_NAME;
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactByOriginal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalArtifact";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsByType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addArtifact";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findArtifact";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactByOriginal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalArtifact";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactsByType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addElementsToDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArtifactManagerModel
    extends ArtifactModelBase {
        private List<ArtifactImpl> myArtifactsList = new ArrayList<ArtifactImpl>();
        private Artifact[] mySortedArtifacts;

        private ArtifactManagerModel() {
        }

        public void setArtifactsList(List<ArtifactImpl> artifactsList) {
            this.myArtifactsList = artifactsList;
            this.artifactsChanged();
        }

        @Override
        protected void artifactsChanged() {
            super.artifactsChanged();
            this.mySortedArtifacts = null;
        }

        @Override
        protected List<? extends Artifact> getArtifactsList() {
            return this.myArtifactsList;
        }

        public Artifact[] getSortedArtifacts() {
            if (this.mySortedArtifacts == null) {
                this.mySortedArtifacts = (Artifact[])this.getArtifacts().clone();
                Arrays.sort(this.mySortedArtifacts, ArtifactManager.ARTIFACT_COMPARATOR);
            }
            return this.mySortedArtifacts;
        }
    }
}

