/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleOutputPackagingElementBase
extends PackagingElement<ModuleOutputPackagingElementState>
implements ModuleOutputPackagingElement {
    @NonNls
    public static final String MODULE_NAME_ATTRIBUTE = "name";
    protected ModulePointer myModulePointer;
    protected final Project myProject;

    public ModuleOutputPackagingElementBase(PackagingElementType type, Project project2, ModulePointer modulePointer) {
        super(type);
        this.myProject = project2;
        this.myModulePointer = modulePointer;
    }

    public ModuleOutputPackagingElementBase(PackagingElementType type, Project project2) {
        super(type);
        this.myProject = project2;
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            ModuleOutputPackagingElementBase.$$$reportNull$$$0(0);
        }
        if (creator == null) {
            ModuleOutputPackagingElementBase.$$$reportNull$$$0(1);
        }
        if (generationContext == null) {
            ModuleOutputPackagingElementBase.$$$reportNull$$$0(2);
        }
        if (artifactType == null) {
            ModuleOutputPackagingElementBase.$$$reportNull$$$0(3);
        }
        if (this.myModulePointer != null) {
            String moduleOutput = BuildProperties.propertyRef((String)this.getModuleOutputAntProperty(generationContext));
            return Collections.singletonList(creator.createDirectoryContentCopyInstruction(moduleOutput));
        }
        return Collections.emptyList();
    }

    protected abstract String getModuleOutputAntProperty(ArtifactAntGenerationContext var1);

    @Nullable
    protected abstract VirtualFile getModuleOutputPath(CompilerModuleExtension var1);

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES;
        if (packagingElementOutputKind == null) {
            ModuleOutputPackagingElementBase.$$$reportNull$$$0(4);
        }
        return packagingElementOutputKind;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            ModuleOutputPackagingElementBase.$$$reportNull$$$0(5);
        }
        return element.getClass() == this.getClass() && this.myModulePointer != null && this.myModulePointer.equals(((ModuleOutputPackagingElementBase)element).myModulePointer);
    }

    public ModuleOutputPackagingElementState getState() {
        ModuleOutputPackagingElementState state = new ModuleOutputPackagingElementState();
        if (this.myModulePointer != null) {
            state.setModuleName(this.myModulePointer.getModuleName());
        }
        return state;
    }

    public void loadState(@NotNull ModuleOutputPackagingElementState state) {
        String moduleName;
        if (state == null) {
            ModuleOutputPackagingElementBase.$$$reportNull$$$0(6);
        }
        this.myModulePointer = (moduleName = state.getModuleName()) != null ? ModulePointerManager.getInstance((Project)this.myProject).create(moduleName) : null;
    }

    @Override
    @Nullable
    public String getModuleName() {
        return this.myModulePointer != null ? this.myModulePointer.getModuleName() : null;
    }

    @Override
    @Nullable
    public Module findModule(PackagingElementResolvingContext context) {
        if (this.myModulePointer != null) {
            Module module2 = this.myModulePointer.getModule();
            ModulesProvider modulesProvider = context.getModulesProvider();
            if (module2 != null && (modulesProvider instanceof DefaultModulesProvider || ArrayUtil.contains((Object)module2, (Object[])modulesProvider.getModules()))) {
                return module2;
            }
            return modulesProvider.getModule(this.myModulePointer.getModuleName());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAntInstructions";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ModuleOutputPackagingElementState {
        private String myModuleName;

        @Attribute(value="name")
        public String getModuleName() {
            return this.myModuleName;
        }

        public void setModuleName(String moduleName) {
            this.myModuleName = moduleName;
        }
    }
}

