/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class FindInFilesOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private final MyFileProcessor myFileProcessor;
    private THashSet<PsiFile> filesToScan;
    private THashSet<PsiFile> filesToScan2;
    private final Project myProject;
    private final SearchScope myScope;
    private final boolean myCaseSensitive;
    private boolean myTransactionStarted = false;

    FindInFilesOptimizingSearchHelper(SearchScope scope, boolean caseSensitive, Project project2) {
        this.myScope = scope;
        this.myCaseSensitive = caseSensitive;
        this.myProject = project2;
        if (scope instanceof GlobalSearchScope && this.filesToScan == null) {
            this.filesToScan = new THashSet();
            this.filesToScan2 = new THashSet();
        }
        this.myFileProcessor = new MyFileProcessor();
    }

    @Override
    public boolean doOptimizing() {
        return this.myScope instanceof GlobalSearchScope;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.filesToScan != null) {
            this.filesToScan.clear();
            this.filesToScan2.clear();
        }
    }

    @Override
    protected void doAddSearchWordInCode(@NotNull String word) {
        if (word == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(0);
        }
        this.myTransactionStarted = true;
        CacheManager.SERVICE.getInstance((Project)this.myProject).processFilesWithWord((Processor)this.myFileProcessor, word, (short)17, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
    }

    @Override
    protected void doAddSearchWordInText(@NotNull String word) {
        if (word == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(1);
        }
        this.myTransactionStarted = true;
        CacheManager.SERVICE.getInstance((Project)this.myProject).processFilesWithWord((Processor)this.myFileProcessor, word, (short)16, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
    }

    @Override
    protected void doAddSearchWordInComments(@NotNull String word) {
        if (word == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(2);
        }
        this.myTransactionStarted = true;
        CacheManager.SERVICE.getInstance((Project)this.myProject).processFilesWithWord((Processor)this.myFileProcessor, word, (short)2, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
    }

    @Override
    protected void doAddSearchWordInLiterals(@NotNull String word) {
        if (word == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(3);
        }
        this.myTransactionStarted = true;
        CacheManager.SERVICE.getInstance((Project)this.myProject).processFilesWithWord((Processor)this.myFileProcessor, word, (short)4, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
    }

    @Override
    public void endTransaction() {
        if (!this.myTransactionStarted) {
            return;
        }
        this.myTransactionStarted = false;
        super.endTransaction();
        THashSet<PsiFile> map2 = this.filesToScan;
        if (!map2.isEmpty()) {
            map2.clear();
        }
        this.filesToScan = this.filesToScan2;
        this.filesToScan2 = map2;
    }

    @Override
    @NotNull
    public Set<PsiFile> getFilesSetToScan() {
        assert (!this.myTransactionStarted);
        if (this.filesToScan == null) {
            Set<PsiFile> set = Collections.emptySet();
            if (set == null) {
                FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(4);
            }
            return set;
        }
        THashSet<PsiFile> tHashSet = this.filesToScan;
        if (tHashSet == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(5);
        }
        return tHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/FindInFilesOptimizingSearchHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/FindInFilesOptimizingSearchHelper";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesSetToScan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInCode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInComments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInLiterals";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFileProcessor
    implements Processor<PsiFile> {
        private MyFileProcessor() {
        }

        public boolean process(PsiFile file) {
            if (FindInFilesOptimizingSearchHelper.this.scanRequest == 0 || FindInFilesOptimizingSearchHelper.this.filesToScan.contains((Object)file)) {
                FindInFilesOptimizingSearchHelper.this.filesToScan2.add((Object)file);
            }
            return true;
        }
    }
}

