/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class RegExpPredicate
extends MatchPredicate {
    private Pattern pattern;
    private final String baseHandlerName;
    private boolean simpleString;
    private final boolean couldBeOptimized;
    private final String regexp;
    private final boolean caseSensitive;
    private boolean multiline;
    private final boolean wholeWords;
    private final boolean target;
    private NodeTextGenerator myNodeTextGenerator;

    public RegExpPredicate(String regexp, boolean caseSensitive, String _baseHandlerName, boolean _wholeWords, boolean _target) {
        boolean bl = this.couldBeOptimized = !StructuralSearchUtil.containsRegExpMetaChar(regexp);
        if (!_wholeWords) {
            this.simpleString = this.couldBeOptimized;
        }
        this.regexp = regexp;
        this.caseSensitive = caseSensitive;
        this.wholeWords = _wholeWords;
        this.baseHandlerName = _baseHandlerName;
        if (!this.simpleString) {
            this.compilePattern();
        }
        this.target = _target;
    }

    private void compilePattern() {
        try {
            String realRegexp = this.regexp;
            if (this.wholeWords) {
                realRegexp = ".*?\\b(?:" + realRegexp + ")\\b.*?";
            }
            this.pattern = Pattern.compile(realRegexp, (this.caseSensitive ? 0 : 2) | (this.multiline ? 32 : 0));
        }
        catch (PatternSyntaxException ex) {
            throw new MalformedPatternException(SSRBundle.message("error.incorrect.regexp.constraint", this.regexp, this.baseHandlerName));
        }
    }

    public boolean couldBeOptimized() {
        return this.couldBeOptimized;
    }

    public String getRegExp() {
        return this.regexp;
    }

    @Override
    public boolean match(PsiElement matchedNode, int start, int end, MatchContext context) {
        if (matchedNode == null) {
            return false;
        }
        String text = this.myNodeTextGenerator != null ? this.myNodeTextGenerator.getText(matchedNode) : RegExpPredicate.getMeaningfulText(matchedNode);
        boolean result = this.doMatch(text, start, end, context, matchedNode);
        if (!result) {
            matchedNode = StructuralSearchUtil.getParentIfIdentifier(matchedNode);
            String alternativeText = context.getPattern().getAlternativeTextToMatch(matchedNode, text);
            if (alternativeText != null) {
                result = this.doMatch(alternativeText, start, end, context, matchedNode);
            }
        }
        return result;
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile2 != null ? profile2.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    boolean doMatch(String text, MatchContext context, PsiElement matchedElement) {
        return this.doMatch(text, 0, -1, context, matchedElement);
    }

    boolean doMatch(String text, int from, int end, MatchContext context, PsiElement matchedElement) {
        Matcher matcher;
        if (from > 0 || end != -1) {
            text = text.substring(from, end == -1 || end >= text.length() ? text.length() : end);
        }
        if (this.simpleString) {
            return this.caseSensitive ? text.equals(this.regexp) : text.equalsIgnoreCase(this.regexp);
        }
        if (!this.multiline && text.contains("\n")) {
            this.setMultiline(true);
        }
        if ((matcher = this.pattern.matcher(text)).matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                context.getResult().addSon(new MatchResultImpl(this.baseHandlerName + "_" + i, matcher.group(i), new SmartPsiPointer(matchedElement), matcher.start(i), matcher.end(i), this.target));
            }
            return true;
        }
        return false;
    }

    public void setNodeTextGenerator(NodeTextGenerator nodeTextGenerator) {
        this.myNodeTextGenerator = nodeTextGenerator;
    }

    public void setMultiline(boolean b) {
        this.multiline = b;
        this.compilePattern();
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public static interface NodeTextGenerator {
        public String getText(PsiElement var1);
    }
}

