/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class ReplacementInfoImpl
implements ReplacementInfo {
    private final MatchResult matchResult;
    private final List<SmartPsiElementPointer> matchesPtrList = new SmartList();
    private final Map<String, MatchResult> variableMap = new HashMap<String, MatchResult>();
    private final Map<PsiElement, String> elementToVariableNameMap = new HashMap<PsiElement, String>(1);
    private final Map<String, String> sourceNameToSearchPatternNameMap = new HashMap<String, String>(1);
    private String replacement;

    ReplacementInfoImpl(MatchResult matchResult, Project project2) {
        this.matchResult = matchResult;
        this.init(project2);
    }

    private void init(Project project2) {
        this.fillPointerList(project2);
        this.fillVariableMap(this.matchResult);
        for (Map.Entry<String, MatchResult> entry : this.variableMap.entrySet()) {
            this.fillElementToVariableNameMap(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Override
    @Nullable
    public PsiElement getMatch(int index) {
        return this.matchesPtrList.get(index).getElement();
    }

    @Override
    public int getMatchesCount() {
        return this.matchesPtrList.size();
    }

    @Override
    public MatchResult getNamedMatchResult(String name2) {
        return this.variableMap.get(name2);
    }

    @Override
    public MatchResult getMatchResult() {
        return this.matchResult;
    }

    @Override
    public String getVariableName(PsiElement element) {
        return this.elementToVariableNameMap.get(element);
    }

    @Override
    public String getSearchPatternName(String sourceName) {
        return this.sourceNameToSearchPatternNameMap.get(sourceName);
    }

    private void fillPointerList(Project project2) {
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project2);
        if ("__multi_line__".equals(this.matchResult.getName())) {
            Iterator<MatchResult> i = this.matchResult.getAllSons().iterator();
            while (i.hasNext()) {
                MatchResult r = i.next();
                if (!"__line__".equals(r.getName())) continue;
                PsiElement element = r.getMatch();
                if (element instanceof PsiDocCommentBase && i.hasNext()) {
                    MatchResult son = i.next();
                    if ("__line__".equals(son.getName()) && StructuralSearchUtil.isDocCommentOwner(son.getMatch())) {
                        element = son.getMatch();
                    } else {
                        this.matchesPtrList.add(manager.createSmartPsiElementPointer(element));
                        element = son.getMatch();
                    }
                }
                this.matchesPtrList.add(manager.createSmartPsiElementPointer(element));
            }
        } else {
            this.matchesPtrList.add(manager.createSmartPsiElementPointer(this.matchResult.getMatch()));
        }
    }

    private void fillElementToVariableNameMap(String name2, MatchResult matchResult) {
        boolean multiMatch;
        boolean bl = multiMatch = matchResult.isMultipleMatch() || matchResult.isScopeMatch();
        if (matchResult.hasSons() && multiMatch) {
            for (MatchResult r : matchResult.getAllSons()) {
                this.fillElementToVariableNameMap(name2, r);
            }
        } else if (!multiMatch && matchResult.getMatchRef() != null) {
            this.elementToVariableNameMap.put(matchResult.getMatch(), name2);
        }
    }

    private void fillVariableMap(MatchResult r) {
        List<MatchResult> allSons;
        String name2 = r.getName();
        if (name2 != null) {
            this.variableMap.putIfAbsent(name2, r);
            PsiElement element = StructuralSearchUtil.getParentIfIdentifier(r.getMatch());
            if (element instanceof PsiNamedElement) {
                this.sourceNameToSearchPatternNameMap.put(((PsiNamedElement)element).getName(), name2);
            }
        }
        if (!r.isScopeMatch() || !r.isMultipleMatch()) {
            for (MatchResult matchResult : r.getAllSons()) {
                this.fillVariableMap(matchResult);
            }
        } else if (r.hasSons() && (allSons = r.getAllSons()).size() > 0) {
            this.fillVariableMap(allSons.get(0));
        }
    }
}

