/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import junit.framework.TestCase;

public class BombedProgressIndicator
extends AbstractProgressIndicatorBase {
    private int myRemainingChecks;
    private volatile Thread myThread;

    public BombedProgressIndicator(int checkCanceledCount) {
        this.myRemainingChecks = checkCanceledCount;
    }

    public void checkCanceled() throws ProcessCanceledException {
        if (this.myThread == Thread.currentThread()) {
            if (this.myRemainingChecks > 0) {
                --this.myRemainingChecks;
            } else {
                this.cancel();
            }
        }
        super.checkCanceled();
    }

    public boolean runBombed(Runnable runnable2) {
        this.myThread = Thread.currentThread();
        Semaphore canStart = new Semaphore();
        canStart.down();
        Semaphore finished = new Semaphore();
        finished.down();
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ProgressIndicatorBase mockIndicator = new ProgressIndicatorBase();
            ProgressManager.getInstance().runProcess(() -> {
                mockIndicator.cancel();
                canStart.up();
                finished.waitFor();
                try {
                    ProgressManager.checkCanceled();
                    TestCase.fail();
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }, (ProgressIndicator)mockIndicator);
        });
        ProgressManager.getInstance().runProcess(() -> {
            canStart.waitFor();
            try {
                runnable2.run();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            finally {
                finished.up();
            }
        }, (ProgressIndicator)this);
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return this.isCanceled();
    }
}

