/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ProjectViewTestUtil {
    public static VirtualFile[] getFiles(AbstractTreeNode kid, Function<AbstractTreeNode, VirtualFile[]> converterFunction) {
        VirtualFile[] result;
        if (kid instanceof BasePsiNode) {
            Object value = kid.getValue();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value));
            return new VirtualFile[]{virtualFile};
        }
        if (converterFunction != null && (result = (VirtualFile[])converterFunction.fun((Object)kid)) != null) {
            return result;
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public static void collect(AbstractTreeNode node, MultiValuesMap<VirtualFile, AbstractTreeNode> map2, AbstractTreeStructure structure, Function<AbstractTreeNode, VirtualFile[]> converterFunction) {
        Object[] kids;
        for (Object kid1 : kids = structure.getChildElements((Object)node)) {
            VirtualFile[] files;
            ProjectViewNode kid = (ProjectViewNode)kid1;
            for (VirtualFile vFile : files = ProjectViewTestUtil.getFiles((AbstractTreeNode)kid, converterFunction)) {
                map2.put((Object)vFile, (Object)kid);
                for (ProjectViewNode eachParent = (ProjectViewNode)kid.getParent(); eachParent != null; eachParent = (ProjectViewNode)eachParent.getParent()) {
                    map2.put((Object)vFile, (Object)eachParent);
                }
            }
            ProjectViewTestUtil.collect((AbstractTreeNode)kid, map2, structure, converterFunction);
        }
    }

    public static void checkContainsMethod(Object rootElement, AbstractTreeStructure structure, Function<AbstractTreeNode, VirtualFile[]> converterFunction) {
        MultiValuesMap map2 = new MultiValuesMap();
        ProjectViewTestUtil.collect((AbstractTreeNode)rootElement, (MultiValuesMap<VirtualFile, AbstractTreeNode>)map2, structure, converterFunction);
        for (VirtualFile eachFile : map2.keySet()) {
            Collection nodes = map2.values();
            for (AbstractTreeNode node : nodes) {
                boolean expected;
                ProjectViewNode eachNode = (ProjectViewNode)node;
                boolean actual = eachNode.contains(eachFile);
                if (actual == (expected = map2.get((Object)eachFile).contains(eachNode))) continue;
                boolean actual1 = eachNode.contains(eachFile);
                boolean expected1 = map2.get((Object)eachFile).contains(eachNode);
                Assert.assertTrue((String)("file=" + eachFile + " node=" + eachNode.getTestPresentation() + " expected:" + expected), (boolean)false);
            }
        }
    }

    public static void checkGetParentConsistency(AbstractTreeStructure structure, Object from) {
        Object[] childElements;
        for (Object childElement : childElements = structure.getChildElements(from)) {
            Assert.assertSame((Object)from, (Object)structure.getParentElement(childElement));
            ProjectViewTestUtil.checkGetParentConsistency(structure, childElement);
        }
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.assertStructureEqual(structure, expected, 27, null, structure.getRootElement(), printInfo);
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, int maxRowCount, @Nullable Comparator comparator, Object rootNode, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.checkGetParentConsistency(structure, rootNode);
        String actual = PlatformTestUtil.print(structure, rootNode, 0, comparator, maxRowCount, ' ', printInfo).toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected static boolean isExpanded(DefaultMutableTreeNode nodeForElement, AbstractProjectViewPSIPane pane) {
        TreePath path = new TreePath(nodeForElement.getPath());
        return pane.getTree().isExpanded(path.getParentPath());
    }

    public static DefaultMutableTreeNode getNodeForElement(PsiElement element, AbstractProjectViewPSIPane pane) {
        JTree tree = pane.getTree();
        TreeModel model2 = tree.getModel();
        Object root = model2.getRoot();
        return ProjectViewTestUtil.getNodeForElement(root, model2, element);
    }

    private static DefaultMutableTreeNode getNodeForElement(Object root, TreeModel model2, PsiElement element) {
        Object userObject;
        if (root instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)root).getUserObject()) instanceof AbstractTreeNode) {
            AbstractTreeNode treeNode = (AbstractTreeNode)userObject;
            if (element.equals(treeNode.getValue())) {
                return (DefaultMutableTreeNode)root;
            }
            for (int i = 0; i < model2.getChildCount(root); ++i) {
                DefaultMutableTreeNode nodeForChild = ProjectViewTestUtil.getNodeForElement(model2.getChild(root, i), model2, element);
                if (nodeForChild == null) continue;
                return nodeForChild;
            }
        }
        return null;
    }

    public static boolean isExpanded(PsiElement element, AbstractProjectViewPSIPane pane) {
        DefaultMutableTreeNode nodeForElement = ProjectViewTestUtil.getNodeForElement(element, pane);
        return nodeForElement != null && ProjectViewTestUtil.isExpanded((DefaultMutableTreeNode)nodeForElement.getParent(), pane);
    }

    public static void setupImpl(@NotNull Project project2, boolean loadPaneExtensions) {
        ToolWindowManagerEx toolWindowManager;
        ToolWindow toolWindow;
        if (project2 == null) {
            ProjectViewTestUtil.$$$reportNull$$$0(0);
        }
        if ((toolWindow = (toolWindowManager = ToolWindowManagerEx.getInstanceEx((Project)project2)).getToolWindow(ToolWindowId.PROJECT_VIEW)) == null) {
            ToolWindowEP[] beans;
            for (ToolWindowEP bean : beans = (ToolWindowEP[])Extensions.getExtensions((ExtensionPointName)ToolWindowEP.EP_NAME)) {
                if (!bean.id.equals(ToolWindowId.PROJECT_VIEW)) continue;
                toolWindow = toolWindowManager.registerToolWindow(bean.id, (JComponent)new JLabel(), ToolWindowAnchor.fromText((String)bean.anchor), (Disposable)project2, false, bean.canCloseContents);
                break;
            }
        }
        ((ProjectViewImpl)ProjectView.getInstance((Project)project2)).setupImpl(toolWindow, loadPaneExtensions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/ProjectViewTestUtil", "setupImpl"));
    }
}

