/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.junit.Assert;

public class TreeTester {
    private final TreeNode myNode;
    private Function<TreeNode, String> myPresenter = Object::toString;

    public static TreeTester forTree(JTree tree) {
        return TreeTester.forNode((TreeNode)tree.getModel().getRoot());
    }

    public static TreeTester forNode(TreeNode node) {
        return new TreeTester(node);
    }

    private TreeTester(TreeNode node) {
        this.myNode = node;
    }

    public TreeTester withPresenter(Function<TreeNode, String> presenter) {
        this.myPresenter = presenter;
        return this;
    }

    public void assertStructureEquals(String expected) {
        StringBuilder buffer = new StringBuilder();
        this.printSubTree(this.myNode, 0, buffer);
        Assert.assertEquals((Object)expected, (Object)buffer.toString());
    }

    private void printSubTree(TreeNode node, int level, StringBuilder result) {
        result.append(StringUtil.repeat((String)" ", (int)level)).append(this.myPresenter.apply(node)).append("\n");
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.printSubTree(node.getChildAt(i), level + 1, result);
        }
    }
}

