/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileImpl;
import com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileContainerImpl
extends SimpleModificationTracker
implements ConfigFileContainer {
    private final Project myProject;
    private final EventDispatcher<ConfigFileListener> myDispatcher = EventDispatcher.create(ConfigFileListener.class);
    private final MultiValuesMap<ConfigFileMetaData, ConfigFile> myConfigFiles = new MultiValuesMap();
    private ConfigFile[] myCachedConfigFiles;
    private final ConfigFileMetaDataProvider myMetaDataProvider;
    private final ConfigFileInfoSetImpl myConfiguration;

    public ConfigFileContainerImpl(Project project2, ConfigFileMetaDataProvider descriptorMetaDataProvider, ConfigFileInfoSetImpl configuration) {
        this.myConfiguration = configuration;
        this.myMetaDataProvider = descriptorMetaDataProvider;
        this.myProject = project2;
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getPropertyName().equals("name")) {
                    ConfigFileContainerImpl.this.fileChanged(event.getFile());
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ConfigFileContainerImpl.this.fileChanged(event.getFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/util/descriptors/impl/ConfigFileContainerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        this.myConfiguration.setContainer(this);
    }

    private void fileChanged(VirtualFile file) {
        for (ConfigFile descriptor2 : this.myConfigFiles.values()) {
            VirtualFile virtualFile = descriptor2.getVirtualFile();
            if (virtualFile == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)virtualFile, (boolean)false)) continue;
            this.myConfiguration.updateConfigFile(descriptor2);
            this.fireDescriptorChanged(descriptor2);
        }
    }

    @Nullable
    public ConfigFile getConfigFile(ConfigFileMetaData metaData) {
        return (ConfigFile)ContainerUtil.getFirstItem((Collection)this.myConfigFiles.get((Object)metaData));
    }

    public ConfigFile[] getConfigFiles() {
        if (this.myCachedConfigFiles == null) {
            Collection descriptors = this.myConfigFiles.values();
            this.myCachedConfigFiles = descriptors.toArray(ConfigFile.EMPTY_ARRAY);
        }
        return this.myCachedConfigFiles;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void addListener(ConfigFileListener listener2, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void fireDescriptorChanged(ConfigFile descriptor2) {
        this.incModificationCount();
        ((ConfigFileListener)this.myDispatcher.getMulticaster()).configFileChanged(descriptor2);
    }

    public ConfigFileInfoSet getConfiguration() {
        return this.myConfiguration;
    }

    public void dispose() {
    }

    public void addListener(ConfigFileListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(ConfigFileListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public ConfigFileMetaDataProvider getMetaDataProvider() {
        return this.myMetaDataProvider;
    }

    public void updateDescriptors(@NotNull MultiValuesMap<ConfigFileMetaData, ConfigFileInfo> descriptorsMap) {
        if (descriptorsMap == null) {
            ConfigFileContainerImpl.$$$reportNull$$$0(0);
        }
        HashSet toDelete = this.myConfigFiles.isEmpty() ? Collections.emptySet() : new HashSet(this.myConfigFiles.values());
        Set added = null;
        for (Map.Entry entry : descriptorsMap.entrySet()) {
            ConfigFileMetaData metaData = (ConfigFileMetaData)entry.getKey();
            HashSet newDescriptors = new HashSet((Collection)entry.getValue());
            Collection oldDescriptors = this.myConfigFiles.get((Object)metaData);
            if (oldDescriptors != null) {
                for (ConfigFile descriptor2 : oldDescriptors) {
                    if (!newDescriptors.remove(descriptor2.getInfo())) continue;
                    toDelete.remove(descriptor2);
                }
            }
            for (ConfigFileInfo configuration : newDescriptors) {
                ConfigFileImpl configFile = new ConfigFileImpl(this, configuration);
                Disposer.register((Disposable)this, (Disposable)configFile);
                this.myConfigFiles.put((Object)metaData, (Object)configFile);
                if (added == null) {
                    added = new THashSet();
                }
                added.add(configFile);
            }
        }
        for (ConfigFile descriptor3 : toDelete) {
            this.myConfigFiles.remove((Object)descriptor3.getMetaData(), (Object)descriptor3);
            Disposer.dispose((Disposable)descriptor3);
        }
        this.myCachedConfigFiles = null;
        if (added != null) {
            for (ConfigFile configFile : added) {
                this.incModificationCount();
                ((ConfigFileListener)this.myDispatcher.getMulticaster()).configFileAdded(configFile);
            }
        }
        for (ConfigFile configFile : toDelete) {
            this.incModificationCount();
            ((ConfigFileListener)this.myDispatcher.getMulticaster()).configFileRemoved(configFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorsMap", "com/intellij/util/descriptors/impl/ConfigFileContainerImpl", "updateDescriptors"));
    }
}

