/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.XmlUtil;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileDescriptionCachedValueProvider<T extends DomElement>
implements SemElement {
    private final XmlFile myXmlFile;
    private volatile boolean myComputed;
    private volatile DomFileElementImpl<T> myLastResult;
    private final MyCondition myCondition = new MyCondition();
    private final DomManagerImpl myDomManager;
    private final DomService myDomService;

    public FileDescriptionCachedValueProvider(DomManagerImpl domManager, XmlFile xmlFile) {
        this.myDomManager = domManager;
        this.myXmlFile = xmlFile;
        this.myDomService = DomService.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DomFileElementImpl<T> getFileElement() {
        if (this.myComputed) {
            return this.myLastResult;
        }
        DomFileElementImpl<T> result = this._computeFileElement(false, this.myDomService.getXmlFileHeader(this.myXmlFile), null);
        MyCondition myCondition = this.myCondition;
        synchronized (myCondition) {
            if (this.myComputed) {
                return this.myLastResult;
            }
            this.myLastResult = result;
            WeakReference<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<T>>>>> ref = result != null ? new WeakReference<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<T>>>>>(result) : null;
            this.myXmlFile.putUserData(DomManagerImpl.CACHED_FILE_ELEMENT, ref);
            this.myComputed = true;
            return result;
        }
    }

    @Nullable
    private DomFileElementImpl<T> _computeFileElement(boolean fireEvents, @NotNull XmlFileHeader rootTagName, @Nullable StringBuilder sb) {
        SmartList events;
        if (rootTagName == null) {
            FileDescriptionCachedValueProvider.$$$reportNull$$$0(0);
        }
        if (sb != null) {
            sb.append(rootTagName).append("\n");
        }
        if (!this.myXmlFile.isValid()) {
            return null;
        }
        if (sb != null) {
            sb.append("File is valid\n");
        }
        if (!(this.myXmlFile.getFileType() instanceof DomSupportEnabled)) {
            return null;
        }
        if (sb != null) {
            sb.append("File is of dom file type\n");
        }
        DomFileDescription<T> description = this.findFileDescription(rootTagName, sb);
        DomFileElementImpl<T> oldValue = this.getLastValue();
        if (sb != null) {
            sb.append("last " + oldValue + "\n");
        }
        SmartList smartList = events = fireEvents ? new SmartList() : Collections.emptyList();
        if (oldValue != null && fireEvents) {
            events.add(new DomEvent(oldValue, false));
        }
        if (description == null) {
            return null;
        }
        Class rootElementClass = description.getRootElementClass();
        XmlName xmlName = DomImplUtil.createXmlName(description.getRootTagName(), rootElementClass, null);
        assert (xmlName != null);
        EvaluatedXmlNameImpl rootTagName1 = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)xmlName, (String)xmlName.getNamespaceKey(), (boolean)false);
        VirtualFile file = this.myXmlFile.getVirtualFile();
        FileStub stub = null;
        if (description.hasStubs() && file instanceof VirtualFileWithId && !this.isFileParsed()) {
            ObjectStubTree stubTree;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!XmlUtil.isStubBuilding() && (stubTree = StubTreeLoader.getInstance().readOrBuild(this.myXmlFile.getProject(), file, (PsiFile)this.myXmlFile)) != null) {
                stub = (FileStub)stubTree.getRoot();
            }
        }
        DomFileElementImpl<T> result = new DomFileElementImpl<T>(this.myXmlFile, rootElementClass, rootTagName1, this.myDomManager, description, stub);
        if (sb != null) {
            sb.append("success " + result + "\n");
        }
        if (fireEvents) {
            events.add(new DomEvent(result, true));
        }
        return result;
    }

    private boolean isFileParsed() {
        return this.myXmlFile instanceof PsiFileEx && ((PsiFileEx)this.myXmlFile).isContentsLoaded();
    }

    @Nullable
    private DomFileDescription<T> findFileDescription(XmlFileHeader xmlFileHeader, @Nullable StringBuilder sb) {
        DomFileDescription description;
        DomFileDescription mockDescription = (DomFileDescription)this.myXmlFile.getUserData(DomManagerImpl.MOCK_DESCRIPTION);
        if (mockDescription != null) {
            return mockDescription;
        }
        if (sb != null) {
            sb.append("no mock\n");
        }
        XmlFile originalFile = (XmlFile)this.myXmlFile.getOriginalFile();
        if (sb != null) {
            sb.append("original: " + originalFile + "\n");
        }
        if (!originalFile.equals(this.myXmlFile)) {
            FileDescriptionCachedValueProvider provider2 = this.myDomManager.getOrCreateCachedValueProvider(originalFile);
            DomFileElementImpl element = provider2.getFileElement();
            if (sb != null) {
                sb.append("originalDom " + element + "\n");
            }
            return element == null ? null : element.getFileDescription();
        }
        Set<DomFileDescription> namedDescriptions = this.myDomManager.getFileDescriptions(xmlFileHeader.getRootTagLocalName());
        if (sb != null) {
            sb.append("named " + new HashSet<DomFileDescription>(namedDescriptions) + "\n");
        }
        if ((description = (DomFileDescription)ContainerUtil.find(namedDescriptions, (Condition)this.myCondition)) == null) {
            Set<DomFileDescription> unnamed = this.myDomManager.getAcceptingOtherRootTagNameDescriptions();
            description = (DomFileDescription)ContainerUtil.find(unnamed, (Condition)this.myCondition);
        }
        if (sb != null) {
            sb.append("found " + description + "\n");
        }
        return description;
    }

    @Nullable
    final DomFileElementImpl<T> getLastValue() {
        return this.myLastResult;
    }

    public String getFileElementWithLogging() {
        XmlFileHeader rootTagName = this.myDomService.getXmlFileHeader(this.myXmlFile);
        StringBuilder log = new StringBuilder();
        this.myLastResult = this._computeFileElement(false, rootTagName, log);
        return log.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTagName", "com/intellij/util/xml/impl/FileDescriptionCachedValueProvider", "_computeFileElement"));
    }

    private class MyCondition
    implements Condition<DomFileDescription> {
        public Module module;

        private MyCondition() {
        }

        public boolean value(DomFileDescription description) {
            return description.isMyFile(FileDescriptionCachedValueProvider.this.myXmlFile, this.module);
        }
    }
}

