/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrZipBackedCache;
import com.jetbrains.cidr.lang.OCLog;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b,\n\u0002\u0010\r\n\u0002\b\u0004\b&\u0018\u0000 N*\u0006\b\u0000\u0010\u0001 \u0000*\u0006\b\u0001\u0010\u0002 \u0001*\u0006\b\u0002\u0010\u0003 \u00002\u00020\u0004:\u0001NB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ#\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\"J\"\u0010#\u001a\u00020\u001e2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0012H\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0006H\u0002J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\nH\u0002J\b\u0010*\u001a\u00020\u001eH\u0002J%\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010\"J\u001a\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u0006H\u0004J\u001f\u0010/\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00028\u00002\u0006\u00100\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u00101J\u0014\u00102\u001a\u0004\u0018\u00010\n2\b\u00103\u001a\u0004\u0018\u00010\u0006H\u0003J\u0012\u00104\u001a\u0004\u0018\u00010\n2\u0006\u00105\u001a\u00020\u0006H\u0002J\u0017\u00106\u001a\u0004\u0018\u00010\u00062\u0006\u0010 \u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00107J\u0015\u00108\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u00109J\u0017\u0010:\u001a\u0004\u0018\u00010\u00062\u0006\u0010 \u001a\u00028\u0000H$\u00a2\u0006\u0002\u00107J\b\u0010;\u001a\u00020\u0006H\u0003J\u0015\u0010<\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u00109J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u0016H\u0016J\u0010\u0010?\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\nH\u0002J\u001a\u0010@\u001a\u0004\u0018\u00010\u00062\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u0006H\u0004J\u001f\u0010A\u001a\u0004\u0018\u00018\u00012\u0006\u00105\u001a\u00020\n2\u0006\u0010 \u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010BJ\u0012\u0010C\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020\u0006H\u0002J\u0012\u0010D\u001a\u00020\u001e2\b\u00105\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010E\u001a\u00020\u001e2\b\u00105\u001a\u0004\u0018\u00010\u0006H\u0007J\u0006\u0010F\u001a\u00020\u001eJ*\u0010G\u001a\u0004\u0018\u00010\n2\u0006\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\u00062\u0006\u0010J\u001a\u00020K2\u0006\u0010\u001f\u001a\u00020\u0013H\u0004J-\u0010L\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010MR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00120\u0011X\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/jetbrains/cidr/CidrZipBackedCache;", "Key", "Value", "CachingValue", "", "cachePath", "", "zipFileName", "(Ljava/lang/String;Ljava/lang/String;)V", "cacheRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCacheRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "cacheRootPath", "getCacheRootPath", "()Ljava/lang/String;", "cachingQueue", "Lcom/intellij/util/concurrency/QueueProcessor;", "Lkotlin/Triple;", "Lcom/intellij/openapi/project/Project;", "invalidationLock", "Lcom/intellij/openapi/util/Ref;", "", "myCacheRoot", "myCacheRootInTests", "myZipCacheRoot", "myZipCacheRootInTests", "zipCacheRoot", "getZipCacheRoot", "cacheValue", "", "project", "key", "value", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Ljava/lang/Object;)V", "cacheValueWhenNotDumb", "it", "checkFileNameHasProperRegister", "file", "expectedName", "checkForCachesInvalidation", "root", "createBrokenCacheMarker", "doCacheValue", "findFile", "cacheDir", "name", "getCacheDir", "createIfDoesntExist", "(Ljava/lang/Object;Z)Lcom/intellij/openapi/vfs/VirtualFile;", "getInstalledCacheRoot", "installedCacheParentFolder", "getOrCreateDir", "path", "getPathForCaching", "(Ljava/lang/Object;)Ljava/lang/String;", "getPrebuiltValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "getRelativePath", "getResourceFolder", "getValue", "invalidate", "immediate", "isCacheBroken", "readFile", "readValue", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;)Ljava/lang/Object;", "registerModuleCacheRoot", "setCacheRootInTests", "setZipCacheRootInTests", "waitForCacheToBeWritten", "writeToFile", "dir", "fileName", "content", "", "writeValue", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Ljava/lang/Object;)V", "Companion", "intellij.cidr.common"})
public abstract class CidrZipBackedCache<Key, Value, CachingValue> {
    private final QueueProcessor<Triple<Project, Key, CachingValue>> cachingQueue;
    private final Ref<Boolean> invalidationLock;
    private final VirtualFile myCacheRoot;
    private VirtualFile myCacheRootInTests;
    private final VirtualFile myZipCacheRoot;
    private VirtualFile myZipCacheRootInTests;
    private final String cachePath;
    private final String zipFileName;
    @NotNull
    public static final String NO_ZIP = "";
    @NotNull
    public static final String MODULE_CACHE_ZIP = "module_cache.zip";
    private static final String BROKEN_CACHE_MARKER_FILENAME = "broken.marker";
    private static volatile boolean buildingCache;
    public static final Companion Companion;

    @Nullable
    public final VirtualFile getCacheRoot() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        return application.isUnitTestMode() ? this.myCacheRootInTests : this.myCacheRoot;
    }

    @Nullable
    public final VirtualFile getZipCacheRoot() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        return application.isUnitTestMode() ? this.myZipCacheRootInTests : this.myZipCacheRoot;
    }

    @Nullable
    public final String getCacheRootPath() {
        VirtualFile virtualFile = this.getCacheRoot();
        return virtualFile != null ? virtualFile.getPath() : null;
    }

    public final void setCacheRootInTests(@Nullable String path) {
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, path){
            final /* synthetic */ CidrZipBackedCache this$0;
            final /* synthetic */ String $path;

            public final void run() {
                CidrZipBackedCache.access$setMyCacheRootInTests$p(this.this$0, this.$path == null ? CidrZipBackedCache.access$getMyCacheRoot$p(this.this$0) : CidrZipBackedCache.access$registerModuleCacheRoot(this.this$0, this.$path));
            }
            {
                this.this$0 = cidrZipBackedCache;
                this.$path = string;
            }
        });
    }

    public final void setZipCacheRootInTests(@Nullable String path) {
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, path){
            final /* synthetic */ CidrZipBackedCache this$0;
            final /* synthetic */ String $path;

            public final void run() {
                CidrZipBackedCache.access$setMyZipCacheRootInTests$p(this.this$0, this.$path == null ? CidrZipBackedCache.access$getMyZipCacheRoot$p(this.this$0) : CidrZipBackedCache.access$getInstalledCacheRoot(this.this$0, this.$path));
            }
            {
                this.this$0 = cidrZipBackedCache;
                this.$path = string;
            }
        });
    }

    @Contract(value="null->null")
    private final VirtualFile getInstalledCacheRoot(String installedCacheParentFolder) {
        if (installedCacheParentFolder == null) {
            return null;
        }
        if (Companion.getBuildingCache()) {
            return null;
        }
        if (Intrinsics.areEqual((Object)this.zipFileName, (Object)NO_ZIP)) {
            return null;
        }
        return (VirtualFile)ReadAction.compute((ThrowableComputable)new ThrowableComputable<T, E>(this, installedCacheParentFolder){
            final /* synthetic */ CidrZipBackedCache this$0;
            final /* synthetic */ String $installedCacheParentFolder;

            @Nullable
            public final VirtualFile compute() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                OCLog.LOG.assertTrue(application.isDispatchThread());
                File zip = new File(this.$installedCacheParentFolder, CidrZipBackedCache.access$getZipFileName$p(this.this$0));
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)zip, (boolean)true);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile zipVF = virtualFile;
                VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(zipVF);
                if (virtualFile2 == null) {
                    return null;
                }
                VirtualFile archive = virtualFile2;
                return archive.findFileByRelativePath(CidrZipBackedCache.access$getCachePath$p(this.this$0));
            }
            {
                this.this$0 = cidrZipBackedCache;
                this.$installedCacheParentFolder = string;
            }
        });
    }

    @NonNls
    private final String getResourceFolder() {
        String string;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            String string2 = PathManager.getSystemPath();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathManager.getSystemPath()");
        } else {
            String string3 = FileUtil.join((String[])new String[]{PathManager.getHomePath(), "Resources"});
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FileUtil.join(PathManage\u2026tHomePath(), \"Resources\")");
        }
        return string;
    }

    @Nullable
    public final Value getValue(Key key) {
        Value Value2 = this.getPrebuiltValue(key);
        if (Value2 != null) {
            Value Value3;
            Value it = Value3 = Value2;
            return it;
        }
        VirtualFile virtualFile = this.getCacheDir(key, false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile cacheDir = virtualFile;
        return this.readValue(cacheDir, key);
    }

    @Nullable
    public final Value getPrebuiltValue(Key key) {
        VirtualFile cacheDir;
        VirtualFile virtualFile = this.getZipCacheRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        String string = this.getRelativePath(key);
        if (string == null) {
            return null;
        }
        String path = string;
        VirtualFile virtualFile2 = root.findFileByRelativePath(path);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = cacheDir = virtualFile2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"cacheDir");
        return this.readValue(virtualFile3, key);
    }

    public final void cacheValue(@NotNull Project project2, Key key, CachingValue value) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.cachingQueue.add((Object)new Triple((Object)project2, key, value));
    }

    private final void doCacheValue(Project project2, Key key, CachingValue value) {
        TransactionGuard.submitTransaction((Disposable)Disposer.newDisposable(), (Runnable)new Runnable(this, key, project2, value){
            final /* synthetic */ CidrZipBackedCache this$0;
            final /* synthetic */ Object $key;
            final /* synthetic */ Project $project;
            final /* synthetic */ Object $value;

            public final void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ doCacheValue.1 this$0;

                    public final void run() {
                        VirtualFile virtualFile = CidrZipBackedCache.access$getCacheDir(this.this$0.this$0, this.this$0.$key, true);
                        if (virtualFile == null) {
                            return;
                        }
                        VirtualFile cacheDir = virtualFile;
                        this.this$0.this$0.writeValue(cacheDir, this.this$0.$project, this.this$0.$key, this.this$0.$value);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = cidrZipBackedCache;
                this.$key = object;
                this.$project = project2;
                this.$value = object2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void cacheValueWhenNotDumb(Triple<? extends Project, ? extends Key, ? extends CachingValue> it) {
        void key;
        void project2;
        Triple<? extends Project, ? extends Key, ? extends CachingValue> triple = it;
        Project project3 = (Project)triple.component1();
        Object object = triple.component2();
        Object value = triple.component3();
        DumbService.getInstance((Project)project2).waitForSmartMode();
        this.doCacheValue((Project)project2, key, value);
    }

    public final void waitForCacheToBeWritten() {
        this.cachingQueue.waitFor();
        UIUtil.dispatchAllInvocationEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(boolean immediate) {
        Ref<Boolean> ref = this.invalidationLock;
        synchronized (ref) {
            block6: {
                block5: {
                    if (immediate) break block5;
                    Object object = this.invalidationLock.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"invalidationLock.get()");
                    if (!((Boolean)object).booleanValue()) break block6;
                }
                this.createBrokenCacheMarker();
                this.invalidationLock.set((Object)immediate);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    protected abstract String getRelativePath(Key var1);

    @Nullable
    protected abstract Value readValue(@NotNull VirtualFile var1, Key var2);

    protected abstract void writeValue(@NotNull VirtualFile var1, @NotNull Project var2, Key var3, CachingValue var4);

    @Nullable
    protected final String readFile(@NotNull VirtualFile cacheDir, @NotNull String name2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        VirtualFile virtualFile = this.findFile(cacheDir, name2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile cached = virtualFile;
        try {
            string = VfsUtilCore.loadText((VirtualFile)cached);
        }
        catch (IOException e) {
            string = null;
        }
        return string;
    }

    @Nullable
    protected final VirtualFile findFile(@NotNull VirtualFile cacheDir, @NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        VirtualFile cached = cacheDir.findChild(name2);
        return cached != null && this.checkFileNameHasProperRegister(cached, name2) ? cached : null;
    }

    @Nullable
    protected final VirtualFile writeToFile(@NotNull VirtualFile dir, @NotNull String fileName, @NotNull CharSequence content, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        try {
            Document document;
            VirtualFile file = dir.findOrCreateChildData((Object)this, fileName);
            VfsUtil.saveText((VirtualFile)file, (String)((Object)content).toString());
            if (!project2.isDisposed() && (document = FileDocumentManager.getInstance().getDocument(file)) != null) {
                PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            }
            return file;
        }
        catch (IOException e) {
            OCLog.LOG.error((Throwable)e);
            return null;
        }
    }

    private final boolean checkFileNameHasProperRegister(VirtualFile file, String expectedName) {
        return Intrinsics.areEqual((Object)expectedName, (Object)file.getName());
    }

    private final VirtualFile registerModuleCacheRoot(String root) {
        return (VirtualFile)WriteAction.compute((ThrowableComputable)new ThrowableComputable<T, E>(this, root){
            final /* synthetic */ CidrZipBackedCache this$0;
            final /* synthetic */ String $root;

            @Nullable
            public final VirtualFile compute() {
                try {
                    VirtualFile dir = VfsUtil.createDirectoryIfMissing((String)this.$root);
                    if (dir != null) {
                        CidrZipBackedCache.access$checkForCachesInvalidation(this.this$0, dir);
                        return dir;
                    }
                }
                catch (IOException error) {
                    OCLog.LOG.warn((Throwable)error);
                }
                return null;
            }
            {
                this.this$0 = cidrZipBackedCache;
                this.$root = string;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkForCachesInvalidation(VirtualFile root) {
        boolean doClearCache = false;
        Ref<Boolean> ref = this.invalidationLock;
        synchronized (ref) {
            Object object = this.invalidationLock.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"invalidationLock.get()");
            if (((Boolean)object).booleanValue() && this.isCacheBroken(root)) {
                doClearCache = true;
                this.invalidationLock.set((Object)false);
            }
            VirtualFile[] virtualFileArray = Unit.INSTANCE;
        }
        if (doClearCache) {
            try {
                for (VirtualFile file : root.getChildren()) {
                    file.delete((Object)this);
                }
            }
            catch (IOException e) {
                OCLog.LOG.error((Throwable)e);
            }
        }
    }

    private final boolean isCacheBroken(VirtualFile root) {
        return root.findChild(BROKEN_CACHE_MARKER_FILENAME) != null;
    }

    private final void createBrokenCacheMarker() {
        String string = this.getCacheRootPath();
        if (string == null) {
            return;
        }
        String path = string;
        File root = new File(path);
        if (root.exists()) {
            File file = new File(root, BROKEN_CACHE_MARKER_FILENAME);
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                OCLog.LOG.error((Throwable)e);
            }
        }
    }

    private final VirtualFile getCacheDir(Key key, boolean createIfDoesntExist) {
        String string = this.getPathForCaching(key);
        if (string == null) {
            return null;
        }
        String pathForCaching = string;
        return createIfDoesntExist ? this.getOrCreateDir(pathForCaching) : VfsUtil.findFileByIoFile((File)new File(pathForCaching), (boolean)false);
    }

    private final VirtualFile getOrCreateDir(String path) {
        VirtualFile virtualFile;
        try {
            VirtualFile cacheDir = VfsUtil.createDirectoryIfMissing((String)path);
            if (cacheDir == null) {
                OCLog.LOG.error("failed to create caching directory: " + path);
            }
        }
        catch (IOException e) {
            OCLog.LOG.error((Throwable)e);
            virtualFile = null;
        }
        return virtualFile;
    }

    private final String getPathForCaching(Key key) {
        VirtualFile virtualFile = this.getCacheRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        String string = this.getRelativePath(key);
        if (string == null) {
            return null;
        }
        String path = string;
        return FileUtil.join((String[])new String[]{root.getPath(), path});
    }

    public CidrZipBackedCache(@NotNull String cachePath, @NotNull String zipFileName) {
        Intrinsics.checkParameterIsNotNull((Object)cachePath, (String)"cachePath");
        Intrinsics.checkParameterIsNotNull((Object)zipFileName, (String)"zipFileName");
        this.cachePath = cachePath;
        this.zipFileName = zipFileName;
        this.cachingQueue = new QueueProcessor(new Consumer<T>(this){
            final /* synthetic */ CidrZipBackedCache this$0;

            public final void consume(Triple<? extends Project, ? extends Key, ? extends CachingValue> it) {
                Triple<? extends Project, ? extends Key, ? extends CachingValue> triple = it;
                Intrinsics.checkExpressionValueIsNotNull(triple, (String)"it");
                CidrZipBackedCache.access$cacheValueWhenNotDumb(this.this$0, triple);
            }
            {
                this.this$0 = cidrZipBackedCache;
            }
        });
        Ref ref = Ref.create((Object)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"Ref.create(true)");
        this.invalidationLock = ref;
        String string = FileUtil.join((String[])new String[]{PathManager.getSystemPath(), this.cachePath});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.join(PathManage\u2026tSystemPath(), cachePath)");
        this.myCacheRootInTests = this.myCacheRoot = this.registerModuleCacheRoot(string);
        this.myZipCacheRootInTests = this.myZipCacheRoot = this.getInstalledCacheRoot(this.getResourceFolder());
    }

    public /* synthetic */ CidrZipBackedCache(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = NO_ZIP;
        }
        this(string, string2);
    }

    static {
        Companion = new Companion(null);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getMyCacheRootInTests$p(CidrZipBackedCache $this) {
        return $this.myCacheRootInTests;
    }

    public static final /* synthetic */ void access$setMyCacheRootInTests$p(CidrZipBackedCache $this, @Nullable VirtualFile virtualFile) {
        $this.myCacheRootInTests = virtualFile;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getMyCacheRoot$p(CidrZipBackedCache $this) {
        return $this.myCacheRoot;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$registerModuleCacheRoot(CidrZipBackedCache $this, @NotNull String root) {
        return $this.registerModuleCacheRoot(root);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getMyZipCacheRootInTests$p(CidrZipBackedCache $this) {
        return $this.myZipCacheRootInTests;
    }

    public static final /* synthetic */ void access$setMyZipCacheRootInTests$p(CidrZipBackedCache $this, @Nullable VirtualFile virtualFile) {
        $this.myZipCacheRootInTests = virtualFile;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getMyZipCacheRoot$p(CidrZipBackedCache $this) {
        return $this.myZipCacheRoot;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getInstalledCacheRoot(CidrZipBackedCache $this, @Nullable String installedCacheParentFolder) {
        return $this.getInstalledCacheRoot(installedCacheParentFolder);
    }

    @NotNull
    public static final /* synthetic */ String access$getZipFileName$p(CidrZipBackedCache $this) {
        return $this.zipFileName;
    }

    @NotNull
    public static final /* synthetic */ String access$getCachePath$p(CidrZipBackedCache $this) {
        return $this.cachePath;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getCacheDir(CidrZipBackedCache $this, Object key, boolean createIfDoesntExist) {
        return $this.getCacheDir(key, createIfDoesntExist);
    }

    public static final /* synthetic */ void access$checkForCachesInvalidation(CidrZipBackedCache $this, @NotNull VirtualFile root) {
        $this.checkForCachesInvalidation(root);
    }

    public static final /* synthetic */ void access$cacheValueWhenNotDumb(CidrZipBackedCache $this, @NotNull Triple it) {
        $this.cacheValueWhenNotDumb(it);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/CidrZipBackedCache$Companion;", "", "()V", "BROKEN_CACHE_MARKER_FILENAME", "", "MODULE_CACHE_ZIP", "NO_ZIP", "buildingCache", "", "getBuildingCache", "()Z", "setBuildingCache", "(Z)V", "intellij.cidr.common"})
    public static final class Companion {
        public final boolean getBuildingCache() {
            return buildingCache;
        }

        public final void setBuildingCache(boolean bl) {
            buildingCache = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

