/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PredefinedVariables {
    public static final String JETBRAINS_IDE = "JETBRAINS_IDE";

    @NotNull
    public static List<String> getIDEVariables() {
        ApplicationInfo applicationInfo = PredefinedVariables.getInfo();
        if (applicationInfo == null) {
            List<String> list = Collections.singletonList(JETBRAINS_IDE);
            if (list == null) {
                PredefinedVariables.$$$reportNull$$$0(0);
            }
            return list;
        }
        String ideName = ApplicationNamesInfo.getInstance().getProductName().toUpperCase(Locale.US) + "_IDE".replaceAll("\\W", "_");
        List<String> list = Collections.unmodifiableList(Arrays.asList(JETBRAINS_IDE, ideName));
        if (list == null) {
            PredefinedVariables.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static String getVersionNumber() {
        ApplicationInfo applicationInfo = PredefinedVariables.getInfo();
        Application application = ApplicationManager.getApplication();
        if (applicationInfo == null || application == null || application.isUnitTestMode()) {
            String string = PredefinedVariables.toVersionNumber("2017.1");
            if (string == null) {
                PredefinedVariables.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = PredefinedVariables.toVersionNumber(applicationInfo.getFullVersion());
        if (string == null) {
            PredefinedVariables.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static ApplicationInfo getInfo() {
        Application application = ApplicationManager.getApplication();
        return application == null ? null : ApplicationInfo.getInstance();
    }

    static String toVersionNumber(@NotNull String version) {
        if (version == null) {
            PredefinedVariables.$$$reportNull$$$0(4);
        }
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(version.split("\\D")));
        while (parts.size() < 3) {
            parts.add("00");
        }
        String major = (String)parts.get(0);
        String minor = (String)parts.get(1);
        String bugfix = (String)parts.get(2);
        if (major.length() < 4) {
            major = StringUtil.repeat((String)"0", (int)(4 - major.length())) + major;
        }
        if (minor.length() < 2) {
            minor = StringUtil.repeat((String)"0", (int)(2 - minor.length())) + minor;
        }
        if (bugfix.length() < 2) {
            bugfix = StringUtil.repeat((String)"0", (int)(2 - bugfix.length())) + bugfix;
        }
        return major + minor + bugfix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/PredefinedVariables";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIDEVariables";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionNumber";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/PredefinedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toVersionNumber";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

