/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenHelper<T> {
    private final Key<T> myOpenDataKey;
    private final SupportedFileChecker mySupportedFileChecker;

    public ProjectOpenHelper(@NotNull Key<T> openDataKey, @NotNull SupportedFileChecker supportedFileChecker) {
        if (openDataKey == null) {
            ProjectOpenHelper.$$$reportNull$$$0(0);
        }
        if (supportedFileChecker == null) {
            ProjectOpenHelper.$$$reportNull$$$0(1);
        }
        this.myOpenDataKey = openDataKey;
        this.mySupportedFileChecker = supportedFileChecker;
    }

    public boolean isSupportedFile(@Nullable VirtualFile file) {
        return file != null && this.mySupportedFileChecker.isSupportedFile(file);
    }

    public boolean isSupportedFile(@Nullable String fileName) {
        return fileName != null && this.mySupportedFileChecker.isSupportedFile(fileName);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data) {
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(2);
        }
        if (!this.isSupportedFile(virtualFile)) {
            return null;
        }
        this.markFileToOpen(virtualFile, data);
        VirtualFile baseDir = virtualFile.getParent();
        return PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, projectToClose, forceOpenInNewFrame);
    }

    public void markFileToOpen(@NotNull VirtualFile virtualFile, @NotNull T data) {
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(3);
        }
        if (data == null) {
            ProjectOpenHelper.$$$reportNull$$$0(4);
        }
        VirtualFile baseDir = virtualFile.getParent();
        baseDir.putUserData(this.myOpenDataKey, data);
    }

    @Nullable
    public T getAndClearFileToOpenData(@NotNull Project project2) {
        VirtualFile baseDir;
        if (project2 == null) {
            ProjectOpenHelper.$$$reportNull$$$0(5);
        }
        if ((baseDir = project2.getBaseDir()) == null) {
            return null;
        }
        Object data = baseDir.getUserData(this.myOpenDataKey);
        baseDir.putUserData(this.myOpenDataKey, null);
        return (T)data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openDataKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedFileChecker";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/ProjectOpenHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "markFileToOpen";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getAndClearFileToOpenData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface SupportedFileChecker {
        public boolean isSupportedFile(@NotNull VirtualFile var1);

        public boolean isSupportedFile(@NotNull String var1);
    }
}

