/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.Version;
import com.intellij.util.VersionUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ToolVersion {
    public static final String UNKNOWN_VERSION = "unknown";
    private static final Version NULL_VERSION = new Version(0, 0, 0);
    @NotNull
    public final String versionString;
    @NotNull
    public final Version versionNumber;

    public ToolVersion(int major, int minor, int bugfix) {
        this(Version.toCompactString((int)major, (int)minor, (int)bugfix), major, minor, bugfix);
    }

    public ToolVersion(@NotNull String versionString, int major, int minor, int bugfix) {
        if (versionString == null) {
            ToolVersion.$$$reportNull$$$0(0);
        }
        this(versionString, new Version(major, minor, bugfix));
    }

    public ToolVersion(@NotNull String versionString, @NotNull Version versionNumber) {
        if (versionString == null) {
            ToolVersion.$$$reportNull$$$0(1);
        }
        if (versionNumber == null) {
            ToolVersion.$$$reportNull$$$0(2);
        }
        this.versionNumber = versionNumber;
        this.versionString = versionString;
    }

    @NotNull
    public static ToolVersion createUnknown(@NotNull String versionString) {
        if (versionString == null) {
            ToolVersion.$$$reportNull$$$0(3);
        }
        ToolVersion toolVersion = new ToolVersion(versionString, NULL_VERSION);
        if (toolVersion == null) {
            ToolVersion.$$$reportNull$$$0(4);
        }
        return toolVersion;
    }

    @NotNull
    public static ToolVersion parse(@NotNull String versionString, Pattern ... patterns) {
        Version version;
        if (versionString == null) {
            ToolVersion.$$$reportNull$$$0(5);
        }
        if (patterns == null) {
            ToolVersion.$$$reportNull$$$0(6);
        }
        ToolVersion toolVersion = new ToolVersion(versionString, (version = VersionUtil.parseVersion((String)versionString, (Pattern[])patterns)) != null ? version : NULL_VERSION);
        if (toolVersion == null) {
            ToolVersion.$$$reportNull$$$0(7);
        }
        return toolVersion;
    }

    public String toString() {
        return this.versionString;
    }

    @NotNull
    public String toCompactString() {
        String string = this.isUnknown() ? UNKNOWN_VERSION : this.versionNumber.toCompactString();
        if (string == null) {
            ToolVersion.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isUnknown() {
        return this.versionNumber == NULL_VERSION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolVersion version = (ToolVersion)o;
        return this.isUnknown() == version.isUnknown() && Objects.equals(this.versionString, version.versionString) && Objects.equals(this.versionNumber, version.versionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.isUnknown(), this.versionString, this.versionNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionNumber";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/ToolVersion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/ToolVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnknown";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toCompactString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUnknown";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

