/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp;

import com.intellij.execution.RunManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.cpp.CPPSettingsUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u001a\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\u0004\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u001a\u001c\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\f"}, d2={"checkDuplicatingNames", "", "allNames", "", "", "elementDisplayName", "deduplicateNames", "originalNames", "format", "extractBaseName", "originalName", "suggestNextName", "intellij.clion"})
@JvmName(name="CPPSettingsUtil")
public final class CPPSettingsUtil {
    @NotNull
    public static final String suggestNextName(@NotNull String originalName, @NotNull List<String> allNames) {
        Intrinsics.checkParameterIsNotNull((Object)originalName, (String)"originalName");
        Intrinsics.checkParameterIsNotNull(allNames, (String)"allNames");
        return RunManager.Companion.suggestUniqueName(originalName, (Collection)allNames);
    }

    @NotNull
    public static final String extractBaseName(@NotNull String originalName) {
        Intrinsics.checkParameterIsNotNull((Object)originalName, (String)"originalName");
        return RunManager.Companion.extractBaseName(originalName);
    }

    @NotNull
    public static final List<String> deduplicateNames(@NotNull List<String> originalNames) {
        Intrinsics.checkParameterIsNotNull(originalNames, (String)"originalNames");
        return CPPSettingsUtil.deduplicateNames(originalNames, "name (number)");
    }

    @NotNull
    public static final List<String> deduplicateNames(@NotNull List<String> originalNames, @NotNull String format) {
        boolean hasDuplicates;
        Intrinsics.checkParameterIsNotNull(originalNames, (String)"originalNames");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        ArrayList<String> result = new ArrayList<String>((Collection)originalNames);
        String string = Pattern.quote(format);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Pattern.quote(format)");
        String patterFormat = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"name", (String)"\\E(.*)\\Q", (boolean)false, (int)4, null), (String)"number", (String)"\\E(\\d+)\\Q", (boolean)false, (int)4, null);
        String stringFormat = StringsKt.replace$default((String)StringsKt.replace$default((String)format, (String)"name", (String)"%1$s", (boolean)false, (int)4, null), (String)"number", (String)"%2$d", (boolean)false, (int)4, null);
        Pattern pattern = Pattern.compile(patterFormat);
        do {
            hasDuplicates = false;
            THashSet added = new THashSet();
            int size = result.size();
            for (int i = 0; i < size; ++i) {
                String string2;
                String name2 = (String)result.get(i);
                if (added.add((Object)name2)) continue;
                hasDuplicates = true;
                int number = 0;
                Matcher matcher = pattern.matcher(name2);
                if (matcher.matches()) {
                    name2 = matcher.group(1);
                    number = StringUtil.parseInt((String)matcher.group(2), (int)number);
                }
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{name2, number + 1};
                int n = i;
                ArrayList<String> arrayList = result;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(stringFormat, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                arrayList.set(n, string2);
            }
        } while (hasDuplicates);
        return result;
    }

    public static final void checkDuplicatingNames(@NotNull List<String> allNames, @NotNull String elementDisplayName) throws ConfigurationException {
        Intrinsics.checkParameterIsNotNull(allNames, (String)"allNames");
        Intrinsics.checkParameterIsNotNull((Object)elementDisplayName, (String)"elementDisplayName");
        HashSet uniqueNames = new HashSet();
        LinkedHashSet<String> duplicatingNames = new LinkedHashSet<String>();
        Iterable $receiver$iv = allNames;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            if (uniqueNames.add((Object)it)) continue;
            duplicatingNames.add(it);
        }
        if (!duplicatingNames.isEmpty()) {
            int size = duplicatingNames.size();
            throw (Throwable)new ConfigurationException(StringUtil.pluralize((String)elementDisplayName, (int)size) + " " + StringUtil.join((Collection)duplicatingNames, (Function)checkDuplicatingNames.2.INSTANCE, (String)", ") + " already exist" + (size == 1 ? "s" : ""));
        }
    }
}

