/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteUtil {
    public static final int DEFAULT_COMMAND_TIMEOUT = 1000;
    public static final int TEST_CONNECTION_TIMEOUT = 10000;

    private RemoteUtil() {
    }

    @NotNull
    public static CapturingSshProcessHandler createRemoteProcess(@NotNull CidrToolEnvironment env, @NotNull GeneralCommandLine cmd, @NotNull RemoteCredentials credentials, boolean usePty) throws ExecutionException {
        if (env == null) {
            RemoteUtil.$$$reportNull$$$0(0);
        }
        if (cmd == null) {
            RemoteUtil.$$$reportNull$$$0(1);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(2);
        }
        CapturingSshProcessHandler capturingSshProcessHandler = RemoteUtil.createRemoteProcess(env, cmd, credentials, usePty, null, 0);
        if (capturingSshProcessHandler == null) {
            RemoteUtil.$$$reportNull$$$0(3);
        }
        return capturingSshProcessHandler;
    }

    @NotNull
    private static CapturingSshProcessHandler createRemoteProcess(@Nullable CidrToolEnvironment env, @NotNull GeneralCommandLine cmd, @NotNull RemoteCredentials credentials, boolean usePty, @Nullable ProgressIndicator indicator, int timeout) throws ExecutionException {
        CapturingSshProcessHandler capturingSshProcessHandler;
        block4: {
            if (cmd == null) {
                RemoteUtil.$$$reportNull$$$0(4);
            }
            if (credentials == null) {
                RemoteUtil.$$$reportNull$$$0(5);
            }
            RemoteUtil.prepare(cmd, env);
            try {
                ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, null, (ProgressIndicator)indicator);
                SshExecProcess process2 = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)cmd).withAllocatePty(usePty).withChangeDir(true).start(timeout);
                capturingSshProcessHandler = new CapturingSshProcessHandler((SshProcess)process2, cmd.getCharset(), cmd.getCommandLineString());
                if (capturingSshProcessHandler != null) break block4;
            }
            catch (Exception e) {
                throw new ExecutionException((Throwable)e);
            }
            RemoteUtil.$$$reportNull$$$0(6);
        }
        return capturingSshProcessHandler;
    }

    private static void prepare(@NotNull GeneralCommandLine cl, @Nullable CidrToolEnvironment env) {
        if (cl == null) {
            RemoteUtil.$$$reportNull$$$0(7);
        }
        if (env == null) {
            return;
        }
        File wd = cl.getWorkDirectory();
        if (wd != null) {
            cl.setWorkDirectory(env.toEnvPath(wd.getPath()));
        }
        String exe = cl.getExePath();
        cl.setExePath(env.toEnvPath(exe));
    }

    @NotNull
    public static ProcessOutput runRemoteProcess(@NotNull CidrToolEnvironment env, @NotNull GeneralCommandLine cl, @NotNull RemoteCredentials credentials, @Nullable ProgressIndicator indicator, int timeout) throws ExecutionException {
        if (env == null) {
            RemoteUtil.$$$reportNull$$$0(8);
        }
        if (cl == null) {
            RemoteUtil.$$$reportNull$$$0(9);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(10);
        }
        CapturingSshProcessHandler process2 = RemoteUtil.createRemoteProcess(env, cl, credentials, false, indicator, timeout);
        ProcessOutput processOutput = RemoteUtil.runRemoteProcess((ProcessHandler)process2);
        if (processOutput == null) {
            RemoteUtil.$$$reportNull$$$0(11);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput runRemoteProcess(@NotNull GeneralCommandLine cl, @NotNull RemoteCredentials credentials, int timeout) throws ExecutionException {
        if (cl == null) {
            RemoteUtil.$$$reportNull$$$0(12);
        }
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(13);
        }
        CapturingSshProcessHandler process2 = RemoteUtil.createRemoteProcess(null, cl, credentials, false, null, timeout);
        ProcessOutput processOutput = RemoteUtil.runRemoteProcess((ProcessHandler)process2);
        if (processOutput == null) {
            RemoteUtil.$$$reportNull$$$0(14);
        }
        return processOutput;
    }

    private static ProcessOutput runRemoteProcess(@NotNull ProcessHandler h) throws ExecutionException {
        if (h == null) {
            RemoteUtil.$$$reportNull$$$0(15);
        }
        assert (h instanceof CapturingSshProcessHandler);
        try {
            return ((CapturingSshProcessHandler)h).runProcess();
        }
        catch (SshTransportException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    public static void killProcessTree(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            RemoteUtil.$$$reportNull$$$0(16);
        }
        if (handler instanceof CapturingSshProcessHandler) {
            CapturingSshProcessHandler remoteProcess = (CapturingSshProcessHandler)handler;
            ((SshProcess)remoteProcess.getProcess()).killProcessTree();
        }
    }

    public static boolean checkConnection(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(17);
        }
        try {
            return RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials).connect(10000L, TimeUnit.MILLISECONDS).isConnected();
        }
        catch (SshTransportException sshTransportException) {
            return false;
        }
    }

    @NotNull
    public static NamedPipe openPipe(@NotNull RemoteCredentials credentials, @NotNull OSType osType) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(18);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(19);
        }
        if (osType == OSType.WIN) {
            throw new ExecutionException("Remote Windows pipes are not supported yet");
        }
        RemoteUnixPipe remoteUnixPipe = new RemoteUnixPipe(credentials, osType);
        if (remoteUnixPipe == null) {
            RemoteUtil.$$$reportNull$$$0(20);
        }
        return remoteUnixPipe;
    }

    private static void rmSilently(@NotNull RemoteCredentials credentials, @NotNull String path) {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(21);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(22);
        }
        try {
            if (!RemoteUtil.rm(credentials, path)) {
                CPPLog.LOG.warn("cannot remove file: " + path);
            }
        }
        catch (ExecutionException e) {
            CPPLog.LOG.warn("cannot remove file: " + path, (Throwable)e);
        }
    }

    public static boolean isFileExist(@NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(23);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(24);
        }
        return RemoteUtil.getSftpChannel(credentials).file(path).exists();
    }

    public static boolean rm(@NotNull RemoteCredentials credentials, @NotNull String path) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(25);
        }
        if (path == null) {
            RemoteUtil.$$$reportNull$$$0(26);
        }
        return RemoteUtil.getSftpChannel(credentials).file(path).rm();
    }

    @NotNull
    private static SftpChannel getSftpChannel(@NotNull RemoteCredentials credentials) throws ExecutionException {
        SftpChannel sftpChannel;
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(27);
        }
        try {
            sftpChannel = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials).openSftpChannel();
        }
        catch (SshTransportException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (sftpChannel == null) {
            RemoteUtil.$$$reportNull$$$0(28);
        }
        return sftpChannel;
    }

    @Nullable
    public static String getTempFileName(@NotNull RemoteCredentials credentials, @NotNull OSType osType) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(29);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(30);
        }
        RemoteUtil.assertUnixOnly(osType);
        GeneralCommandLine command = new GeneralCommandLine(new String[]{"mktemp", "-u"});
        ProcessOutput output = RemoteUtil.runRemoteProcess(command, credentials, 1000);
        return StringUtil.nullize((String)output.getStdout().trim());
    }

    @NotNull
    private static String createNamedPipe(@NotNull RemoteCredentials credentials, @NotNull OSType osType) throws ExecutionException {
        String tmpFileName;
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(31);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(32);
        }
        if ((tmpFileName = RemoteUtil.getTempFileName(credentials, osType)) == null) {
            throw new ExecutionException("Cannot create named pipe");
        }
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"mkfifo", tmpFileName});
        RemoteUtil.runRemoteProcess(cmd, credentials, 1000);
        String string = tmpFileName;
        if (string == null) {
            RemoteUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String mktemp(@NotNull RemoteCredentials credentials, @NotNull OSType osType) throws ExecutionException {
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(34);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(35);
        }
        String string = RemoteUtil.mktemp(credentials, osType, false);
        if (string == null) {
            RemoteUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public static String mktemp(@NotNull RemoteCredentials credentials, @NotNull OSType osType, boolean createDir) throws ExecutionException {
        ProcessOutput output;
        if (credentials == null) {
            RemoteUtil.$$$reportNull$$$0(37);
        }
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(38);
        }
        RemoteUtil.assertUnixOnly(osType);
        GeneralCommandLine command = new GeneralCommandLine(new String[]{"mktemp"});
        if (createDir) {
            command.addParameter("-d");
        }
        if ((output = RemoteUtil.runRemoteProcess(command, credentials, 1000)).isTimeout() || output.getExitCode() != 0) {
            throw new ExecutionException("Cannot create temp file: " + output.getStderr() + (output.isTimeout() ? "\nTimed out" : "\nExit code " + output.getExitCode()));
        }
        String path = StringUtil.nullize((String)output.getStdout().trim());
        if (path == null) {
            throw new ExecutionException("Cannot create temp file");
        }
        String string = path;
        if (string == null) {
            RemoteUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    private static void assertUnixOnly(@NotNull OSType osType) throws ExecutionException {
        if (osType == null) {
            RemoteUtil.$$$reportNull$$$0(40);
        }
        if (osType == OSType.WIN) {
            throw new ExecutionException((Throwable)new UnsupportedOperationException(osType.name()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 20: 
            case 28: 
            case 33: 
            case 36: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 20: 
            case 28: 
            case 33: 
            case 36: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 20: 
            case 28: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/RemoteUtil";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 19: 
            case 30: 
            case 32: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/RemoteUtil";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteProcess";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "runRemoteProcess";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "openPipe";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSftpChannel";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedPipe";
                break;
            }
            case 36: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "mktemp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteProcess";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 20: 
            case 28: 
            case 33: 
            case 36: 
            case 39: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runRemoteProcess";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkConnection";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "openPipe";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "rmSilently";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isFileExist";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "rm";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSftpChannel";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTempFileName";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createNamedPipe";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "mktemp";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "assertUnixOnly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 20: 
            case 28: 
            case 33: 
            case 36: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoteUnixPipe
    implements NamedPipe {
        @NotNull
        final OSType myOSType;
        @NotNull
        final RemoteCredentials myCredentials;
        @NotNull
        final String pipeName;
        @NotNull
        final SshExecProcess process;

        RemoteUnixPipe(@NotNull RemoteCredentials credentials, @NotNull OSType osType) throws ExecutionException {
            if (credentials == null) {
                RemoteUnixPipe.$$$reportNull$$$0(0);
            }
            if (osType == null) {
                RemoteUnixPipe.$$$reportNull$$$0(1);
            }
            this.myOSType = osType;
            this.myCredentials = credentials;
            this.pipeName = RemoteUtil.createNamedPipe(credentials, osType);
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"tee", this.pipeName});
            ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials);
            try {
                this.process = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)cmd).withAllocatePty(true).start();
            }
            catch (SshTransportException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.pipeName;
            if (string == null) {
                RemoteUnixPipe.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public OutputStream getOutputStream() {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.process.getOutputStream()){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        this.close();
                    }
                }
            };
            if (bufferedOutputStream == null) {
                RemoteUnixPipe.$$$reportNull$$$0(3);
            }
            return bufferedOutputStream;
        }

        @Override
        public void close() {
            this.process.destroy();
            RemoteUtil.rmSilently(this.myCredentials, this.pipeName);
        }

        @Override
        @NotNull
        public InputStream getInputStream() {
            throw new UnsupportedOperationException("TODO");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "osType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/RemoteUtil$RemoteUnixPipe";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/RemoteUtil$RemoteUnixPipe";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutputStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

