/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.actions.newFile;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.actions.newFile.NewFileHandler;
import com.jetbrains.cidr.cpp.actions.newFile.NewFileTarget;
import com.jetbrains.cidr.cpp.cmake.CMakeListsFileType;
import com.jetbrains.cidr.cpp.cmake.interpreter.CMakeInterpreter;
import com.jetbrains.cidr.cpp.cmake.interpreter.CMakeScope;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeArgument;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeCommand;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeFile;
import com.jetbrains.cidr.cpp.cmake.psi.util.CMakeFileLocationUtil;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeNewFileHandler
implements NewFileHandler<CMakeNewFileTarget> {
    @NotNull
    private final OCWorkspace myWorkspace;
    @NotNull
    private final CMakeWorkspace myCMakeWorkspace;
    @NotNull
    private final List<CMakeNewFileTarget> myTargets;

    public CMakeNewFileHandler(@NotNull Project project2) {
        if (project2 == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(0);
        }
        this.myWorkspace = OCWorkspace.getInstance(project2);
        this.myCMakeWorkspace = CMakeWorkspace.getInstance(project2);
        this.myTargets = CMakeNewFileHandler.readTargets(project2, this.myCMakeWorkspace);
    }

    @NotNull
    private static List<CMakeNewFileTarget> readTargets(@NotNull Project project2, @NotNull CMakeWorkspace workspace) {
        if (project2 == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(1);
        }
        if (workspace == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(2);
        }
        ArrayList<CMakeNewFileTarget> targets = new ArrayList<CMakeNewFileTarget>();
        for (File file : workspace.getCMakeDependencyFiles()) {
            PsiFile psiFile;
            VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vf == null || !FileIndexFacade.getInstance((Project)project2).isInContent(vf) || !((psiFile = PsiManager.getInstance((Project)project2).findFile(vf)) instanceof CMakeFile)) continue;
            CMakeNewFileHandler.collectTargets(targets, (CMakeFile)psiFile);
        }
        CMakeNewFileHandler.sortTargets(targets);
        List<CMakeNewFileTarget> list = Collections.unmodifiableList(targets);
        if (list == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(3);
        }
        return list;
    }

    static void collectTargets(@NotNull ArrayList<CMakeNewFileTarget> targets, @NotNull CMakeFile cf) {
        if (targets == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(4);
        }
        if (cf == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(5);
        }
        PsiDocumentManager.getInstance((Project)cf.getProject()).commitAllDocuments();
        final VarDependencies varDependencies = new VarDependencies();
        final Stack branchVarDependenciesStack = new Stack();
        final Stack controlVarDependenciesStack = new Stack();
        final MultiMap commands2Targets = MultiMap.createSet();
        final Set targetSet = ContainerUtil.set((Object[])new CMakeNewFileTarget[0]);
        CMakeInterpreter.interpret((PsiElement)cf, new CMakeInterpreter.Listener(){

            @Override
            public void beforeCommand(@NotNull CMakeCommand cmd, @NotNull CMakeScope scope) {
                String firstArg;
                String cmdName;
                if (cmd == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (scope == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (("add_executable".equals(cmdName = cmd.getName().toLowerCase(Locale.getDefault())) || "add_library".equals(cmdName)) && cmd.canAppendArguments()) {
                    final String targetName = CMakeNewFileHandler.getEffectiveFirstArg(cmd, scope);
                    if (targetName != null) {
                        targetSet.add(new CMakeNewFileTarget(cmd, Collections.singletonList(targetName), targetName, 1));
                        CMakeNewFileHandler.processCommandDependencies(cmd, varDependencies, new CommandDependencyHandler(){

                            @Override
                            public void handleDependency(@NotNull CommandInfo commandInfo) {
                                if (commandInfo == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                commands2Targets.putValue((Object)commandInfo, (Object)targetName);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandInfo", "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler$1$1", "handleDependency"));
                            }
                        });
                    }
                } else if ("set".equals(cmdName) && (firstArg = CMakeNewFileHandler.getEffectiveFirstArg(cmd, scope)) != null) {
                    String varRef = "${" + firstArg + "}";
                    final ArrayList<CommandInfo> deps = new ArrayList<CommandInfo>();
                    deps.add(new CommandInfo(varRef, cmd));
                    CMakeNewFileHandler.processCommandDependencies(cmd, varDependencies, new CommandDependencyHandler(){

                        @Override
                        public void handleDependency(@NotNull CommandInfo commandInfo) {
                            if (commandInfo == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            deps.add(commandInfo);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandInfo", "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler$1$2", "handleDependency"));
                        }
                    });
                    varDependencies.set(varRef, deps);
                }
            }

            @Override
            public void onEnterIf() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitIf() {
                this.afterControlStructure();
            }

            @Override
            public void onEnterWhile() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitWhile() {
                this.afterControlStructure();
            }

            @Override
            public void onEnterForeach() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitForeach() {
                this.afterControlStructure();
            }

            private void afterControlStructure() {
                varDependencies.setAll((VarDependencies)controlVarDependenciesStack.pop());
            }

            private void beforeControlStructure() {
                controlVarDependenciesStack.push(new VarDependencies(varDependencies));
            }

            @Override
            public boolean onEnterLoop(int iteration) {
                return true;
            }

            @Override
            public void onExitLoop() {
                ((VarDependencies)controlVarDependenciesStack.peek()).addAll(varDependencies);
            }

            @Override
            public void onEnterFunction() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitFunction() {
                this.afterControlStructure();
            }

            @Override
            public void onEnterMacro() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitMacro() {
                this.afterControlStructure();
            }

            @Override
            public boolean onEnterBranch(int branch) {
                branchVarDependenciesStack.push(new VarDependencies(varDependencies));
                return true;
            }

            @Override
            public void onExitBranch() {
                ((VarDependencies)controlVarDependenciesStack.peek()).addAll(varDependencies);
                varDependencies.setAll((VarDependencies)branchVarDependenciesStack.pop());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "cmd";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scope";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler$1";
                objectArray[2] = "beforeCommand";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        targets.addAll(targetSet);
        for (Map.Entry c2ts : commands2Targets.entrySet()) {
            CommandInfo info = (CommandInfo)c2ts.getKey();
            String varRef = info.varRef;
            CMakeCommand command = info.command;
            ArrayList<String> targetNames = new ArrayList<String>((Collection)c2ts.getValue());
            Collections.sort(targetNames, String.CASE_INSENSITIVE_ORDER);
            String targetsString = StringUtil.join(targetNames, (String)", ");
            String name2 = targetsString + " <- " + varRef;
            int selectionPriority = targetNames.size() > 1 ? 0 : 2;
            targets.add(new CMakeNewFileTarget(command, targetNames, name2, selectionPriority));
        }
    }

    private static void processCommandDependencies(@NotNull CMakeCommand cmd, @NotNull VarDependencies varDependencies, @NotNull CommandDependencyHandler handler) {
        List<CMakeArgument> argumentList;
        if (cmd == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(6);
        }
        if (varDependencies == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(7);
        }
        if (handler == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(8);
        }
        if ((argumentList = cmd.getCMakeArgumentList()) != null) {
            for (int i = 1; i < argumentList.size(); ++i) {
                CMakeArgument arg = argumentList.get(i);
                String varRef = arg.getValue();
                Collection<CommandInfo> dependencies = varDependencies.get(varRef);
                for (CommandInfo dependency : dependencies) {
                    handler.handleDependency(dependency);
                }
            }
        }
    }

    @Nullable
    private static String getEffectiveFirstArg(@NotNull CMakeCommand cmd, @NotNull CMakeScope scope) {
        List<CMakeArgument> args;
        CMakeArgument firstArg;
        if (cmd == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(10);
        }
        if ((firstArg = (CMakeArgument)ContainerUtil.getFirstItem(args = cmd.getCMakeArgumentList())) != null) {
            ArrayList<String> firstArgExpanded = new ArrayList<String>();
            CMakeInterpreter.expandArguments(Collections.singletonList(firstArg), scope, firstArgExpanded);
            String result = null;
            if (!firstArgExpanded.isEmpty()) {
                ArrayList<String> effectiveArgs = new ArrayList<String>();
                CMakeInterpreter.expandArguments(args, scope, effectiveArgs);
                result = (String)ContainerUtil.getFirstItem(effectiveArgs);
            }
            return result == null ? firstArg.getValue() : result;
        }
        return null;
    }

    @Override
    @NotNull
    public List<CMakeNewFileTarget> getTargets() {
        List<CMakeNewFileTarget> list = this.myTargets;
        if (list == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @Nullable
    public JComponent createPreviewComponent() {
        if (this.myTargets.isEmpty()) {
            return null;
        }
        CMakeNewFileTarget target = this.myTargets.get(0);
        Project project2 = target.myPointer.getProject();
        MyEditorTextField field = new MyEditorTextField(project2);
        field.setTarget(target);
        return field;
    }

    @Override
    public void updatePreviewComponent(@NotNull JComponent previewComponent, @Nullable CMakeNewFileTarget selectedTarget) {
        if (previewComponent == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(12);
        }
        previewComponent.setVisible(selectedTarget != null);
        if (selectedTarget != null) {
            MyEditorTextField etf = (MyEditorTextField)((Object)previewComponent);
            etf.setTarget(selectedTarget);
        }
    }

    @Override
    public void handleNewFiles(@NotNull List<Integer> selectedIndices, @NotNull List<VirtualFile> addedFiles) {
        if (selectedIndices == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(13);
        }
        if (addedFiles == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(14);
        }
        boolean changed = false;
        for (int i : selectedIndices) {
            CMakeNewFileTarget target = this.myTargets.get(i);
            changed |= target.addFiles(addedFiles);
        }
        if (changed) {
            this.myCMakeWorkspace.scheduleReload(false);
        }
    }

    @Override
    @NotNull
    public List<CMakeNewFileTarget> bestTargets(@Nullable PsiFile sampleFile, @Nullable String currentPath) {
        List<CMakeNewFileTarget> targets = this.myTargets;
        if (sampleFile != null) {
            ArrayList<CMakeNewFileTarget> result = new ArrayList<CMakeNewFileTarget>();
            VirtualFile vf = OCInclusionContextUtil.getVirtualFile(sampleFile);
            OCWorkspace workspace = OCWorkspace.getInstance(sampleFile.getProject());
            CMakeWorkspace cmakeWorkspace = CMakeWorkspace.getInstance(sampleFile.getProject());
            for (CMakeTarget ct : CMakeNewFileHandler.collectUniqueTargets(workspace, cmakeWorkspace, vf)) {
                CMakeNewFileTarget t = CMakeNewFileHandler.bestTargetByCMakeTarget(targets, ct);
                if (t == null) continue;
                result.add(t);
            }
            if (!result.isEmpty()) {
                CMakeNewFileHandler.sortTargets(result);
                ArrayList<CMakeNewFileTarget> arrayList = result;
                if (arrayList == null) {
                    CMakeNewFileHandler.$$$reportNull$$$0(15);
                }
                return arrayList;
            }
        }
        Pair best = null;
        if (currentPath != null) {
            List<CMakeNewFileTarget> bestByPath = this.bestTargetsByCurrentDirFiles(targets, currentPath);
            if (bestByPath.isEmpty()) {
                bestByPath = targets;
            }
            List ts = ContainerUtil.map(bestByPath, target -> Pair.create((Object)target, (Object)target.calcRelativePath(currentPath)));
            for (Pair t : ts) {
                if (!CMakeNewFileHandler.isBetterTarget((Pair<CMakeNewFileTarget, String>)t, best)) continue;
                best = t;
            }
        }
        List<Object> list = best == null ? Collections.emptyList() : Collections.singletonList(best.first);
        if (list == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<CMakeNewFileTarget> bestTargetsByCurrentDirFiles(@NotNull List<CMakeNewFileTarget> fileTargets, @NotNull String currentPath) {
        if (fileTargets == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(17);
        }
        if (currentPath == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(18);
        }
        TObjectIntHashMap targetToFileCount = new TObjectIntHashMap(ContainerUtil.identityStrategy());
        VirtualFile currentDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(currentPath));
        if (currentDir != null && currentDir.isDirectory()) {
            for (VirtualFile file : currentDir.getChildren()) {
                if (file.isDirectory()) continue;
                for (CMakeTarget t : CMakeNewFileHandler.collectUniqueTargets(this.myWorkspace, this.myCMakeWorkspace, file)) {
                    int i = targetToFileCount.get((Object)t);
                    targetToFileCount.put((Object)t, i + 1);
                }
            }
        }
        final ArrayList cts = new ArrayList();
        targetToFileCount.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<CMakeTarget>(){

            public boolean execute(CMakeTarget t, int count) {
                cts.add(Pair.create((Object)t, (Object)count));
                return true;
            }
        });
        if (cts.isEmpty()) {
            List<CMakeNewFileTarget> list = Collections.emptyList();
            if (list == null) {
                CMakeNewFileHandler.$$$reportNull$$$0(19);
            }
            return list;
        }
        Collections.sort(cts, (o1, o2) -> Comparing.compare((Comparable)((Comparable)o2.second), (Comparable)((Comparable)o1.second)));
        ArrayList<CMakeNewFileTarget> result = new ArrayList<CMakeNewFileTarget>();
        int maxCount = (Integer)((Pair)cts.get((int)0)).second;
        for (Pair ct : cts) {
            if ((Integer)ct.second < maxCount) break;
            CMakeNewFileTarget target = CMakeNewFileHandler.bestTargetByCMakeTarget(fileTargets, (CMakeTarget)ct.first);
            if (target == null) continue;
            result.add(target);
        }
        CMakeNewFileHandler.sortTargets(result);
        ArrayList<CMakeNewFileTarget> arrayList = result;
        if (arrayList == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Nullable
    private static CMakeNewFileTarget bestTargetByCMakeTarget(@NotNull List<CMakeNewFileTarget> targets, @NotNull CMakeTarget cMakeTarget) {
        if (targets == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(21);
        }
        if (cMakeTarget == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(22);
        }
        String tName = cMakeTarget.getName();
        CMakeNewFileTarget best = null;
        for (CMakeNewFileTarget candidate : targets) {
            List<String> names = candidate.getTargetNames();
            if (names.size() != 1 || !names.get(0).equals(tName)) continue;
            if (best == null) {
                best = candidate;
                continue;
            }
            int so = CMakeNewFileTarget.selectionOrder().compare(candidate, best);
            if (so <= 0 && (so != 0 || CMakeNewFileTarget.fileOrder().compare(candidate, best) <= 0)) continue;
            best = candidate;
        }
        return best;
    }

    @NotNull
    private static THashSet<CMakeTarget> collectUniqueTargets(OCWorkspace ws, @NotNull CMakeWorkspace cmake, @Nullable VirtualFile file) {
        if (cmake == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(23);
        }
        THashSet result = ContainerUtil.newIdentityTroveSet();
        for (OCResolveConfiguration c : ws.getConfigurationsForFile(file)) {
            CMakeConfiguration cmakeConfig = cmake.getCMakeConfigurationFor(c);
            if (cmakeConfig == null) continue;
            result.add((Object)cmakeConfig.getTarget());
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(24);
        }
        return tHashSet;
    }

    private static boolean isBetterTarget(@NotNull Pair<CMakeNewFileTarget, String> candidate, @Nullable Pair<CMakeNewFileTarget, String> best) {
        int bLength;
        boolean bDots;
        boolean bAbs;
        if (candidate == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(25);
        }
        if (best == null) {
            return true;
        }
        String cp = (String)candidate.second;
        String bp = (String)best.second;
        if (Comparing.equal((String)cp, (String)bp)) {
            CMakeNewFileTarget ct = (CMakeNewFileTarget)candidate.first;
            CMakeNewFileTarget bt = (CMakeNewFileTarget)best.first;
            int so = CMakeNewFileTarget.selectionOrder().compare(ct, bt);
            if (so != 0) {
                return so > 0;
            }
            int no = CMakeNewFileTarget.nameOrder().compare(ct, bt);
            return no != 0 ? no < 0 : CMakeNewFileTarget.fileOrder().compare(ct, bt) > 0;
        }
        boolean cAbs = FileUtil.isAbsolute((String)cp);
        if (cAbs != (bAbs = FileUtil.isAbsolute((String)bp))) {
            return !cAbs;
        }
        boolean cDots = cp.startsWith("..");
        if (cDots != (bDots = bp.startsWith(".."))) {
            return !cDots;
        }
        boolean cCurrentDir = cp.isEmpty();
        boolean bCurrentDir = bp.isEmpty();
        if (cCurrentDir || bCurrentDir) {
            return !bCurrentDir;
        }
        int cLength = cp.split("/").length;
        return cLength < (bLength = bp.split("/").length);
    }

    private static void sortTargets(@NotNull List<CMakeNewFileTarget> targets) {
        if (targets == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(26);
        }
        Collections.sort(targets, CMakeNewFileTarget.visualOrder());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler";
                break;
            }
            case 4: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cf";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varDependencies";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewComponent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedIndices";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTargets";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cMakeTarget";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmake";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readTargets";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "bestTargets";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "bestTargetsByCurrentDirFiles";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUniqueTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readTargets";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectTargets";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processCommandDependencies";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveFirstArg";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updatePreviewComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleNewFiles";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "bestTargetsByCurrentDirFiles";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "bestTargetByCMakeTarget";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectUniqueTargets";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isBetterTarget";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sortTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEditorTextField
    extends EditorTextField {
        private CMakeNewFileTarget myTarget;

        public MyEditorTextField(Project project2) {
            super(null, project2, CMakeListsFileType.INSTANCE, true, false);
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.setFont(scheme.getFont(EditorFontType.PLAIN));
            this.setPreferredSize(new Dimension(500, 130));
            this.setMinimumSize(new Dimension(500, 130));
            this.setFocusable(false);
            this.setFocusTraversalPolicyProvider(false);
        }

        protected EditorEx createEditor() {
            CMakeNewFileTarget target = this.myTarget;
            CPPLog.LOG.assertTrue(target != null);
            this.initDocument(target);
            return MyEditorTextField.configureNewEditor(target, super.createEditor());
        }

        private static EditorEx configureNewEditor(@NotNull CMakeNewFileTarget target, @NotNull EditorEx editor) {
            if (target == null) {
                MyEditorTextField.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyEditorTextField.$$$reportNull$$$0(1);
            }
            editor.setBackgroundColor(EditorFragmentComponent.getBackgroundColor((Editor)editor));
            editor.setVerticalScrollbarVisible(true);
            editor.setHorizontalScrollbarVisible(true);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (editor == null) {
                    MyEditorTextField.$$$reportNull$$$0(5);
                }
                if (target == null) {
                    MyEditorTextField.$$$reportNull$$$0(6);
                }
                if (!editor.isDisposed()) {
                    MyEditorTextField.updateWithTarget((Editor)editor, target);
                }
            });
            return editor;
        }

        public void setTarget(@NotNull CMakeNewFileTarget target) {
            if (target == null) {
                MyEditorTextField.$$$reportNull$$$0(2);
            }
            this.myTarget = target;
            this.initDocument(target);
            MyEditorTextField.updateWithTarget(this.getEditor(), target);
        }

        private static void updateWithTarget(@Nullable Editor editor, @NotNull CMakeNewFileTarget target) {
            if (target == null) {
                MyEditorTextField.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                return;
            }
            CMakeCommand element = target.getCommand();
            if (element == null) {
                return;
            }
            int startOffset = element.getTextOffset();
            editor.getCaretModel().moveToOffset(startOffset);
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.CENTER);
            scrollingModel.enableAnimation();
            MarkupModel model2 = editor.getMarkupModel();
            model2.removeAllHighlighters();
            TextRange range = element.getTextRange();
            TextAttributes attributes = editor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            model2.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5500, attributes, HighlighterTargetArea.EXACT_RANGE);
        }

        private void initDocument(@NotNull CMakeNewFileTarget target) {
            PsiFile file;
            if (target == null) {
                MyEditorTextField.$$$reportNull$$$0(4);
            }
            CPPLog.LOG.assertTrue((file = target.myPointer.getContainingFile()) != null);
            Project project2 = file.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
            if (document != this.getDocument()) {
                this.setDocument(document);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler$MyEditorTextField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configureNewEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTarget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateWithTarget";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initDocument";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$configureNewEditor$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CMakeNewFileTarget
    implements NewFileTarget {
        @NotNull
        private final SmartPsiElementPointer<CMakeCommand> myPointer;
        @NotNull
        private final List<String> myTargetNames;
        @NotNull
        private final String myName;
        @NotNull
        private final String myAdditionalInfo;
        private final int mySelectionPriority;
        private static final Comparator<CMakeNewFileTarget> FILE_ORDER = (o1, o2) -> {
            CMakeCommand c1 = o1.getCommand();
            CMakeCommand c2 = o2.getCommand();
            if (c1 == null) {
                return c2 == null ? 0 : 1;
            }
            if (c2 == null) {
                return -1;
            }
            return Comparing.compare((int)c1.getTextOffset(), (int)c2.getTextOffset());
        };
        private static final Comparator<CMakeNewFileTarget> NAME_ORDER = (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getSingleTargetNameOrFullName(), o2.getSingleTargetNameOrFullName());
        private static final Comparator<CMakeNewFileTarget> SELECTION_ORDER = (o1, o2) -> Comparing.compare((int)o1.getSelectionPriority(), (int)o2.getSelectionPriority());
        private static final Comparator<CMakeNewFileTarget> VISUAL_ORDER = (o1, o2) -> {
            int compare = NAME_ORDER.compare((CMakeNewFileTarget)o1, (CMakeNewFileTarget)o2);
            return compare != 0 ? compare : FILE_ORDER.compare((CMakeNewFileTarget)o1, (CMakeNewFileTarget)o2);
        };

        public CMakeNewFileTarget(@NotNull CMakeCommand command, @NotNull List<String> targetNames, @NotNull String name2, int selectionPriority) {
            if (command == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(0);
            }
            if (targetNames == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(2);
            }
            this.mySelectionPriority = selectionPriority;
            this.myTargetNames = new ArrayList<String>(targetNames);
            this.myName = name2;
            this.myPointer = SmartPointerManager.getInstance((Project)command.getProject()).createSmartPsiElementPointer((PsiElement)command);
            this.myAdditionalInfo = CMakeFileLocationUtil.getLocationInFile(command, true);
        }

        @Override
        public boolean addFiles(@NotNull List<VirtualFile> addedFiles) {
            if (addedFiles == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(3);
            }
            this.myPointer.getVirtualFile().refresh(false, false);
            CMakeCommand command = this.getCommand();
            if (command == null) {
                return false;
            }
            boolean changed = false;
            for (VirtualFile file : addedFiles) {
                String fp = file.getPath();
                String resultPath = this.calcRelativePath(fp);
                command.appendArgument(resultPath);
                changed = true;
            }
            return changed;
        }

        @NotNull
        public String calcRelativePath(@NotNull String filePath) {
            PsiFile cmdFile;
            if (filePath == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(4);
            }
            String root = (cmdFile = this.myPointer.getContainingFile()) == null ? null : cmdFile.getVirtualFile().getParent().getPath();
            String relativePath = root == null ? null : FileUtil.getRelativePath((File)new File(root), (File)new File(filePath));
            String string = FileUtil.toCanonicalPath((String)(relativePath == null ? filePath : relativePath));
            if (string == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(5);
            }
            return string;
        }

        public int getSelectionPriority() {
            return this.mySelectionPriority;
        }

        @NotNull
        public List<String> getTargetNames() {
            List<String> list = this.myTargetNames;
            if (list == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Override
        @NotNull
        public String getAdditionalInfo() {
            String string = this.myAdditionalInfo;
            if (string == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Nullable
        private CMakeCommand getCommand() {
            CMakeCommand command = (CMakeCommand)this.myPointer.getElement();
            return command != null && command.isValid() ? command : null;
        }

        public String toString() {
            return this.getName();
        }

        @NotNull
        public static Comparator<CMakeNewFileTarget> visualOrder() {
            Comparator<CMakeNewFileTarget> comparator = VISUAL_ORDER;
            if (comparator == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(9);
            }
            return comparator;
        }

        @NotNull
        public static Comparator<CMakeNewFileTarget> nameOrder() {
            Comparator<CMakeNewFileTarget> comparator = NAME_ORDER;
            if (comparator == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(10);
            }
            return comparator;
        }

        @NotNull
        public static Comparator<CMakeNewFileTarget> selectionOrder() {
            Comparator<CMakeNewFileTarget> comparator = SELECTION_ORDER;
            if (comparator == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(11);
            }
            return comparator;
        }

        @NotNull
        public static Comparator<CMakeNewFileTarget> fileOrder() {
            Comparator<CMakeNewFileTarget> comparator = FILE_ORDER;
            if (comparator == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(12);
            }
            return comparator;
        }

        @NotNull
        private String getSingleTargetNameOrFullName() {
            String string = this.myTargetNames.size() == 1 ? this.myTargetNames.get(0) : this.myName;
            if (string == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(13);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CMakeNewFileTarget target = (CMakeNewFileTarget)o;
            return this.myPointer.equals(target.myPointer);
        }

        public int hashCode() {
            return this.myPointer.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetNames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addedFiles";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler$CMakeNewFileTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler$CMakeNewFileTarget";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcRelativePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetNames";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalInfo";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visualOrder";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nameOrder";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectionOrder";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileOrder";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSingleTargetNameOrFullName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addFiles";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcRelativePath";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface CommandDependencyHandler {
        public void handleDependency(@NotNull CommandInfo var1);
    }

    private static class CommandInfo {
        @NotNull
        final String varRef;
        @NotNull
        final CMakeCommand command;

        private CommandInfo(@NotNull String name2, @NotNull CMakeCommand command) {
            if (name2 == null) {
                CommandInfo.$$$reportNull$$$0(0);
            }
            if (command == null) {
                CommandInfo.$$$reportNull$$$0(1);
            }
            this.varRef = name2;
            this.command = command;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandInfo that = (CommandInfo)o;
            if (!this.varRef.equals(that.varRef)) {
                return false;
            }
            return this.command.equals(that.command);
        }

        public int hashCode() {
            int result = this.varRef.hashCode();
            result = 31 * result + this.command.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler$CommandInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VarDependencies {
        final MultiMap<String, CommandInfo> myMap;

        public VarDependencies() {
            this.myMap = MultiMap.createSet();
        }

        public VarDependencies(@NotNull VarDependencies original) {
            if (original == null) {
                VarDependencies.$$$reportNull$$$0(0);
            }
            this();
            this.myMap.putAllValues(original.myMap);
        }

        @NotNull
        public Collection<CommandInfo> get(@NotNull String varRef) {
            if (varRef == null) {
                VarDependencies.$$$reportNull$$$0(1);
            }
            Collection collection = this.myMap.get((Object)varRef);
            if (collection == null) {
                VarDependencies.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public void set(@NotNull String varRef, @NotNull Collection<CommandInfo> deps) {
            if (varRef == null) {
                VarDependencies.$$$reportNull$$$0(3);
            }
            if (deps == null) {
                VarDependencies.$$$reportNull$$$0(4);
            }
            this.myMap.remove((Object)varRef);
            this.myMap.put((Object)varRef, deps);
        }

        public void setAll(@NotNull VarDependencies original) {
            if (original == null) {
                VarDependencies.$$$reportNull$$$0(5);
            }
            this.myMap.clear();
            this.addAll(original);
        }

        public void addAll(@NotNull VarDependencies original) {
            if (original == null) {
                VarDependencies.$$$reportNull$$$0(6);
            }
            this.myMap.putAllValues(original.myMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varRef";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler$VarDependencies";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/actions/newFile/CMakeNewFileHandler$VarDependencies";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "set";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setAll";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addAll";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

