/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.actions.newFile;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.cpp.actions.newFile.CMakeNewFileHandler;
import com.jetbrains.cidr.cpp.actions.newFile.NewFileHandler;
import com.jetbrains.cidr.cpp.actions.newFile.NewFileTarget;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.actions.newFile.DialogWrapperFacade;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelper;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperUtil;
import com.jetbrains.cidr.lang.settings.OCCppNewDialogSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPNewFileHelperProvider
implements OCNewFileHelperProvider {
    @Override
    @NotNull
    public OCNewFileHelper createHelper() {
        Helper helper = new Helper();
        if (helper == null) {
            CPPNewFileHelperProvider.$$$reportNull$$$0(0);
        }
        return helper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/actions/newFile/CPPNewFileHelperProvider", "createHelper"));
    }

    private static class Helper
    implements OCNewFileHelper {
        private Project myProject;
        private PsiFile mySampleFile;

        private Helper() {
        }

        @Override
        public boolean isAvailable(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                Helper.$$$reportNull$$$0(0);
            }
            return CommonDataKeys.PROJECT.getData(dataContext) != null;
        }

        @Override
        public boolean initFromDataContext(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                Helper.$$$reportNull$$$0(1);
            }
            this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            return this.myProject != null;
        }

        @Override
        public boolean initFromFile(@NotNull PsiFile file) {
            if (file == null) {
                Helper.$$$reportNull$$$0(2);
            }
            this.myProject = file.getProject();
            this.mySampleFile = file;
            return true;
        }

        @Override
        @NotNull
        public String getDefaultClassPrefix() {
            if ("" == null) {
                Helper.$$$reportNull$$$0(3);
            }
            return "";
        }

        @Override
        public boolean canChangeDir() {
            return false;
        }

        @Override
        @NotNull
        public DialogWrapper createDialog(final @NotNull OCNewFileActionBase.CreateFileDialogBase peer, @Nullable PsiDirectory selectedDir, @Nullable DataContext dataContext) {
            if (peer == null) {
                Helper.$$$reportNull$$$0(4);
            }
            CMakeNewFileHandler handler = new CMakeNewFileHandler(this.myProject);
            Dialog dialog = new Dialog(peer, handler, this.mySampleFile){

                @Nullable
                protected String getHelpId() {
                    return peer.getHelpId();
                }
            };
            if (dialog == null) {
                Helper.$$$reportNull$$$0(5);
            }
            return dialog;
        }

        @Override
        public void setProperties(@Nullable DialogWrapper dialog, Properties properties, @Nullable PsiFile sampleFile, Project project2) {
            CMakeModel model2 = CMakeWorkspace.getInstance(project2).getModel();
            String projectName = model2 == null ? project2.getName() : model2.getProjectName();
            OCNewFileHelperUtil.fillCommonTemplateProperties(properties, projectName);
        }

        @Override
        public void doCreateFiles(@NotNull Project project2, @NotNull PsiDirectory directory, @NotNull String[] fileNames, @NotNull PsiFile[] resultElements, @Nullable DialogWrapper dialog, @Nullable PsiFile sampleFile) {
            if (project2 == null) {
                Helper.$$$reportNull$$$0(6);
            }
            if (directory == null) {
                Helper.$$$reportNull$$$0(7);
            }
            if (fileNames == null) {
                Helper.$$$reportNull$$$0(8);
            }
            if (resultElements == null) {
                Helper.$$$reportNull$$$0(9);
            }
            ArrayList<VirtualFile> addedFiles = new ArrayList<VirtualFile>();
            Function handler = file -> {
                addedFiles.add((VirtualFile)file);
                return null;
            };
            OCNewFileHelperUtil.addCreatedFiles(directory, fileNames, resultElements, project2, (Function<VirtualFile, Void>)handler);
            if (dialog instanceof Dialog) {
                ((Dialog)dialog).handleNewFiles(addedFiles);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/actions/newFile/CPPNewFileHelperProvider$Helper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "peer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileNames";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/actions/newFile/CPPNewFileHelperProvider$Helper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultClassPrefix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "initFromDataContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "initFromFile";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDialog";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "doCreateFiles";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Dialog
        extends DialogWrapper
        implements DialogWrapperFacade {
            @NotNull
            private final OCNewFileActionBase.CreateFileDialogBase myPeer;
            @NotNull
            private final NewFileHandler<NewFileTarget> myHandler;
            @Nullable
            private final PsiFile mySampleFile;
            private JCheckBox myAddToProjectCheckBox;
            private CheckBoxList<NewFileTarget> myTargetCheckBoxList;
            private JComponent myPreviewComponent;

            public Dialog(@NotNull OCNewFileActionBase.CreateFileDialogBase peer, @NotNull NewFileHandler handler, @Nullable PsiFile sampleFile) {
                if (peer == null) {
                    Dialog.$$$reportNull$$$0(0);
                }
                if (handler == null) {
                    Dialog.$$$reportNull$$$0(1);
                }
                super(false);
                this.myPeer = peer;
                this.myHandler = handler;
                this.mySampleFile = sampleFile;
                peer.setWrapper(this);
                this.setTitle(peer.getTitle());
                this.init();
            }

            @Nullable
            protected JComponent createCenterPanel() {
                FormBuilder formBuilder = FormBuilder.createFormBuilder().setVertical(false);
                this.myPeer.fillGenericControls(formBuilder);
                this.myTargetCheckBoxList = new CheckBoxList<NewFileTarget>(new DefaultListModel()){

                    @Nullable
                    protected String getSecondaryText(int index) {
                        NewFileTarget target = (NewFileTarget)this.getItemAt(index);
                        return target == null ? "" : target.getAdditionalInfo();
                    }
                };
                this.myTargetCheckBoxList.getEmptyText().setText(OCBundle.message("create.tooltip.no.targets", new Object[0]));
                this.myTargetCheckBoxList.setBorder(null);
                List<NewFileTarget> targets = this.myHandler.getTargets();
                boolean hasTargets = !targets.isEmpty();
                this.myTargetCheckBoxList.setItems(targets, FunctionUtil.string());
                JBScrollPane scrollPane = new JBScrollPane(this.myTargetCheckBoxList, 20, 31);
                this.myAddToProjectCheckBox = new NonFocusableCheckBox(OCBundle.message("create.checkbox.targets", new Object[0]));
                DialogUtil.registerMnemonic((AbstractButton)this.myAddToProjectCheckBox, (char)'&');
                this.myAddToProjectCheckBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        this.updateTargetControlsState();
                    }
                });
                boolean addNewFilesToTheProject = OCCppNewDialogSettings.getInstance().shouldAddNewFilesToTheProject();
                this.myAddToProjectCheckBox.setSelected(hasTargets && addNewFilesToTheProject);
                this.myAddToProjectCheckBox.setEnabled(hasTargets);
                formBuilder.addComponent((JComponent)this.myAddToProjectCheckBox);
                formBuilder.setFormLeftIndent(20);
                formBuilder.addComponent((JComponent)scrollPane);
                if (hasTargets) {
                    this.myPreviewComponent = this.myHandler.createPreviewComponent();
                    if (this.myPreviewComponent != null) {
                        formBuilder.addComponent(this.myPreviewComponent);
                        this.myTargetCheckBoxList.addListSelectionListener(new ListSelectionListener(){

                            @Override
                            public void valueChanged(ListSelectionEvent e) {
                                int index = myTargetCheckBoxList.getSelectedIndex();
                                NewFileTarget target = index < 0 ? null : (NewFileTarget)myTargetCheckBoxList.getItemAt(index);
                                myHandler.updatePreviewComponent(myPreviewComponent, target);
                            }
                        });
                    }
                }
                this.myPeer.validateOkAction();
                JPanel myMainPanel = formBuilder.getPanel();
                JPanel result = new JPanel(new BorderLayout());
                result.add((Component)myMainPanel, "Center");
                if (hasTargets) {
                    this.selectBestTarget(this.myHandler, this.myPeer.getSelectedPath());
                }
                this.updateTargetControlsState();
                return result;
            }

            public void updateTargetControlsState() {
                boolean shouldAddToProject = this.myAddToProjectCheckBox.isSelected();
                this.myTargetCheckBoxList.setEnabled(shouldAddToProject);
                if (this.myPreviewComponent != null) {
                    this.myPreviewComponent.setVisible(shouldAddToProject);
                }
            }

            private void selectBestTarget(@NotNull NewFileHandler<NewFileTarget> handler, @Nullable String currentPath) {
                if (handler == null) {
                    Dialog.$$$reportNull$$$0(2);
                }
                List<NewFileTarget> bestTargets = handler.bestTargets(this.mySampleFile, currentPath);
                int defaultPreviewItemIdx = 0;
                if (!bestTargets.isEmpty()) {
                    for (NewFileTarget target : bestTargets) {
                        this.myTargetCheckBoxList.setItemSelected((Object)target, true);
                    }
                    Integer firstSelected = (Integer)ContainerUtil.getFirstItem(Dialog.getSelectedIndices(this.myTargetCheckBoxList));
                    if (firstSelected != null) {
                        defaultPreviewItemIdx = firstSelected;
                        this.myTargetCheckBoxList.ensureIndexIsVisible(firstSelected.intValue());
                    }
                }
                if (!this.myTargetCheckBoxList.isEmpty() && this.myPreviewComponent != null) {
                    this.myHandler.updatePreviewComponent(this.myPreviewComponent, (NewFileTarget)this.myTargetCheckBoxList.getItemAt(defaultPreviewItemIdx));
                    this.myTargetCheckBoxList.setSelectedIndex(defaultPreviewItemIdx);
                }
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.myPeer.getPreferredFocusedComponent();
            }

            protected void doOKAction() {
                if (this.myPeer.checkCanDoOKAction()) {
                    super.doOKAction();
                }
            }

            @Override
            public void setOKEnabled(boolean isEnable) {
                this.setOKActionEnabled(isEnable);
            }

            @Override
            public void setErrorMessage(@Nullable String text) {
                this.setErrorText(text);
            }

            protected void dispose() {
                super.dispose();
                Disposer.dispose((Disposable)this.myPeer.getDisposable());
            }

            public void handleNewFiles(ArrayList<VirtualFile> addedFiles) {
                boolean addToTheProject = this.myAddToProjectCheckBox.isSelected();
                OCCppNewDialogSettings.getInstance().setAddNewFilesToTheProject(addToTheProject);
                UsageTrigger.trigger((String)"cidr.newFile");
                if (addToTheProject) {
                    UsageTrigger.trigger((String)"cidr.newFile.addedToProject");
                    List<Integer> selectedIndices = Dialog.getSelectedIndices(this.myTargetCheckBoxList);
                    this.myHandler.handleNewFiles(selectedIndices, addedFiles);
                }
            }

            @NotNull
            public static List<Integer> getSelectedIndices(CheckBoxList<NewFileTarget> checkBoxList) {
                ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
                for (int i = 0; i < checkBoxList.getItemsCount(); ++i) {
                    if (!checkBoxList.isItemSelected(i)) continue;
                    selectedIndices.add(i);
                }
                ArrayList<Integer> arrayList = selectedIndices;
                if (arrayList == null) {
                    Dialog.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "peer";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/actions/newFile/CPPNewFileHelperProvider$Helper$Dialog";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/actions/newFile/CPPNewFileHelperProvider$Helper$Dialog";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedIndices";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "selectBestTarget";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

